/*
 * Decompiled with CFR 0.152.
 */
package com.xunlei.channel.gateway.pay.channels.ext19paywireless;

import com.google.common.base.Strings;
import com.xunlei.channel.gateway.pay.channels.ext19paywireless.Ext19PayWirelessChannelData;
import com.xunlei.xlcommons.util.Arith.Arith;
import com.xunlei.xlcommons.util.MD5.Md5Encrypt;
import com.xunlei.xlcommons.util.encrypt.DESEncrypt;
import java.util.HashMap;
import java.util.Map;
import org.dom4j.Document;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Ext19PayWirelessUtil {
    private static final Logger logger = LoggerFactory.getLogger(Ext19PayWirelessUtil.class);

    public static Map<String, String> createPostParams(Ext19PayWirelessChannelData ext19WirelessPayChannelData) {
        String orderDate = ext19WirelessPayChannelData.getOrderDate();
        String pmId = ext19WirelessPayChannelData.getPmId();
        String pcId = ext19WirelessPayChannelData.getPcId();
        String cardAmt = ext19WirelessPayChannelData.getCardAmt();
        String versionId = ext19WirelessPayChannelData.getVersionId();
        String merchantId = ext19WirelessPayChannelData.getMerchantId();
        String merchantKey = ext19WirelessPayChannelData.getMerchantKey();
        String currency = ext19WirelessPayChannelData.getCurrency();
        String orderId = ext19WirelessPayChannelData.getOrderId();
        if (Strings.isNullOrEmpty((String)orderDate) || Strings.isNullOrEmpty((String)versionId) || Strings.isNullOrEmpty((String)merchantId) || Strings.isNullOrEmpty((String)merchantKey) || Strings.isNullOrEmpty((String)currency) || Strings.isNullOrEmpty((String)pmId) || Strings.isNullOrEmpty((String)pcId) || Strings.isNullOrEmpty((String)cardAmt) || Strings.isNullOrEmpty((String)orderId)) {
            logger.info("orderDate:{},versionId:{},merchantId:{},merchantKey:{},currency:{},pmId:{},pcId:{},cardAmt:{},payUrl:{},orderId:{} is null,createPayUrl failed,return", new Object[]{orderDate, versionId, merchantId, merchantKey, currency, pmId, pcId, cardAmt, orderId});
            return null;
        }
        try {
            String cardNum1Des = DESEncrypt.encryptData((String)ext19WirelessPayChannelData.getCardNo(), (String)merchantKey.substring(0, 8));
            String cardNum2Des = ext19WirelessPayChannelData.getCardPwd();
            StringBuffer md5Str = new StringBuffer();
            md5Str.append("version_id=").append(versionId).append("&merchant_id=").append(merchantId).append("&order_date=").append(orderDate).append("&order_id=").append(orderId).append("&amount=").append(ext19WirelessPayChannelData.getOrderAmt()).append("&currency=").append(currency).append("&cardnum1=").append(cardNum1Des).append("&cardnum2=").append(cardNum2Des).append("&pm_id=").append(pmId).append("&pc_id=").append(pcId).append("&merchant_key=").append(merchantKey);
            String sign = Md5Encrypt.encode((String)md5Str.toString(), (String)"UTF-8");
            logger.info("md5Str:{} after md5 sign:{}", new Object[]{md5Str, sign});
            if (sign == null) {
                return null;
            }
            sign = sign.toLowerCase();
            String retUrl = ext19WirelessPayChannelData.getRetUrl();
            String retMode = ext19WirelessPayChannelData.getRetMode();
            String notifyUrl = ext19WirelessPayChannelData.getNotifyUrl();
            HashMap<String, String> paramMap = new HashMap<String, String>();
            paramMap.put("version_id", versionId);
            paramMap.put("merchant_id", merchantId);
            paramMap.put("verifystring", sign);
            paramMap.put("order_date", orderDate);
            paramMap.put("order_id", orderId);
            paramMap.put("amount", ext19WirelessPayChannelData.getOrderAmt());
            paramMap.put("currency", currency);
            paramMap.put("cardnum1", cardNum1Des);
            paramMap.put("cardnum2", cardNum2Des);
            paramMap.put("pm_id", ext19WirelessPayChannelData.getPmId());
            paramMap.put("pc_id", ext19WirelessPayChannelData.getPcId());
            paramMap.put("returl", retUrl);
            paramMap.put("notify_url", notifyUrl);
            paramMap.put("retmode", retMode);
            paramMap.put("select_amount", cardAmt);
            paramMap.put("order_pdesc", "");
            paramMap.put("user_name", "");
            paramMap.put("user_phone", "");
            paramMap.put("user_mobile", "");
            paramMap.put("user_email", "");
            return paramMap;
        }
        catch (Exception e) {
            logger.error("", (Throwable)e);
            return null;
        }
    }

    public static Map<String, String> getReturnCodeFromSyncResp(String xmlStr, Ext19PayWirelessChannelData data) {
        HashMap<String, String> map = new HashMap<String, String>();
        try {
            Document doc = DocumentHelper.parseText((String)xmlStr);
            Element root = doc.getRootElement();
            String versionIdResp = Ext19PayWirelessUtil.getNotEmptyStr(root.elementText("version_id"));
            String merchantIdResp = Ext19PayWirelessUtil.getNotEmptyStr(root.elementText("merchant_id"));
            String verifyStringResp = Ext19PayWirelessUtil.getNotEmptyStr(root.elementText("verifystring"));
            String orderDateResp = Ext19PayWirelessUtil.getNotEmptyStr(root.elementText("order_date"));
            String orderIdResp = Ext19PayWirelessUtil.getNotEmptyStr(root.elementText("order_id"));
            String amountResp = Ext19PayWirelessUtil.getNotEmptyStr(root.elementText("amount"));
            String currencyResp = Ext19PayWirelessUtil.getNotEmptyStr(root.elementText("currency"));
            String paySqResp = Ext19PayWirelessUtil.getNotEmptyStr(root.elementText("pay_sq"));
            String payDateResp = Ext19PayWirelessUtil.getNotEmptyStr(root.elementText("pay_date"));
            String pcIdResp = Ext19PayWirelessUtil.getNotEmptyStr(root.elementText("pc_id"));
            String resultResp = Ext19PayWirelessUtil.getNotEmptyStr(root.elementText("result"));
            String resultStrResp = Ext19PayWirelessUtil.getNotEmptyStr(root.elementText("resultstr"));
            String md5Str = new StringBuffer().append("version_id=").append(versionIdResp).append("&merchant_id=").append(merchantIdResp).append("&order_date=").append(orderDateResp).append("&order_id=").append(orderIdResp).append("&amount=").append(amountResp).append("&currency=").append(currencyResp).append("&pay_sq=").append(paySqResp).append("&pay_date=").append(payDateResp).append("&pc_id=").append(pcIdResp).append("&result=").append(resultResp).append("&merchant_key=").append(data.getMerchantKey()).toString();
            logger.debug("md5Str:{}", (Object)md5Str);
            String sign = Md5Encrypt.encode((String)md5Str.toString(), (String)"UTF-8").toLowerCase();
            if (!sign.equals(verifyStringResp)) {
                logger.error("localsign:{} is not equals respSign:{},parseSynRespXmlToMap failed", (Object)sign, (Object)verifyStringResp);
                return null;
            }
            if (!data.getOrderId().equals(orderIdResp.trim()) || !merchantIdResp.trim().equals(data.getMerchantId()) || Math.abs(Arith.sub((double)Double.valueOf(amountResp), (double)Double.valueOf(data.getOrderAmt()))) > 0.01) {
                logger.error("orderId/merchantId/orderamt is not same with the request");
                return null;
            }
            map.put("result", resultResp);
            map.put("resultstr", resultStrResp);
            return map;
        }
        catch (Exception e) {
            logger.error("", (Throwable)e);
            return null;
        }
    }

    public static String getNotEmptyStr(String s) {
        if (s == null) {
            return "";
        }
        return s;
    }
}

