/*
 * Decompiled with CFR 0.152.
 */
package com.xunlei.channel.gateway.pay.channels;

import com.google.common.base.Strings;
import com.xunlei.channel.db.dao.PayOrderDAO;
import com.xunlei.channel.db.dao.PayOrderFailDAO;
import com.xunlei.channel.db.dao.PayOrderOkDAO;
import com.xunlei.channel.db.pojo.AbstractOrder;
import com.xunlei.channel.db.pojo.PayOrder;
import com.xunlei.channel.db.pojo.PayOrderFail;
import com.xunlei.channel.db.pojo.PayOrderOk;
import com.xunlei.channel.gateway.common.pay.ChannelData;
import com.xunlei.channel.gateway.common.utils.BizUtil;
import com.xunlei.channel.gateway.common.utils.DateUtils;
import com.xunlei.channel.gateway.common.utils.NoticeUtils;
import com.xunlei.channel.gateway.notice.service.PayNoticeService;
import com.xunlei.channel.gateway.pay.result.PageResult;
import com.xunlei.channel.gateway.pay.result.SuccessPageResult;
import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public abstract class AbstractChannelService {
    private static final Logger logger = LoggerFactory.getLogger(AbstractChannelService.class);
    @Autowired
    private PayOrderDAO payOrderDAO;
    @Autowired
    private PayOrderOkDAO payOrderOkDAO;
    @Autowired
    private PayOrderFailDAO payOrderFailDAO;
    @Autowired
    private BizUtil bizUtil;
    @Autowired
    private PayNoticeService payNoticeService;

    protected PayOrderOk processPaySuccess(PayOrder payOrder, ChannelData channelData) {
        logger.info("processPaySuccess...xunleiPayId:{}", (Object)payOrder.getXunleiPayId());
        PayOrderOk payOrderOk = this.getPayOrderOkByXunleiPayId(payOrder.getXunleiPayId());
        if (null != payOrderOk) {
            return payOrderOk;
        }
        payOrderOk = this.generatePayOrderOk(payOrder, channelData);
        this.payOrderDAO.updatePayOrderStatusAndChannelId(payOrder.getXunleiPayId(), "S", channelData.getChannelOrderId());
        this.payOrderOkDAO.savePayOrderOk(payOrderOk);
        this.payNoticeService.sendPayOrderOkNotice(payOrderOk.getXunleiPayId());
        return payOrderOk;
    }

    protected PayOrderFail processPayFail(PayOrder payOrder, String errorCode, String errorMsg, String channelOrderId, String extraJson) {
        logger.info("processPayFail...xunleiPayId:{}", (Object)payOrder.getXunleiPayId());
        PayOrderFail payOrderFail = this.getPayOrderFailByXunleiPayId(payOrder.getXunleiPayId());
        if (null != payOrderFail) {
            return payOrderFail;
        }
        payOrderFail = this.generatePayOrderFail(payOrder, errorCode, errorMsg, channelOrderId, extraJson);
        this.payOrderDAO.updatePayOrderStatusAndChannelId(payOrder.getXunleiPayId(), "F", channelOrderId);
        this.payOrderFailDAO.savePayOrderFail(payOrderFail);
        return payOrderFail;
    }

    protected PayOrderOk getPayOrderOkByXunleiPayId(String xunleiPayId) {
        return this.payOrderOkDAO.getPayOrderOk(xunleiPayId);
    }

    protected PayOrderFail getPayOrderFailByXunleiPayId(String xunleiPayId) {
        return this.payOrderFailDAO.getPayOrderFail(xunleiPayId);
    }

    private PayOrderOk generatePayOrderOk(PayOrder payOrder, ChannelData channelData) {
        PayOrderOk payOrderOk = this.generatePayOrderOk(payOrder);
        payOrderOk.setBalanceDate(DateUtils.generateBalanceDate());
        payOrderOk.setChannelOrderId(channelData.getChannelOrderId());
        payOrderOk.setExtraJson(channelData.generateOkExtJson());
        payOrderOk.setFactAmt(Integer.valueOf(channelData.getFactAmt()));
        payOrderOk.setFareAmt(Integer.valueOf(channelData.getFareAmt()));
        payOrderOk.setSendNoticeStatus("F");
        return payOrderOk;
    }

    private PayOrderOk generatePayOrderOk(PayOrder payOrder) {
        PayOrderOk payOrderOk = new PayOrderOk();
        payOrderOk.setBizNo(payOrder.getBizNo());
        payOrderOk.setBizOrderId(payOrder.getBizOrderId());
        payOrderOk.setOrderIp(payOrder.getOrderIp());
        payOrderOk.setBizExt(payOrder.getBizExt());
        payOrderOk.setPageCharset(payOrder.getPageCharset());
        payOrderOk.setNotifyUrl(payOrder.getNotifyUrl());
        payOrderOk.setOrderAmt(payOrder.getOrderAmt());
        payOrderOk.setOrderGroup(payOrder.getOrderGroup());
        payOrderOk.setOrderType(payOrder.getOrderType());
        payOrderOk.setPageUrl(payOrder.getPageUrl());
        payOrderOk.setPayType(payOrder.getPayType());
        payOrderOk.setPhone(payOrder.getPhone());
        payOrderOk.setProductDesc(payOrder.getProductDesc());
        payOrderOk.setProductId(payOrder.getProductId());
        payOrderOk.setProductName(payOrder.getProductName());
        payOrderOk.setReqTime(payOrder.getCreateTime());
        payOrderOk.setUserShow(payOrder.getUserShow());
        payOrderOk.setVersion(payOrder.getVersion());
        payOrderOk.setXunleiId(payOrder.getXunleiId());
        payOrderOk.setXunleiPayId(payOrder.getXunleiPayId());
        return payOrderOk;
    }

    private PayOrderFail generatePayOrderFail(PayOrder payOrder, String errorCode, String errorMsg, String channelOrderId, String extraJson) {
        PayOrderFail payOrderFail = new PayOrderFail();
        payOrderFail.setBizNo(payOrder.getBizNo());
        payOrderFail.setBizOrderId(payOrder.getBizOrderId());
        payOrderFail.setOrderIp(payOrder.getOrderIp());
        payOrderFail.setBizExt(payOrder.getBizExt());
        payOrderFail.setPageCharset(payOrder.getPageCharset());
        payOrderFail.setNotifyUrl(payOrder.getNotifyUrl());
        payOrderFail.setOrderAmt(payOrder.getOrderAmt());
        payOrderFail.setOrderGroup(payOrder.getOrderGroup());
        payOrderFail.setOrderType(payOrder.getOrderType());
        payOrderFail.setPageUrl(payOrder.getPageUrl());
        payOrderFail.setPayType(payOrder.getPayType());
        payOrderFail.setPhone(payOrder.getPhone());
        payOrderFail.setProductDesc(payOrder.getProductDesc());
        payOrderFail.setProductId(payOrder.getProductId());
        payOrderFail.setProductName(payOrder.getProductName());
        payOrderFail.setUserShow(payOrder.getUserShow());
        payOrderFail.setVersion(payOrder.getVersion());
        payOrderFail.setXunleiId(payOrder.getXunleiId());
        payOrderFail.setXunleiPayId(payOrder.getXunleiPayId());
        payOrderFail.setExtraJson(extraJson);
        payOrderFail.setErrorCode(errorCode);
        payOrderFail.setErrorMsg(errorMsg);
        payOrderFail.setChannelOrderId(channelOrderId);
        return payOrderFail;
    }

    protected PayOrder getPayOrderByXunleiPayId(String xunleiPayId) {
        logger.debug("getPayOrderByXunleiPayId...xunleiPayId:{}", (Object)xunleiPayId);
        return this.payOrderDAO.getPayOrder(xunleiPayId);
    }

    protected PageResult generatePageUrlAndParams(AbstractOrder order, String payResult, int fareAmt) {
        return new SuccessPageResult(order.getUserShow(), order.getBizOrderId(), order.getProductName(), order.getOrderAmt(), this.generateRedirectUrl(order, payResult, "", fareAmt));
    }

    protected String generateRedirectUrl(AbstractOrder order, String payResult, String errCode, int fareAmt) {
        String bizKey = this.bizUtil.getBizKey(order.getBizNo());
        if (!Strings.isNullOrEmpty((String)bizKey)) {
            Date now = new Date();
            return NoticeUtils.buildPageUrlInfo((String)order.getPageCharset(), (String)order.getPageUrl(), (String)order.getVersion(), (String)order.getBizOrderId(), (int)order.getOrderAmt(), (String)DateUtils.noSpaceYYYYMMDDHHMMSS((Date)now), (String)order.getXunleiPayId(), (Date)now, (String)order.getBizExt(), (String)payResult, (String)errCode, (String)bizKey, (int)fareAmt);
        }
        logger.error("bizKey of bizNo:{} is null,cannot generateRedirectUrl");
        return null;
    }
}

