/*
 * Decompiled with CFR 0.152.
 */
package com.xunlei.channel.gateway.pay.channels.baiduwallet;

import com.google.common.base.Strings;
import com.xunlei.channel.gateway.common.constants.InterfaceReqResult;
import com.xunlei.channel.gateway.common.result.DirectReturnResult;
import com.xunlei.channel.gateway.common.result.InterfaceProcessResult;
import com.xunlei.channel.gateway.common.result.RedirectGetResult;
import com.xunlei.channel.gateway.common.result.ReturnResult;
import com.xunlei.channel.gateway.pay.annotation.PayType;
import com.xunlei.channel.gateway.pay.channels.AbstractChannelHandler;
import com.xunlei.channel.gateway.pay.channels.baiduwallet.BaiduWalletChannelData;
import com.xunlei.channel.gateway.pay.channels.baiduwallet.BaiduWalletChannelInfo;
import com.xunlei.channel.gateway.pay.channels.baiduwallet.BaiduWalletSDKResult;
import com.xunlei.channel.gateway.pay.channels.baiduwallet.BaiduWalletUtils;
import com.xunlei.channel.gateway.pay.pojo.UnitedPayRequest;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
@PayType(value="E5", desc="\u767e\u5ea6\u94b1\u5305\u4f59\u989d\u652f\u4ed8")
public class BaiduWalletChannelHandler
extends AbstractChannelHandler<ReturnResult> {
    private static final String SDK = "SDK";
    private static final Logger logger = LoggerFactory.getLogger(BaiduWalletChannelHandler.class);
    @Autowired
    private BaiduWalletChannelInfo baiduWalletChannelInfo;

    @Override
    public ReturnResult generateChannelResult(UnitedPayRequest unitedPayRequest) {
        logger.debug("generateChannelResult...");
        String from = unitedPayRequest.getExtraParam("from");
        if (SDK.equals(from)) {
            return this.generateSDKResult(unitedPayRequest);
        }
        BaiduWalletChannelData data = this.generateBaiduWalletChannelData(unitedPayRequest);
        try {
            data.setSign(BaiduWalletUtils.generateReqSignMsg(data));
            StringBuilder sb = new StringBuilder("currency=1&extra=");
            if (!Strings.isNullOrEmpty((String)data.getExtra())) {
                sb.append(URLEncoder.encode(data.getExtra(), "gbk"));
            }
            sb.append("&expire_time=");
            if (!Strings.isNullOrEmpty((String)data.getExpireTime())) {
                sb.append(data.getExpireTime());
            }
            sb.append("&goods_desc=").append(URLEncoder.encode(data.getGoodsName(), "gbk"));
            sb.append("&goods_name=").append(URLEncoder.encode(data.getGoodsName(), "gbk"));
            sb.append("&goods_url=");
            if (!Strings.isNullOrEmpty((String)data.getGoodsUrl())) {
                sb.append(URLEncoder.encode(data.getGoodsUrl(), "gbk"));
            }
            sb.append("&input_charset=");
            if (!Strings.isNullOrEmpty((String)data.getInputCharset())) {
                sb.append(data.getInputCharset());
            } else {
                sb.append("1");
            }
            sb.append("&order_create_time=").append(data.getOrderCreateTime());
            sb.append("&order_no=").append(data.getOrderNo());
            sb.append("&page_url=");
            if (!Strings.isNullOrEmpty((String)data.getPageUrl())) {
                sb.append(URLEncoder.encode(data.getPageUrl(), "gbk"));
            }
            sb.append("&pay_type=").append(data.getBaiduPayType());
            sb.append("&return_url=").append(URLEncoder.encode(data.getReturnUrl(), "gbk"));
            sb.append("&service_code=");
            if (!Strings.isNullOrEmpty((String)data.getServiceCode())) {
                sb.append(data.getServiceCode());
            } else {
                sb.append("1");
            }
            sb.append("&sign_method=");
            if (!Strings.isNullOrEmpty((String)data.getSignMethod())) {
                sb.append(data.getSignMethod());
            } else {
                sb.append("1");
            }
            sb.append("&sp_no=").append(data.getSpNo());
            sb.append("&total_amount=").append(data.getTotalAmount());
            sb.append("&transport_amount=&unit_amount=&unit_count=&version=2&sp_uno=");
            if (!Strings.isNullOrEmpty((String)data.getSpUno())) {
                sb.append(data.getSpUno());
            }
            sb.append("&buyer_sp_username=");
            if (!Strings.isNullOrEmpty((String)data.getBuyerSpUsername())) {
                sb.append(data.getBuyerSpUsername());
            }
            sb.append("&sign=").append(data.getSign());
            String baiduUrl = this.baiduWalletChannelInfo.getBaiduDeskUrl(data.isActivity()) + "?" + sb.toString();
            logger.info("baiduwallet_requrl:{}", (Object)baiduUrl);
            return new RedirectGetResult(InterfaceReqResult.SUCCESS, "00", "", null, baiduUrl);
        }
        catch (UnsupportedEncodingException e) {
            logger.error(e.getMessage(), (Throwable)e);
            return new RedirectGetResult(InterfaceReqResult.FAIL, "99", "\u7a0b\u5e8f\u5f02\u5e38\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5", "pay_fail_page", null);
        }
    }

    private ReturnResult generateSDKResult(UnitedPayRequest unitedPayRequest) {
        BaiduWalletChannelData data = this.generateBaiduWalletSDKChannelData(unitedPayRequest);
        try {
            String baiduParams = BaiduWalletUtils.generateSDKParams(data);
            logger.info("baidu_sdk_response:{}", (Object)baiduParams);
            return new DirectReturnResult(InterfaceReqResult.SUCCESS, "", "", null, new InterfaceProcessResult("", (Serializable)new BaiduWalletSDKResult(baiduParams)));
        }
        catch (UnsupportedEncodingException e) {
            logger.error(e.getMessage(), (Throwable)e);
            return new DirectReturnResult(InterfaceReqResult.FAIL, "", "\u53d1\u751f\u9519\u8bef\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5", null, new InterfaceProcessResult("", (Serializable)new BaiduWalletSDKResult("")));
        }
    }

    private BaiduWalletChannelData generateBaiduWalletSDKChannelData(UnitedPayRequest unitedPayRequest) {
        boolean isActivity = this.baiduWalletChannelInfo.isActivity(unitedPayRequest.getExtraParam("activity"));
        BaiduWalletChannelData data = new BaiduWalletChannelData();
        data.setActivity(isActivity);
        data.setBuyerIp(unitedPayRequest.getClientIp());
        data.setBuyerSpUsername(null);
        data.setExpireTime(BaiduWalletUtils.generateTime(3));
        data.setExtra(unitedPayRequest.getXunleiId());
        data.setGoodsDesc(unitedPayRequest.getProductDesc());
        data.setGoodsName(unitedPayRequest.getProductName());
        data.setOrderCreateTime(BaiduWalletUtils.generateTime(0));
        data.setOrderNo(unitedPayRequest.getXunleiPayId());
        data.setPageUrl(this.baiduWalletChannelInfo.getPageUrl(isActivity));
        data.setPayType(unitedPayRequest.getPayType());
        data.setReturnUrl(this.baiduWalletChannelInfo.getReturnUrl(isActivity));
        data.setSpNo(this.baiduWalletChannelInfo.getSpNo(isActivity));
        data.setSpKey(this.baiduWalletChannelInfo.getSpKey(data.getSpNo()));
        data.setSpUno(unitedPayRequest.getXunleiId());
        data.setTotalAmount(unitedPayRequest.getOrderAmt());
        data.setSpRequestType(this.baiduWalletChannelInfo.getSpRequestType());
        return data;
    }

    private BaiduWalletChannelData generateBaiduWalletChannelData(UnitedPayRequest unitedPayRequest) {
        boolean isActivity = this.baiduWalletChannelInfo.isActivity(unitedPayRequest.getExtraParam("activity"));
        BaiduWalletChannelData data = new BaiduWalletChannelData();
        data.setActivity(isActivity);
        data.setBankNo(this.baiduWalletChannelInfo.getBaiduWalletBankNo(unitedPayRequest.getExtraParam("bank_no"), unitedPayRequest.getExtraParam("card_type")));
        data.setBuyerIp(unitedPayRequest.getClientIp());
        data.setBuyerSpUsername(null);
        data.setCardType(unitedPayRequest.getExtraParam("card_type"));
        data.setCurrency("1");
        data.setExpireTime(BaiduWalletUtils.generateTime(3));
        data.setExtra(unitedPayRequest.getXunleiId());
        data.setGoodsDesc(unitedPayRequest.getProductDesc());
        data.setGoodsName(unitedPayRequest.getProductName());
        data.setInputCharset("1");
        data.setOrderCreateTime(BaiduWalletUtils.generateTime(0));
        data.setOrderNo(unitedPayRequest.getXunleiPayId());
        data.setPageUrl(this.baiduWalletChannelInfo.getPageUrl(isActivity));
        data.setPayType(unitedPayRequest.getPayType());
        data.setBaiduPayType(this.baiduWalletChannelInfo.getBaiduPayType(data.getPayType()));
        data.setReturnUrl(this.baiduWalletChannelInfo.getReturnUrl(isActivity));
        data.setServiceCode("1");
        data.setSignMethod("1");
        data.setSpNo(this.baiduWalletChannelInfo.getSpNo(isActivity));
        data.setSpKey(this.baiduWalletChannelInfo.getSpKey(data.getSpNo()));
        data.setSpUno(unitedPayRequest.getXunleiId());
        data.setTotalAmount(unitedPayRequest.getOrderAmt());
        data.setVersion("2");
        return data;
    }

    @Override
    public String analyzeExtParams(UnitedPayRequest unitedPayRequest) {
        boolean isActivity = this.baiduWalletChannelInfo.isActivity(unitedPayRequest.getExtraParamsMap().get("activity"));
        String spNo = this.baiduWalletChannelInfo.getSpNo(isActivity);
        return "{\"spNo\":\"" + spNo + "\"}";
    }

    @Override
    public String generateRemark(UnitedPayRequest payRequest) {
        return payRequest.getExtraParam("from");
    }
}

