/*
 * Decompiled with CFR 0.152.
 */
package com.xunlei.channel.gateway.pay.pojo;

import com.google.common.base.Strings;
import com.xunlei.channel.gateway.common.annotation.ParamName;
import com.xunlei.channel.gateway.common.utils.StringUtils;
import com.xunlei.channel.gateway.pay.channels.ChannelHandler;
import java.util.HashMap;
import java.util.Map;
import javax.validation.constraints.Min;
import javax.validation.constraints.Size;
import org.hibernate.validator.constraints.Length;
import org.hibernate.validator.constraints.NotEmpty;
import org.hibernate.validator.constraints.Range;
import org.hibernate.validator.constraints.URL;

public class UnitedPayRequest {
    @NotEmpty(message="invalid version")
    private String version;
    @ParamName(value="input_charset")
    @NotEmpty(message="invalid input_charset")
    @Length(min=1, max=1, message="invalid input_charset")
    private String inputCharset;
    @ParamName(value="notify_url")
    @NotEmpty(message="invalid notify_url")
    @URL(regexp="(http://|https://){1}[\\w\\.\\-/:]+", message="invalid notify_url")
    @Size(max=255, min=1)
    private String notifyUrl;
    @ParamName(value="page_url")
    @Size(max=255, min=0, message="invalid page_url")
    private String pageUrl;
    @ParamName(value="biz_no")
    @NotEmpty(message="invalid biz_no")
    @Length(max=9, min=9, message="invalid biz_no")
    private String bizNo;
    @ParamName(value="biz_order_id")
    @NotEmpty(message="invalid biz_order_id")
    @Length(min=1, max=30, message="invalid biz_order_id")
    private String bizOrderId;
    @ParamName(value="order_amt")
    @Range(max=9999999L, min=1L, message="invalid order_amt")
    private int orderAmt;
    @ParamName(value="pay_type")
    @NotEmpty(message="invalid pay_type")
    @Length(min=1, max=2, message="invalid pay_type")
    private String payType;
    @ParamName(value="product_id")
    @Min(value=0L, message="invalid product_id")
    private long productId;
    @ParamName(value="product_name")
    @NotEmpty(message="invalid product_name")
    @Length(min=1, max=50, message="invalid product_name")
    private String productName;
    @ParamName(value="product_desc")
    @NotEmpty(message="invalid product_desc")
    @Length(min=1, max=255, message="invalid product_desc")
    private String productDesc;
    @ParamName(value="xunlei_id")
    @NotEmpty(message="invalid xunlei_id")
    @Length(min=1, max=30, message="invalid xunlei_id")
    private String xunleiId;
    @ParamName(value="user_show")
    @NotEmpty(message="invalid user_show")
    @Length(min=1, max=64, message="invalid user_show")
    private String userShow;
    @ParamName(value="sign_type")
    @NotEmpty(message="invalid sign_type")
    @Length(min=1, max=1, message="invalid sign_type")
    private String signType;
    @NotEmpty(message="invalid sign")
    private String sign;
    @ParamName(value="client_ip")
    @NotEmpty(message="invalid client_ip")
    @Length(min=7, max=15, message="invalid client_ip")
    private String clientIp;
    @ParamName(value="extra_common_param")
    private String extraCommonParam;
    @ParamName(value="extend_param")
    private String extendParam;
    @ParamName(value="anti_phishing_key")
    private String antiPhishingKey;
    @ParamName(value="need_phishing_check")
    private String needPhishingCheck;
    private Map<String, String> extraParamsMap = new HashMap<String, String>();
    private String xunleiPayId;
    private String orderGroup;
    private String orderType;
    private String remark;
    private ChannelHandler<?> channelHandler;
    private String realPayType;

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public String getInputCharset() {
        return this.inputCharset;
    }

    public void setInputCharset(String inputCharset) {
        this.inputCharset = inputCharset;
    }

    public String getNotifyUrl() {
        return this.notifyUrl;
    }

    public void setNotifyUrl(String notifyUrl) {
        this.notifyUrl = notifyUrl;
    }

    public String getPageUrl() {
        return this.pageUrl;
    }

    public void setPageUrl(String pageUrl) {
        this.pageUrl = pageUrl;
    }

    public String getBizNo() {
        return this.bizNo;
    }

    public void setBizNo(String bizNo) {
        this.bizNo = bizNo;
    }

    public String getBizOrderId() {
        return this.bizOrderId;
    }

    public void setBizOrderId(String bizOrderId) {
        this.bizOrderId = bizOrderId;
    }

    public int getOrderAmt() {
        return this.orderAmt;
    }

    public void setOrderAmt(int orderAmt) {
        this.orderAmt = orderAmt;
    }

    public String getPayType() {
        return this.payType;
    }

    public void setPayType(String payType) {
        this.payType = payType;
    }

    public long getProductId() {
        return this.productId;
    }

    public void setProductId(long productId) {
        this.productId = productId;
    }

    public String getProductName() {
        return this.productName;
    }

    public void setProductName(String productName) {
        this.productName = productName;
    }

    public String getProductDesc() {
        return this.productDesc;
    }

    public void setProductDesc(String productDesc) {
        this.productDesc = productDesc;
    }

    public String getXunleiId() {
        return this.xunleiId;
    }

    public void setXunleiId(String xunleiId) {
        this.xunleiId = xunleiId;
    }

    public String getUserShow() {
        return this.userShow;
    }

    public void setUserShow(String userShow) {
        this.userShow = userShow;
    }

    public String getSignType() {
        return this.signType;
    }

    public void setSignType(String signType) {
        this.signType = signType;
    }

    public String getSign() {
        return this.sign;
    }

    public void setSign(String sign) {
        this.sign = sign;
    }

    public String getClientIp() {
        return this.clientIp;
    }

    public void setClientIp(String clientIp) {
        this.clientIp = clientIp;
    }

    public String getExtraCommonParam() {
        return this.extraCommonParam;
    }

    public void setExtraCommonParam(String extraCommonParam) {
        this.extraCommonParam = extraCommonParam;
    }

    public String getExtendParam() {
        return this.extendParam;
    }

    public void setExtendParam(String extendParam) {
        this.extendParam = extendParam;
        this.extraParamsMap = StringUtils.StringToMap((String)extendParam, (String)"\\^");
    }

    public String getAntiPhishingKey() {
        return this.antiPhishingKey;
    }

    public void setAntiPhishingKey(String antiPhishingKey) {
        this.antiPhishingKey = antiPhishingKey;
    }

    public String getNeedPhishingCheck() {
        return this.needPhishingCheck;
    }

    public void setNeedPhishingCheck(String needPhishingCheck) {
        this.needPhishingCheck = needPhishingCheck;
    }

    public Map<String, String> getExtraParamsMap() {
        return this.extraParamsMap;
    }

    public String getExtraParam(String key) {
        if (Strings.isNullOrEmpty((String)key)) {
            return null;
        }
        return this.extraParamsMap.get(key);
    }

    public String getXunleiPayId() {
        return this.xunleiPayId;
    }

    public void setXunleiPayId(String xunleiPayId) {
        this.xunleiPayId = xunleiPayId;
    }

    public ChannelHandler<?> getChannelHandler() {
        return this.channelHandler;
    }

    public void setChannelHandler(ChannelHandler<?> channelHandler) {
        this.channelHandler = channelHandler;
    }

    public String getOrderGroup() {
        return this.orderGroup;
    }

    public void setOrderGroup(String orderGroup) {
        this.orderGroup = orderGroup;
    }

    public String getOrderType() {
        return this.orderType;
    }

    public void setOrderType(String orderType) {
        this.orderType = orderType;
    }

    public String getRemark() {
        return this.remark;
    }

    public void setRemark(String remark) {
        this.remark = remark;
    }

    public String getRealPayType() {
        return this.realPayType;
    }

    public void setRealPayType(String realPayType) {
        this.realPayType = realPayType;
    }

    public String toString() {
        return "{payType=" + this.payType + ",xunleiId=" + this.xunleiId + ",productName=" + this.productName + ",version=" + this.version + ",bizNo=" + this.bizNo + ",bizOrderId=" + this.bizOrderId + ",extendParam=" + this.extendParam + ",extraCommonParam=" + this.extraCommonParam + ",orderAmt=" + this.orderAmt + ",userShow=" + this.userShow + "}";
    }
}

