/*
 * Decompiled with CFR 0.152.
 */
package com.xunlei.channel.gateway.pay.interceptor;

import com.xunlei.channel.paycommon.configcache.ConfigCacheClientProxy;
import com.xunlei.channel.paycommon.configcache.vo.CacheKey;
import com.xunlei.channel.paycommon.configcache.vo.CacheValue;
import org.aspectj.lang.ProceedingJoinPoint;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class ConfigCacheInterceptor {
    private static final Logger logger = LoggerFactory.getLogger(ConfigCacheInterceptor.class);
    @Autowired
    private ConfigCacheClientProxy configCacheClientProxy;

    public String getConfigValue(ProceedingJoinPoint call, String groupId, String propertyKey) {
        CacheValue cacheValue = this.configCacheClientProxy.get(new CacheKey(groupId, propertyKey));
        logger.debug("get key[groupId:{},propertyeKey:{}] configValue from cache with value:{}", new Object[]{groupId, propertyKey, cacheValue});
        if (cacheValue == null) {
            String value = null;
            try {
                value = (String)call.proceed();
            }
            catch (Throwable e) {
                logger.error("", e);
                return null;
            }
            if (value != null) {
                this.configCacheClientProxy.put(new CacheKey(groupId, propertyKey), new CacheValue(value));
            }
            return value;
        }
        return cacheValue.getPropertyValue();
    }
}

