/*
 * Decompiled with CFR 0.152.
 */
package com.xunlei.channel.gateway.pay.channels.vpay;

import com.google.common.base.Strings;
import com.xunlei.channel.gateway.pay.channels.AbstractChannelInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class VPayChannelInfo
extends AbstractChannelInfo {
    private static final Logger logger = LoggerFactory.getLogger(VPayChannelInfo.class);
    public static final String CACHE_GROUP_ID = "gateway_extvpay";
    public static final String CACHE_SP_ID = "sp_id";
    public static final String CACHE_SP_PWD = "sp_pwd";
    public static final String CACHE_SP_REQ = "sp_req";
    public static final String CACHE_SP_REC = "sp_rec";
    public static final String CACHE_SP_VERSION = "sp_version";
    public static final String CACHE_VALID_AMT = "valid_amt";
    public static final String CACHE_FEE_RATE = "fee_rate";
    public static final String CACHE_VALID_CARD_TYPE = "valid_card_type";
    public static final String CARD_NO = "card_no";
    public static final String CARD_PWD = "card_pwd";
    public static final String CARD_TYPE = "card_type";

    @Override
    protected String getGroupId() {
        return CACHE_GROUP_ID;
    }

    public boolean isValidAmt(int amt) {
        String[] validAmts;
        String validAmt = this.getConfigValue(CACHE_VALID_AMT);
        if (Strings.isNullOrEmpty((String)validAmt)) {
            logger.error("cant get validAmt from the gateway.config_info for groupid:{},key:{}", (Object)CACHE_GROUP_ID, (Object)CACHE_VALID_AMT);
            return false;
        }
        for (String tmpAmt : validAmts = validAmt.split(",")) {
            try {
                int tmp = Integer.parseInt(tmpAmt) * 100;
                if (amt != tmp) continue;
                return true;
            }
            catch (Exception e) {
                logger.error("", (Throwable)e);
            }
        }
        return false;
    }
}

