/*
 * Decompiled with CFR 0.152.
 */
package com.xunlei.channel.gateway.pay.channels.unicommobilepay;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.xunlei.channel.db.dao.PayOrderDAO;
import com.xunlei.channel.db.dao.PayOrderOkDAO;
import com.xunlei.channel.gateway.common.constants.InterfaceReqResult;
import com.xunlei.channel.gateway.common.result.DirectSDKPayResult;
import com.xunlei.channel.gateway.common.utils.HttpUtils;
import com.xunlei.channel.gateway.common.utils.StringUtils;
import com.xunlei.channel.gateway.common.utils.UrlUtils;
import com.xunlei.channel.gateway.pay.annotation.PayType;
import com.xunlei.channel.gateway.pay.channels.AbstractChannelHandler;
import com.xunlei.channel.gateway.pay.channels.unicommobilepay.UnicomMobilePayChannelData;
import com.xunlei.channel.gateway.pay.channels.unicommobilepay.UnicomMobilePayChannelInfo;
import com.xunlei.channel.gateway.pay.channels.unicommobilepay.UnicomMobilePayResult;
import com.xunlei.channel.gateway.pay.channels.unicommobilepay.UnicomMobilePayUtil;
import com.xunlei.channel.gateway.pay.channels.unicommobilepay.UnicomMobileResponseCode;
import com.xunlei.channel.gateway.pay.pojo.UnitedPayRequest;
import com.xunlei.xlcommons.util.Date.DateUtil;
import java.io.IOException;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
@PayType(value="LT", desc="\u8d5e\u6210\u8054\u901a\u624b\u673a\u70b9\u64ad")
public class UnicomMobilePayChannelHandler
extends AbstractChannelHandler<DirectSDKPayResult> {
    private static final Logger logger = LoggerFactory.getLogger(UnicomMobilePayChannelHandler.class);
    @Autowired
    private UnicomMobilePayChannelInfo channelInfo;
    @Autowired
    private PayOrderOkDAO payOrderOkDAO;
    @Autowired
    private PayOrderDAO payOrderDAO;

    @Override
    public DirectSDKPayResult generateChannelResult(UnitedPayRequest unitedPayRequest) {
        UnicomMobilePayChannelData channelData = new UnicomMobilePayChannelData();
        try {
            DirectSDKPayResult checkByNow = this.checkByNow(unitedPayRequest, channelData);
            if (checkByNow != null) {
                logger.debug("checkByNow: {}", (Object)checkByNow);
                return checkByNow;
            }
            this.payOrderDAO.updatePayOrderStatusAndChannelId(unitedPayRequest.getXunleiPayId(), "W", channelData.getOutTradeNo());
            logger.debug("updatePayOrderStatusAndChannelId: {}", (Object)channelData.getOutTradeNo());
            DirectSDKPayResult directSDKPayResult = this.dealResult(InterfaceReqResult.SUCCESS, unitedPayRequest, channelData.getOutTradeNo());
            logger.debug("generateChannelResult, result: {}, errCode: {}, errMsg: {}", new Object[]{directSDKPayResult.getPayresult(), directSDKPayResult.getErrcode(), directSDKPayResult.getErrmsg()});
            return directSDKPayResult;
        }
        catch (IOException e) {
            logger.error("post data error", (Throwable)e);
            String errMsg = "request unicom phone check error!";
            return this.generatePayResult(UnicomMobileResponseCode.RTN1, errMsg);
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            return this.generatePayResult(UnicomMobileResponseCode.RTN1, e.getMessage());
        }
    }

    private DirectSDKPayResult dealResult(InterfaceReqResult interfaceReqResult, UnitedPayRequest request, String outTradeNo) {
        if ("xllt".equals(request.getExtraParam("other1"))) {
            UnicomMobilePayResult unicomMobilePayResult = new UnicomMobilePayResult(interfaceReqResult, UnicomMobileResponseCode.RTN0000.getCode(), "", "", "", outTradeNo);
            return unicomMobilePayResult;
        }
        DirectSDKPayResult directSDKPayResult = new DirectSDKPayResult(interfaceReqResult, UnicomMobileResponseCode.RTN0000.getCode(), null, null, null);
        logger.warn("requesting the old api! result: {}", (Object)directSDKPayResult);
        return directSDKPayResult;
    }

    private DirectSDKPayResult generatePayResult(UnicomMobileResponseCode code, String errMsg) {
        return UnicomMobilePayUtil.generatePayResult(InterfaceReqResult.FAIL, code, errMsg);
    }

    private DirectSDKPayResult checkByNow(UnitedPayRequest request, UnicomMobilePayChannelData channelData) throws IOException {
        String phone = request.getExtraParam("phone");
        String svcid = this.channelInfo.getConfigValue("svcid");
        String url = this.channelInfo.getConfigValue("wow_query_url");
        String other1 = request.getExtraParam("other1");
        HashMap<String, String> parameterMap = new HashMap<String, String>();
        if (!"xllt".equals(other1)) {
            logger.warn("requesting the old api!");
            logger.info("sending request, url: {}, Svcid: {}, Phone_number: {}", new Object[]{url, svcid, phone});
            parameterMap.put("Svcid", svcid);
            parameterMap.put("Phone_number", phone);
            String response = HttpUtils.doPost((String)url, parameterMap, (int)15000, (int)30000);
            logger.info("response: {}", (Object)response);
            if (!"OK".equalsIgnoreCase(response)) {
                String errMsg = "according to WowCheck,mobile[" + phone + "] was not allowed to order! Errmsg is :[" + response + "]";
                return this.generatePayResult(UnicomMobileResponseCode.RTN1004, errMsg);
            }
        } else {
            String configSvcid = this.channelInfo.getConfigValue("svcid");
            parameterMap.put("Svcid", configSvcid);
            parameterMap.put("Phone_number", phone);
            logger.info("sending request, url: {}, Svcid: {}, Phone_number: {}", new Object[]{this.channelInfo.getConfigValue("url"), configSvcid, phone});
            String response = HttpUtils.doPost((String)this.channelInfo.getConfigValue("url"), parameterMap, (int)15000, (int)30000);
            logger.info("URL: {}, response: {}", (Object)this.channelInfo.getConfigValue("url"), (Object)response);
            if (response.toLowerCase().contains("ok")) {
                TreeMap<String, String> map = new TreeMap<String, String>();
                map.put("pid", this.channelInfo.getConfigValue("pid"));
                map.put("svcid", this.channelInfo.getConfigValue("svcid"));
                map.put("paymentUser", phone);
                map.put("sign", UnicomMobilePayUtil.createToken(map, this.channelInfo.getConfigValue("key")));
                String feeUrl = this.channelInfo.getConfigValue(UnicomMobilePayChannelInfo.FEE_URL);
                String params = UrlUtils.buildUrlParams(map, (String)"UTF-8");
                StringBuilder builder = new StringBuilder();
                builder.append(feeUrl);
                if (feeUrl.contains("?")) {
                    builder.append("&");
                    builder.append(params);
                } else {
                    builder.append("?");
                    builder.append(params);
                }
                String feeUrlFinal = builder.toString();
                logger.info("feeUrl: {}, params: {}, feeUrlFinal: {}", new Object[]{feeUrl, params, feeUrlFinal});
                String rs = HttpUtils.doGet((String)feeUrlFinal);
                logger.info("rs: {}", (Object)rs);
                ObjectMapper mapper = new ObjectMapper();
                Map result = (Map)mapper.readValue(rs, Map.class);
                String resultCode = result.get("resultCode") + "";
                String outTradeNo = result.get("outTradeNo") + "";
                channelData.setOutTradeNo(outTradeNo);
                logger.info("resultCode: {}", (Object)resultCode);
                if (!"0".equals(resultCode)) {
                    String errMsg;
                    if (resultCode == null) {
                        String errorCode = result.get("errorCode") + "";
                        String errorDesc = result.get("errorDesc") + "";
                        errMsg = errorCode != null ? "according to fee url, errorCode: " + errorCode + ", errorDesc: " + errorDesc : "Unknow error!";
                    } else {
                        String resultDescription = result.get("resultDescription") + "";
                        errMsg = "according to fee url, resultCode: " + resultCode + ", resultDescription: " + resultDescription;
                    }
                    return this.generatePayResult(UnicomMobileResponseCode.RTN99, errMsg);
                }
            } else {
                String errMsg = "according to WowCheck,mobile[" + phone + "] was not allowed to order!Errmg is :[" + response + "]";
                return this.generatePayResult(UnicomMobileResponseCode.RTN1004, errMsg);
            }
        }
        return null;
    }

    private DirectSDKPayResult isInBlackList(UnitedPayRequest request) {
        String phone = request.getExtraParam("phone");
        String userName = request.getUserShow();
        String clientIp = request.getClientIp();
        String areaCode = UnicomMobilePayUtil.getAreaCodeFromMb(phone);
        if (UnicomMobilePayUtil.isInList(phone, this.channelInfo.getConfigValue("mobile_black_list"))) {
            String errMsg = "according to mobileBlackList,mobile[" + phone + "] does not allow to order!";
            return this.generatePayResult(UnicomMobileResponseCode.RTN1002, errMsg);
        }
        logger.debug("isInBlackList iplist: {}", (Object)this.channelInfo.getConfigValue("ip_black_list"));
        if (UnicomMobilePayUtil.isInList(clientIp, this.channelInfo.getConfigValue("ip_black_list"))) {
            String errMsg = "according to ipblackList,ip[" + clientIp + "] does not allow to order!";
            return this.generatePayResult(UnicomMobileResponseCode.RTN1002, errMsg);
        }
        if (UnicomMobilePayUtil.isInList(areaCode, this.channelInfo.getConfigValue("forbidden_area_list"))) {
            // empty if block
        }
        if (UnicomMobilePayUtil.isInList(userName, this.channelInfo.getConfigValue("user_black_list"))) {
            String errMsg = "according to userBlackList,user[" + userName + "] does not allow to order!";
            return this.generatePayResult(UnicomMobileResponseCode.RTN1002, errMsg);
        }
        return null;
    }

    @Override
    public DirectSDKPayResult validateSpecialParams(UnitedPayRequest request) {
        Date lastTime;
        logger.debug("validateSpecialParams unitedPayRequest: {}", (Object)request);
        logger.debug("validateSpecialParams unitedPayRequest.map: {}", request.getExtraParamsMap());
        String orderIp = request.getClientIp();
        logger.info("orderIp:{}", (Object)orderIp);
        int orderAmt = request.getOrderAmt();
        if (orderAmt != this.channelInfo.getPayFee()) {
            logger.error("orderAmt:{}, does not fixed to properties:{}", (Object)orderAmt, (Object)this.channelInfo.getConfigValue("pay_fee"));
            String errMsg = "orderamt is fixed to 2500! (25 RMB)";
            return this.generatePayResult(UnicomMobileResponseCode.RTN5, errMsg);
        }
        String mobile = request.getExtraParam("phone");
        if (StringUtils.isAnyNullOrEmpty((String[])new String[]{mobile}) || !UnicomMobilePayUtil.isLTMobile(this.channelInfo, mobile)) {
            String errMsg = "param named [phone] can not be null or is not valid!";
            return this.generatePayResult(UnicomMobileResponseCode.RTN1001, errMsg);
        }
        String bizNo = request.getBizNo();
        String xunleiId = request.getXunleiId();
        Date fromDate = DateUtil.getFirstDateOfMonth();
        Date toDate = new Date();
        logger.debug("bizNo: {}, xunleiId: {}, fromDate: {}, toDate: {}", new Object[]{bizNo, xunleiId, fromDate, toDate});
        int countByPhoneBizNoAndDate = this.payOrderOkDAO.getCountByPhoneBizNoAndDate(mobile, bizNo, fromDate, toDate);
        if (countByPhoneBizNoAndDate >= this.channelInfo.getOkOrderMobileMonthlyLimit()) {
            String errMsg = "mobile  [" + mobile + "] can only charge " + this.channelInfo.getConfigValue("ok_order_mobile_monthly_limit") + " a month!";
            logger.info("mobile:{} pay times:{} exceed success times of month", (Object)mobile, (Object)countByPhoneBizNoAndDate);
            return this.generatePayResult(UnicomMobileResponseCode.RTN1006, errMsg);
        }
        int sumAmountOfMonth = this.payOrderOkDAO.getSumPayAmountByXunleiIdBizNoAndDate(xunleiId, bizNo, fromDate, toDate);
        if (sumAmountOfMonth + orderAmt > this.channelInfo.getOkOrderAmountAccountMonthlyLimitFen()) {
            logger.info("account:{} exceed amount:{} every month", (Object)xunleiId, (Object)(sumAmountOfMonth + orderAmt));
            String errMsg = "xunleiId[" + xunleiId + "] total success amount [" + sumAmountOfMonth + "] must under [" + this.channelInfo.getConfigValue("ok_order_amount_account_monthly_limit_fen") + "] in a month!";
            return this.generatePayResult(UnicomMobileResponseCode.RTN1007, errMsg);
        }
        Date zeroTime = DateUtil.getZeroTime((Date)new Date());
        int countOfOrderRequest = this.payOrderDAO.getCountOfOrderRequestByXunleiIdBizNoAndDate(xunleiId, bizNo, zeroTime, lastTime = DateUtil.getLastTime((Date)new Date()));
        if (countOfOrderRequest > this.channelInfo.getOrderAccountDailyLimit()) {
            logger.info("xunleiId:{} pay times:{} exceed success times of month", (Object)xunleiId, (Object)countOfOrderRequest);
            String errMsg = "xunleiId[" + xunleiId + "] can only order [" + this.channelInfo.getConfigValue("order_account_daily_limit") + "] times every 24 hours";
            return this.generatePayResult(UnicomMobileResponseCode.RTN1005, errMsg);
        }
        int countOrderOk = this.payOrderOkDAO.getCountByXunleiIdBizNoAndDate(xunleiId, bizNo, fromDate, toDate);
        if (countOrderOk >= this.channelInfo.getOkOrderAccountMonthlyLimit()) {
            String errMsg = "xunleiid  [" + xunleiId + "] can only charge [" + this.channelInfo.getConfigValue("ok_order_account_monthly_limit") + "] a month!";
            return this.generatePayResult(UnicomMobileResponseCode.RTN1008, errMsg);
        }
        DirectSDKPayResult inBlackList = this.isInBlackList(request);
        if (inBlackList != null) {
            logger.debug("inBlackList not null, code: {}, message: {}", (Object)inBlackList.getCode(), (Object)inBlackList.getMsg());
            return inBlackList;
        }
        return null;
    }
}

