/*
 * Decompiled with CFR 0.152.
 */
package com.xunlei.channel.gateway.pay.channels.shengpay;

import com.alibaba.fastjson.JSON;
import com.google.common.base.Strings;
import com.xunlei.channel.gateway.common.utils.HttpUtils;
import com.xunlei.channel.gateway.common.utils.MD5Utils;
import com.xunlei.channel.gateway.pay.channels.shengpay.ShengpayChannelData;
import com.xunlei.channel.gateway.pay.channels.shengpay.ShengpayChannelInfo;
import com.xunlei.channel.gateway.pay.channels.shengpay.ShengpayTimeData;
import java.io.UnsupportedEncodingException;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ShengpayUtils {
    private static final Logger logger = LoggerFactory.getLogger(ShengpayUtils.class);
    private static final String SEND_TIME_URL = "http://api.shengpay.com/mas/v1/timestamp?merchantNo=";

    public static String genShengpayRespSignMsg(ShengpayChannelData data, String bizKey) throws UnsupportedEncodingException {
        StringBuilder sb = new StringBuilder();
        sb.append(data.getVname()).append(data.getVersion()).append(data.getCharset()).append(data.getTraceNo());
        sb.append(data.getMsgSender()).append(data.getSendTime()).append(data.getInstCode());
        sb.append(data.getOrderId()).append(data.getOrderAmount()).append(data.getTransNo());
        sb.append(data.getTransAmount()).append(data.getTransStatus()).append(data.getPayType());
        sb.append(data.getTransTime()).append(data.getMerchantNo()).append(data.getErrCode());
        sb.append(data.getErrMsg()).append(data.getExt1()).append(data.getSignType());
        logger.info("sdf_notify_response:{}", (Object)sb.toString());
        String signMsg = MD5Utils.getMD5Str((String)(sb.toString() + bizKey)).toUpperCase();
        logger.info("signMsg:{}", (Object)signMsg);
        return signMsg;
    }

    public static ShengpayChannelData parseNotifyData(HttpServletRequest request) {
        ShengpayChannelData data = new ShengpayChannelData();
        try {
            data.setVname(request.getParameter("Name"));
            data.setVersion(request.getParameter("Version"));
            data.setCharset(request.getParameter("Charset"));
            data.setTraceNo(request.getParameter("TraceNo"));
            data.setMsgSender(request.getParameter("MsgSender"));
            data.setSendTime(request.getParameter("SendTime"));
            data.setInstCode(request.getParameter("InstCode"));
            data.setOrderId(request.getParameter("OrderNo"));
            data.setOrderAmount(request.getParameter("OrderAmount"));
            data.setTransNo(request.getParameter("TransNo"));
            data.setTransAmount(request.getParameter("TransAmount"));
            data.setTransStatus(request.getParameter("TransStatus"));
            data.setPayType(request.getParameter("TransType"));
            data.setTransTime(request.getParameter("TransTime"));
            data.setMerchantNo(request.getParameter("MerchantNo"));
            data.setErrCode(request.getParameter("ErrorCode"));
            data.setErrMsg(request.getParameter("ErrorMsg"));
            data.setExt1(ShengpayUtils.convertCharset(request, "Ext1", data.getCharset(), "UTF-8"));
            data.setSignType(request.getParameter("SignType"));
            logger.info("orderid:{},orderamt:{},ordertime:{},transtime:{},order_status:{},trantype:{}", new Object[]{data.getOrderId(), data.getOrderAmount(), data.getOrderTime(), data.getTransTime(), data.getTransStatus(), data.getPayType()});
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
        return data;
    }

    public static String convertCharset(HttpServletRequest request, String name, String fromCharset, String charset) {
        String param = "";
        try {
            String value = request.getParameter(name);
            if (StringUtils.isEmpty((String)value)) {
                return param;
            }
            param = new String(value.getBytes(fromCharset), charset);
            logger.debug("param:{},value:{}", (Object)name, (Object)param);
        }
        catch (Exception e) {
            logger.error("\u89e3\u6790\u901a\u77e5\u53c2\u6570\u5931\u8d25", (Throwable)e);
        }
        return param;
    }

    public static String getSendTimeFromSft(String senderId) {
        try {
            String result = HttpUtils.doGet((String)(SEND_TIME_URL + senderId));
            ShengpayTimeData data = (ShengpayTimeData)JSON.parseObject((String)result, ShengpayTimeData.class);
            if (data.getResponseStatus().getStatusCode() == 200) {
                return data.getTimestamp();
            }
            logger.info("failed to get timestamp from shengfutong,responseStatus is {}", (Object)data.getResponseStatus().getStatusCode());
            return null;
        }
        catch (Exception e) {
            logger.error("Exception occurs when getting timestamp from shengfutong", (Throwable)e);
            return null;
        }
    }

    public static ShengpayChannelData parseRefundData(HttpServletRequest request) {
        ShengpayChannelData data = new ShengpayChannelData();
        try {
            data.setVname(request.getParameter("ServiceCode"));
            data.setVersion(request.getParameter("Version"));
            data.setCharset(request.getParameter("Charset"));
            data.setTraceNo(request.getParameter("TraceNo"));
            data.setMsgSender(request.getParameter("SenderId"));
            data.setSendTime(request.getParameter("SendTime"));
            data.setRefundOrderNo(request.getParameter("RefundOrderNo"));
            data.setOrderId(request.getParameter("OriginalOrderNo"));
            data.setTransStatus(request.getParameter("Status"));
            data.setRefundAmount(request.getParameter("RefundAmount"));
            data.setRefundTransNo(request.getParameter("RefundTransNo"));
            data.setExt1(ShengpayUtils.convertCharset(request, "Ext1", data.getCharset(), "UTF-8"));
            data.setSignType(request.getParameter("SignType"));
            logger.info("refundOrderId:{},refundOrderAmount:{},refundStatus:{}", new Object[]{data.getRefundOrderNo(), data.getRefundAmount(), data.getTransStatus()});
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
        return data;
    }

    public static String genShengpayReqSignMsg(ShengpayChannelData data, String bizKey) {
        StringBuilder sb = new StringBuilder();
        sb.append(data.getVname()).append(data.getVersion()).append(data.getCharset()).append(data.getMsgSender());
        if (!Strings.isNullOrEmpty((String)data.getSendTime())) {
            sb.append(data.getSendTime());
        }
        sb.append(data.getOrderId()).append(data.getOrderAmount());
        sb.append(data.getOrderTime()).append(data.getPayType());
        if (!Strings.isNullOrEmpty((String)data.getInstCode())) {
            sb.append(data.getInstCode());
        }
        sb.append(data.getPageUrl()).append(data.getNotifyUrl());
        if (!Strings.isNullOrEmpty((String)data.getProductName())) {
            sb.append(data.getProductName());
        }
        if (!Strings.isNullOrEmpty((String)data.getBuyerContact())) {
            sb.append(data.getBuyerContact());
        }
        sb.append(data.getBuyerIp());
        if (!Strings.isNullOrEmpty((String)data.getExt1())) {
            sb.append(data.getExt1());
        }
        sb.append(data.getSignType());
        logger.debug("sft_origin={}", (Object)sb.toString());
        String signMsg = MD5Utils.getMD5Str((String)(sb.toString() + bizKey)).toUpperCase();
        logger.debug("sft_signMsg={}", (Object)signMsg);
        return signMsg;
    }

    public static int getFareAmt(String shengpayType, int orderMoney) {
        if (orderMoney <= 0) {
            return 0;
        }
        double fareFee = ShengpayChannelInfo.gateFare(shengpayType);
        return (int)Math.round(fareFee * (double)orderMoney);
    }
}

