/*
 * Decompiled with CFR 0.152.
 */
package com.xunlei.channel.gateway.pay.channels.qishun;

import com.xunlei.channel.gateway.common.constants.InterfaceReqResult;
import com.xunlei.channel.gateway.common.result.DirectReturnResult;
import com.xunlei.channel.gateway.common.result.ReturnResult;
import com.xunlei.channel.gateway.common.utils.HttpUtils;
import com.xunlei.channel.gateway.pay.annotation.PayType;
import com.xunlei.channel.gateway.pay.channels.AbstractChannelHandler;
import com.xunlei.channel.gateway.pay.channels.qishun.QishunChannelData;
import com.xunlei.channel.gateway.pay.channels.qishun.QishunChannelInfo;
import com.xunlei.channel.gateway.pay.channels.qishun.QishunChannelUtils;
import com.xunlei.channel.gateway.pay.pojo.UnitedPayRequest;
import com.xunlei.channel.thundercore.client.util.Arith;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
@PayType(value="H", desc="\u9f50\u987a")
public class QishunChannelHandler
extends AbstractChannelHandler<ReturnResult> {
    private static final Logger logger = LoggerFactory.getLogger(QishunChannelHandler.class);
    @Autowired
    private QishunChannelInfo qishunChannelInfo;
    private static final String MERCHANT = "0";
    private static final String VIP_MERCHANT = "1";

    public QishunChannelData getQishunChannelData(UnitedPayRequest unitedPayRequest) {
        QishunChannelData qishunChannelaData = new QishunChannelData();
        int proNo = 1;
        int area = 0;
        int confirm = 0;
        String rmb = new Double(Arith.div((double)unitedPayRequest.getOrderAmt(), (double)100.0)).intValue() + "";
        qishunChannelaData.setOrderId(unitedPayRequest.getXunleiPayId());
        qishunChannelaData.setArea(area + "");
        qishunChannelaData.setConfirm(confirm + "");
        qishunChannelaData.setProNo(proNo + "");
        qishunChannelaData.setUip(unitedPayRequest.getClientIp());
        qishunChannelaData.setRmb(rmb);
        qishunChannelaData.setUser(unitedPayRequest.getUserShow());
        String bizNo = unitedPayRequest.getBizNo();
        String payType = unitedPayRequest.getPayType();
        logger.debug("get qishunChannelaData {},", (Object)qishunChannelaData);
        if (bizNo.equals("000001027") && payType.equals("H")) {
            qishunChannelaData = this.getThunderData(qishunChannelaData, unitedPayRequest);
            String applyUrl = QishunChannelUtils.genQishunApplyUrl(qishunChannelaData, this.qishunChannelInfo.getThunderMerchantKey(), this.qishunChannelInfo.getQishunApplyUrl());
            qishunChannelaData.setApplyUrl(applyUrl);
        } else if (payType.equals("H")) {
            String key = this.qishunChannelInfo.getVipMerchantKey();
            qishunChannelaData = this.getVipData(qishunChannelaData, unitedPayRequest);
            String applyUrl = QishunChannelUtils.genQishunApplyUrl(qishunChannelaData, key, this.qishunChannelInfo.getQishunApplyUrl());
            qishunChannelaData.setApplyUrl(applyUrl);
        }
        return qishunChannelaData;
    }

    private QishunChannelData getThunderData(QishunChannelData qishunChannelaData, UnitedPayRequest unitedPayRequest) {
        String rmb = qishunChannelaData.getRmb();
        String productIDSuffix = QishunChannelUtils.formatQishunRmb(new Double(Arith.mul((double)new Double(rmb), (double)0.5)).intValue());
        String productId = this.qishunChannelInfo.getThunderProductNo() + productIDSuffix;
        String kkt = "";
        String channelId = "";
        String typeAndPhone = unitedPayRequest.getExtraParam("phone");
        if (typeAndPhone.contains("\\|")) {
            String[] typeAndPhoneArray = typeAndPhone.split("\\|");
            String type = typeAndPhoneArray[0];
            channelId = "209";
            if (type.equals("T")) {
                String number = unitedPayRequest.getExtraParam("number");
                logger.info("the qishun number that the user called is {}", (Object)number);
                if (null != number && number.length() > 0) {
                    if ("02".equals(number)) {
                        channelId = "202";
                    } else if ("03".equals(number)) {
                        channelId = "208";
                    } else if ("04".equals(number)) {
                        channelId = "210";
                    }
                }
            } else if (type.equals("C")) {
                channelId = "2332";
                kkt = VIP_MERCHANT;
            } else if ("G".equals(type)) {
                channelId = "2441";
            }
        }
        qishunChannelaData.setTel(typeAndPhone);
        qishunChannelaData.setRmb(rmb);
        qishunChannelaData.setKkt(kkt);
        qishunChannelaData.setChannelId(channelId);
        qishunChannelaData.setProductId(productId);
        qishunChannelaData.setPhoneType("");
        qishunChannelaData.setProductType("2");
        qishunChannelaData.setMerchantNo(this.qishunChannelInfo.getThunderMerchentNo());
        logger.info("tel={},rmb={},channelId={},productId={}", new Object[]{typeAndPhone, rmb, channelId, productId});
        return qishunChannelaData;
    }

    private QishunChannelData getVipData(QishunChannelData qishunChannelaData, UnitedPayRequest unitedPayRequest) {
        String channelId = "209";
        String typeAndPhone = unitedPayRequest.getExtraParam("phone");
        String[] typeAndPhoneArray = typeAndPhone.split("\\|");
        String type = typeAndPhoneArray[0];
        String phone = typeAndPhoneArray[1];
        logger.info("type={},phone={}", (Object)type, (Object)phone);
        if ("T".equals(type)) {
            String number = unitedPayRequest.getExtraParam("number");
            logger.info("the qishun number that the user called is {}", (Object)number);
            if (null != number && number.length() > 0) {
                if ("02".equals(number)) {
                    channelId = "202";
                } else if ("03".equals(number)) {
                    channelId = "208";
                } else if ("04".equals(number)) {
                    channelId = "210";
                }
            }
            channelId = "209";
        } else if ("C".equals(type)) {
            channelId = "209";
        } else if ("G".equals(type)) {
            channelId = "2441";
        }
        String rmb = qishunChannelaData.getRmb();
        String productId = null;
        switch (Integer.parseInt(rmb)) {
            case 15: {
                productId = "010";
                break;
            }
            case 30: {
                productId = "002";
                break;
            }
            case 20: {
                productId = "011";
            }
        }
        String formattedRmb = QishunChannelUtils.formatQishunRmb(Integer.parseInt(rmb));
        qishunChannelaData.setRmb(formattedRmb);
        qishunChannelaData.setChannelId(channelId);
        qishunChannelaData.setKkt("");
        qishunChannelaData.setProductId(productId);
        qishunChannelaData.setTel(phone);
        qishunChannelaData.setPhoneType(type);
        qishunChannelaData.setProductType(VIP_MERCHANT);
        qishunChannelaData.setMerchantNo(this.qishunChannelInfo.getVipMerchentNo());
        logger.info("tel={},rmb={},channelId={},productId={}", new Object[]{phone, rmb, channelId, productId});
        logger.debug("return qishunChannelaData {}", (Object)qishunChannelaData);
        return qishunChannelaData;
    }

    @Override
    public ReturnResult generateChannelResult(UnitedPayRequest unitedPayRequest) {
        logger.debug("generateChannelResult...");
        try {
            QishunChannelData qishunChannelData = this.getQishunChannelData(unitedPayRequest);
            String qishunUrl = qishunChannelData.getApplyUrl();
            String response = HttpUtils.doGet((String)qishunUrl, (int)10000, (int)10000);
            logger.info("return response,{}", (Object)response);
            if (VIP_MERCHANT.equals(response)) {
                return new DirectReturnResult(InterfaceReqResult.SUCCESS, response, unitedPayRequest.getXunleiPayId(), "pay_success_page", null);
            }
            return new DirectReturnResult(InterfaceReqResult.FAIL, response, "pay fail!", "pay_fail_page", null);
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            return new DirectReturnResult(InterfaceReqResult.FAIL, MERCHANT, "unknow error," + e.getMessage(), "pay_fail_page", null);
        }
    }

    @Override
    public ReturnResult validateSpecialParams(UnitedPayRequest unitedPayRequest) {
        String payType;
        String rmb = new Double(Arith.div((double)unitedPayRequest.getOrderAmt(), (double)100.0)).intValue() + "";
        String[] typeAndPhoneArray = null;
        if (!QishunChannelUtils.isFixLenDigit(rmb, 2)) {
            logger.debug("invalid orderamt:{}", (Object)unitedPayRequest.getOrderAmt());
            return new DirectReturnResult(InterfaceReqResult.FAIL, "13", "invalid orderamt!", "pay_fail_page", null);
        }
        String bankNo = unitedPayRequest.getExtraParam("phone");
        if (QishunChannelUtils.isEmpty(bankNo)) {
            return new DirectReturnResult(InterfaceReqResult.FAIL, "13", "the phone is null!", "pay_fail_page", null);
        }
        logger.info("get bankNo ,the bankNo is={}", (Object)bankNo);
        if (!bankNo.contains("|")) {
            return new DirectReturnResult(InterfaceReqResult.FAIL, "13", "other1 must be type|tel format\uff0c for example T|13246738864", "pay_fail_page", null);
        }
        if (bankNo.contains("|")) {
            typeAndPhoneArray = bankNo.split("|");
            if (typeAndPhoneArray.length < 2) {
                logger.error("the format of bankNo is wrong,bankNo={},the format must be bankNo=type|phone", (Object)bankNo);
                return new DirectReturnResult(InterfaceReqResult.FAIL, "13", "the phone is null!", "pay_fail_page", null);
            }
            if (typeAndPhoneArray.length < 2) {
                logger.error("the format of bankNo is wrong,bankNo={},the format must be bankNo=type|phone", (Object)bankNo);
                return new DirectReturnResult(InterfaceReqResult.FAIL, "13", "the phone is null!", "pay_fail_page", null);
            }
        }
        if (typeAndPhoneArray != null) {
            String type = bankNo.substring(0, 1);
            logger.info("type={}", (Object)type);
            if (!(type.equals("C") || type.equals("T") || type.equals("G"))) {
                logger.info("invalid qishun type:{}", (Object)type);
                return new DirectReturnResult(InterfaceReqResult.FAIL, "13", "invalid qishun type", "pay_fail_page", null);
            }
        }
        if ((payType = unitedPayRequest.getPayType()).equals("H") && !rmb.equals("20") && !rmb.equals("15") && !rmb.equals("30")) {
            logger.error("invalid orderAmt {}", (Object)rmb);
            return new DirectReturnResult(InterfaceReqResult.FAIL, "13", "invalid orderAmt", "pay_fail_page", null);
        }
        return null;
    }

    @Override
    public String analyzeExtParams(UnitedPayRequest unitedPayRequest) {
        String bizNo = unitedPayRequest.getBizNo();
        String payType = unitedPayRequest.getPayType();
        if (bizNo.equals("000001027") && payType.equals("H")) {
            return "{\"product_type\":\"0\"}";
        }
        if (payType.equals("H")) {
            return "{\"product_type\":\"1\"}";
        }
        return null;
    }
}

