/*
 * Decompiled with CFR 0.152.
 */
package com.xunlei.channel.gateway.pay.channels.huiyuan;

import com.xunlei.channel.db.pojo.PayOrder;
import com.xunlei.channel.db.pojo.PayOrderOk;
import com.xunlei.channel.gateway.common.constants.InterfaceReqResult;
import com.xunlei.channel.gateway.common.result.DirectReturnResult;
import com.xunlei.channel.gateway.common.result.ReturnResult;
import com.xunlei.channel.gateway.pay.annotation.PayType;
import com.xunlei.channel.gateway.pay.channels.AbstractChannelHandler;
import com.xunlei.channel.gateway.pay.channels.huiyuan.HuiyuanChannelData;
import com.xunlei.channel.gateway.pay.channels.huiyuan.HuiyuanChannelService;
import com.xunlei.channel.gateway.pay.pojo.UnitedPayRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
@PayType(value="HY", desc="\u4f1a\u5458\u5546\u52a1\u63a8\u5e7f")
public class HuiyuanChannelHandler
extends AbstractChannelHandler<ReturnResult> {
    private static final Logger logger = LoggerFactory.getLogger(HuiyuanChannelHandler.class);
    @Autowired
    private HuiyuanChannelService huiyuanChannelService;

    @Override
    public ReturnResult generateChannelResult(UnitedPayRequest unitedPayRequest) {
        PayOrderOk payOrderOk;
        logger.debug("generateChannelResult...");
        boolean isSuccess = false;
        PayOrder payOrder = this.huiyuanChannelService.getPayOrder(unitedPayRequest.getXunleiPayId());
        HuiyuanChannelData data = new HuiyuanChannelData();
        data.setOrderId(payOrder.getXunleiPayId());
        data.setRmb(unitedPayRequest.getOrderAmt() + "");
        if (payOrder != null && (payOrderOk = this.huiyuanChannelService.dealWithPayOrder(payOrder, data)) != null) {
            isSuccess = true;
        }
        logger.info("the result is {}", (Object)isSuccess);
        if (isSuccess) {
            return new DirectReturnResult(InterfaceReqResult.SUCCESS, "00", "", null, null);
        }
        return new DirectReturnResult(InterfaceReqResult.FAIL, "99", "\u7a0b\u5e8f\u5f02\u5e38\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5", "pay_fail_page", null);
    }
}

