/*
 * Decompiled with CFR 0.152.
 */
package com.xunlei.channel.gateway.pay.channels.ext19paywireless;

import com.google.common.base.Strings;
import com.xunlei.channel.db.pojo.PayOrder;
import com.xunlei.channel.gateway.common.pay.ChannelData;
import com.xunlei.channel.gateway.common.utils.JsonUtils;
import com.xunlei.channel.gateway.pay.channels.AbstractChannelService;
import com.xunlei.channel.gateway.pay.channels.ext19paywireless.Ext19PayWirelessChannelInfo;
import com.xunlei.channel.gateway.pay.channels.ext19paywireless.Ext19PayWirelessUtil;
import com.xunlei.xlcommons.util.Arith.Arith;
import com.xunlei.xlcommons.util.MD5.Md5Encrypt;
import com.xunlei.xlcommons.util.encrypt.DESEncrypt;
import java.util.HashMap;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class Ext19PayWirelessNotifyService
extends AbstractChannelService {
    private static final Logger logger = LoggerFactory.getLogger(Ext19PayWirelessNotifyService.class);
    private static final String SUCCESS = "Y";
    private static final String FAIL = "N";
    @Autowired
    Ext19PayWirelessChannelInfo ext19WirelessPayChannelInfo;

    public String returnNotify(HttpServletRequest request) {
        logger.debug("enter the Ext19WirelessPayNotifyService returnNotify,with params:{}", (Object)request.getParameterMap());
        String versionId = request.getParameter("version_id");
        String merchantId = request.getParameter("merchant_id");
        String verifyString = request.getParameter("verifystring");
        String orderDate = request.getParameter("order_date");
        String orderId = request.getParameter("order_id");
        String result = request.getParameter("result");
        logger.info("version_id:{},merchant_id:{},verifystring:{},result:{}", new Object[]{versionId, merchantId, verifyString, result});
        String amount = request.getParameter("amount");
        String currency = request.getParameter("currency");
        final String paySq = request.getParameter("pay_sq");
        String payDate = request.getParameter("pay_date");
        String count = request.getParameter("count");
        String cardNum = request.getParameter("card_num1");
        String cardPwd = request.getParameter("card_pwd1");
        String pcId = request.getParameter("pc_id1");
        String cardStatus = request.getParameter("card_status1");
        String cardCode = request.getParameter("card_code1");
        String cardDate = request.getParameter("card_date1");
        String r1 = request.getParameter("r1");
        String merchantKey = this.ext19WirelessPayChannelInfo.getConfigValue("merchant_key");
        String md5Str = "version_id=" + versionId + "&merchant_id=" + merchantId + "&order_id=" + orderId + "&result=" + result + "&order_date=" + orderDate + "&amount=" + amount + "&currency=" + currency + "&pay_sq=" + paySq + "&pay_date=" + payDate + "&count=" + count + "&card_num1=" + cardNum + "&card_pwd1=" + cardPwd + "&pc_id1=" + pcId + "&card_status1=" + cardStatus + "&card_code1=" + cardCode + "&card_date1=" + cardDate + "&r1=" + r1 + "&merchant_key=" + merchantKey;
        String sign = Md5Encrypt.encode((String)md5Str, (String)"UTF-8");
        logger.info("sign md5Str:{} get signInfo:{}", new Object[]{md5Str, sign});
        if (sign == null || !sign.toLowerCase().equals(verifyString)) {
            logger.error("sign is not right,return N");
            return FAIL;
        }
        if (Strings.isNullOrEmpty((String)merchantId) || Strings.isNullOrEmpty((String)orderId) || Strings.isNullOrEmpty((String)amount) || Strings.isNullOrEmpty((String)currency)) {
            logger.info("orderId/merchantId/amount/currency is null,return N");
            return FAIL;
        }
        PayOrder payOrder = this.getPayOrderByXunleiPayId(orderId);
        if (payOrder == null) {
            logger.error("return notify cannot find payOrder with xunleiPayId:{}", (Object)orderId);
            return FAIL;
        }
        if ("S".equals(payOrder.getStatus())) {
            logger.info("payOrder:{} status was success,do nothing and return", (Object)orderId);
            return SUCCESS;
        }
        String cardNoDecode = "";
        String cardPwdDecode = "";
        try {
            cardNoDecode = DESEncrypt.decryptData((String)cardNum, (String)merchantKey.substring(0, 8));
            cardPwdDecode = DESEncrypt.decryptData((String)cardPwd, (String)merchantKey.substring(0, 8));
        }
        catch (Exception e) {
            logger.error("", (Throwable)e);
        }
        HashMap<String, String> extraJsonMap = new HashMap<String, String>();
        extraJsonMap.put("card_pwd", Ext19PayWirelessUtil.getNotEmptyStr(cardPwdDecode));
        extraJsonMap.put("card_no", Ext19PayWirelessUtil.getNotEmptyStr(cardNoDecode));
        extraJsonMap.put("pay_date", Ext19PayWirelessUtil.getNotEmptyStr(payDate));
        extraJsonMap.put("count", Ext19PayWirelessUtil.getNotEmptyStr(count));
        extraJsonMap.put("remain", Ext19PayWirelessUtil.getNotEmptyStr(r1));
        final String extraJson = JsonUtils.toJson(extraJsonMap);
        if ("F".equals(result)) {
            logger.info("orderId:{} is payed failed with errCode:{}", new Object[]{orderId, cardCode});
            try {
                this.processPayFail(payOrder, cardCode, "", paySq, extraJson);
            }
            catch (Exception e) {
                logger.error("", (Throwable)e);
                return FAIL;
            }
            return SUCCESS;
        }
        if (SUCCESS.equals(result)) {
            double amountDouble;
            try {
                amountDouble = Double.valueOf(amount);
            }
            catch (Exception e) {
                logger.error("", (Throwable)e);
                return FAIL;
            }
            final int orderAmt = payOrder.getOrderAmt();
            if (!merchantId.equals(this.ext19WirelessPayChannelInfo.getConfigValue("merchant_id")) || Math.abs(Arith.sub((double)amountDouble, (double)Arith.div((double)orderAmt, (double)100.0))) > 0.01 || !currency.equals("RMB")) {
                logger.info("merchantId/amount/orderid/currency is not right");
                return FAIL;
            }
            final double PAY_RATE = this.ext19WirelessPayChannelInfo.getConfigValueDouble("fee_rate");
            ChannelData channelData = new ChannelData(){

                public int getFareAmt() {
                    return (int)((double)orderAmt * PAY_RATE);
                }

                public int getFactAmt() {
                    return orderAmt - (int)((double)orderAmt * PAY_RATE);
                }

                public String getChannelOrderId() {
                    return Ext19PayWirelessUtil.getNotEmptyStr(paySq);
                }

                public String generateOkExtJson() {
                    return extraJson;
                }
            };
            try {
                this.processPaySuccess(payOrder, channelData);
            }
            catch (Exception e) {
                logger.error("", (Throwable)e);
                return FAIL;
            }
            return SUCCESS;
        }
        logger.error("result:{} is not valid result", (Object)result);
        return FAIL;
    }
}

