/*
 * Decompiled with CFR 0.152.
 */
package com.xunlei.channel.gateway.pay.channels.ext19paywireless;

import com.google.common.base.Strings;
import com.xunlei.channel.db.pojo.PayOrder;
import com.xunlei.channel.gateway.common.constants.InterfaceReqResult;
import com.xunlei.channel.gateway.common.result.DirectReturnResult;
import com.xunlei.channel.gateway.common.utils.JsonUtils;
import com.xunlei.channel.gateway.pay.annotation.PayType;
import com.xunlei.channel.gateway.pay.channels.AbstractChannelService;
import com.xunlei.channel.gateway.pay.channels.ChannelHandler;
import com.xunlei.channel.gateway.pay.channels.ext19paywireless.Ext19PayWirelessChannelData;
import com.xunlei.channel.gateway.pay.channels.ext19paywireless.Ext19PayWirelessChannelInfo;
import com.xunlei.channel.gateway.pay.channels.ext19paywireless.Ext19PayWirelessUtil;
import com.xunlei.channel.gateway.pay.pojo.UnitedPayRequest;
import com.xunlei.xlcommons.util.Arith.UnitArith;
import com.xunlei.xlcommons.util.Date.DateUtil;
import com.xunlei.xlcommons.util.http.HttpClientUtil;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
@PayType(value="J2", desc="\u6377\u8fc5\u65e0\u7ebf\u5145\u503c\u5361|\u9ad8\u9633\u6377\u8fc5")
public class Ext19PayWirelessChannelHandler
extends AbstractChannelService
implements ChannelHandler<DirectReturnResult> {
    private static final Logger logger = LoggerFactory.getLogger(Ext19PayWirelessChannelHandler.class);
    @Autowired
    private Ext19PayWirelessChannelInfo ext19WirelessPayChannelInfo;

    @Override
    public DirectReturnResult generateChannelResult(UnitedPayRequest unitedPayRequest) {
        try {
            Ext19PayWirelessChannelData ext19WirelessPayChannelData = this.generateChannelData(unitedPayRequest);
            String orderId = ext19WirelessPayChannelData.getOrderId();
            Map<String, String> payUrlParams = Ext19PayWirelessUtil.createPostParams(ext19WirelessPayChannelData);
            logger.info("postparams:{}", payUrlParams);
            if (payUrlParams == null) {
                throw new Exception("post params is null");
            }
            String resp = HttpClientUtil.doPost((String)ext19WirelessPayChannelData.getPayUrl(), payUrlParams, null, null);
            logger.info("orderId:{} post with resp:{}", (Object)orderId, (Object)resp);
            if (Strings.isNullOrEmpty((String)resp)) {
                throw new Exception("post resp is empty");
            }
            Map<String, String> respMap = Ext19PayWirelessUtil.getReturnCodeFromSyncResp(resp, ext19WirelessPayChannelData);
            if (respMap == null) {
                return new DirectReturnResult(InterfaceReqResult.FAIL, "", "\u7cfb\u7edf\u5f02\u5e38\uff0c\u8bf7\u7a0d\u540e\u786e\u8ba4\u652f\u4ed8\u7ed3\u679c", "pay_fail_page", null);
            }
            String result = respMap.get("result");
            String errCode = respMap.get("resultstr");
            if (!"P".equals(result)) {
                if (Strings.isNullOrEmpty((String)errCode)) {
                    errCode = "99";
                }
                logger.info("orderId:{} pay req failed with errcode:{}", (Object)ext19WirelessPayChannelData.getOrderId(), (Object)errCode);
                PayOrder payOrder = this.getPayOrderByXunleiPayId(orderId);
                if (null != payOrder) {
                    this.processPayFail(payOrder, errCode, "\u4e0b\u5355\u5931\u8d25", orderId, "");
                }
                return new DirectReturnResult(InterfaceReqResult.FAIL, errCode, "\u4e0b\u5355\u5931\u8d25", "pay_fail_page", null);
            }
            logger.info("orderId:{} pay req successed", (Object)ext19WirelessPayChannelData.getOrderId());
            return new DirectReturnResult(InterfaceReqResult.SUCCESS, "", "", "pay_success_page", null);
        }
        catch (Exception e) {
            logger.error("", (Throwable)e);
            return new DirectReturnResult(InterfaceReqResult.FAIL, "99", "\u7cfb\u7edf\u5f02\u5e38\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5\uff01", "pay_fail_page", null);
        }
    }

    protected Ext19PayWirelessChannelData generateChannelData(UnitedPayRequest unitedPayRequest) throws Exception {
        String orderId = unitedPayRequest.getXunleiPayId();
        String cardNo = unitedPayRequest.getExtraParamsMap().get("card_no");
        String cardPwd = unitedPayRequest.getExtraParamsMap().get("card_pwd");
        String cardAmt = unitedPayRequest.getExtraParamsMap().get("card_amt");
        String cardType = unitedPayRequest.getExtraParamsMap().get("card_type");
        String[] pcAndPm = this.ext19WirelessPayChannelInfo.getPmPcInfoByCardType(cardType);
        String pcId = pcAndPm[0];
        String pmId = pcAndPm[1];
        Ext19PayWirelessChannelData ext19WirelessPayChannelData = new Ext19PayWirelessChannelData();
        ext19WirelessPayChannelData.setCardAmt(cardAmt);
        ext19WirelessPayChannelData.setCardNo(cardNo);
        ext19WirelessPayChannelData.setCardPwd(cardPwd);
        ext19WirelessPayChannelData.setCurrency("RMB");
        ext19WirelessPayChannelData.setMerchantId(this.ext19WirelessPayChannelInfo.getConfigValue("merchant_id"));
        ext19WirelessPayChannelData.setMerchantKey(this.ext19WirelessPayChannelInfo.getConfigValue("merchant_key"));
        ext19WirelessPayChannelData.setNotifyUrl(this.ext19WirelessPayChannelInfo.getConfigValue("notify_url"));
        ext19WirelessPayChannelData.setOrderAmt(UnitArith.fenToyuan((double)unitedPayRequest.getOrderAmt()));
        ext19WirelessPayChannelData.setOrderDate(DateUtil.getCurrentTime((String)"yyyyMMdd"));
        ext19WirelessPayChannelData.setOrderId(orderId);
        ext19WirelessPayChannelData.setPayUrl(this.ext19WirelessPayChannelInfo.getConfigValue("pay_url"));
        ext19WirelessPayChannelData.setPcId(pcId);
        ext19WirelessPayChannelData.setPmId(pmId);
        ext19WirelessPayChannelData.setRetMode("");
        ext19WirelessPayChannelData.setRetUrl("");
        ext19WirelessPayChannelData.setVersionId("2.00");
        return ext19WirelessPayChannelData;
    }

    @Override
    public DirectReturnResult validateSpecialParams(UnitedPayRequest unitedPayRequest) {
        String cardNo = unitedPayRequest.getExtraParamsMap().get("card_no");
        String cardPwd = unitedPayRequest.getExtraParamsMap().get("card_pwd");
        String cardAmt = unitedPayRequest.getExtraParamsMap().get("card_amt");
        String cardType = unitedPayRequest.getExtraParamsMap().get("card_type");
        if (Strings.isNullOrEmpty((String)cardNo)) {
            logger.error("invalid card_no:{}", (Object)cardNo);
            return new DirectReturnResult(InterfaceReqResult.FAIL, "13", "invalid param card_no", "pay_fail_page", null);
        }
        if (Strings.isNullOrEmpty((String)cardPwd)) {
            logger.error("invalid card_pwd:{}", (Object)cardPwd);
            return new DirectReturnResult(InterfaceReqResult.FAIL, "13", "invalid param card_pwd", "pay_fail_page", null);
        }
        if (Strings.isNullOrEmpty((String)cardAmt)) {
            logger.error("invalid card_amt:{}", (Object)cardAmt);
            return new DirectReturnResult(InterfaceReqResult.FAIL, "13", "invalid param card_amt", "pay_fail_page", null);
        }
        try {
            if (Strings.isNullOrEmpty((String)cardType) || this.ext19WirelessPayChannelInfo.getPmPcInfoByCardType(cardType) == null) {
                logger.error("invalid card_type:{}", (Object)cardType);
                return new DirectReturnResult(InterfaceReqResult.FAIL, "13", "invalid param card_type", "pay_fail_page", null);
            }
        }
        catch (Exception e) {
            logger.error("", (Throwable)e);
            return new DirectReturnResult(InterfaceReqResult.FAIL, "99", "\u7cfb\u7edf\u5f02\u5e38\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5\uff01", "pay_fail_page", null);
        }
        return null;
    }

    @Override
    public String analyzeExtParams(UnitedPayRequest unitedPayRequest) {
        String cardNo = unitedPayRequest.getExtraParamsMap().get("card_no");
        String cardPwd = unitedPayRequest.getExtraParamsMap().get("card_pwd");
        String cardAmt = unitedPayRequest.getExtraParamsMap().get("card_amt");
        String cardType = unitedPayRequest.getExtraParamsMap().get("card_type");
        HashMap<String, String> extParams = new HashMap<String, String>();
        extParams.put("card_no", cardNo);
        extParams.put("card_pwd", cardPwd);
        extParams.put("card_amt", cardAmt);
        extParams.put("card_type", cardType);
        return JsonUtils.toJson(extParams);
    }

    @Override
    public String generateRemark(UnitedPayRequest payRequest) {
        return null;
    }
}

