/*
 * Decompiled with CFR 0.152.
 */
package com.xunlei.channel.gateway.pay.channels.ext19pay;

import com.google.common.base.Strings;
import com.xunlei.channel.gateway.common.utils.StringUtils;
import com.xunlei.xlcommons.util.MD5.Md5Encrypt;
import java.net.URLEncoder;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Ext19PayUtil {
    private static final Logger logger = LoggerFactory.getLogger(Ext19PayUtil.class);

    private Ext19PayUtil() {
    }

    public static String generatePayUrl(String payUrl, String notifyUrl, Map<String, String> params, String md5Key) throws Exception {
        String versionId = params.get("version_id").trim();
        String merchantId = params.get("merchant_id").trim();
        String orderDate = params.get("order_date").trim();
        String orderId = params.get("order_id").trim();
        String amount = params.get("amount").trim();
        String currency = params.get("currency").trim();
        String retUrl = params.get("ret_url").trim();
        String pmId = params.get("pm_id").trim();
        String pcId = params.get("pc_id").trim();
        String orderPname = params.get("order_pname").trim();
        String orderPdesc = params.get("order_pdesc").trim();
        String merchantKey = md5Key.trim();
        if (StringUtils.isAnyNullOrEmpty((String[])new String[]{versionId, merchantId, orderDate, orderId, amount, currency, retUrl})) {
            logger.error("version_id:{},merchant_id:{},order_date:{},order_id:{},amount:{},currency:{},ret_url:{} any is null,create pay url failed", new Object[]{versionId, merchantId, orderDate, orderId, amount, currency, retUrl});
            return null;
        }
        String verifystring = "version_id=" + versionId + "&merchant_id=" + merchantId + "&order_date=" + orderDate + "&order_id=" + orderId + "&amount=" + amount + "&currency=" + currency + "&returl=" + retUrl + "&pm_id=" + pmId + "&pc_id=" + pcId + "&merchant_key=" + merchantKey;
        logger.debug("verifystring:{}", (Object)verifystring);
        String signMsg = Md5Encrypt.encode((String)verifystring, (String)"UTF-8");
        logger.debug("signMsg:{}", (Object)signMsg);
        String gb_pname = "";
        String gb_pdesc = "";
        if (!Strings.isNullOrEmpty((String)orderPname)) {
            gb_pname = URLEncoder.encode(orderPname, "GB2312");
        }
        if (!Strings.isNullOrEmpty((String)orderPdesc)) {
            gb_pdesc = URLEncoder.encode(orderPdesc, "GB2312");
        }
        logger.debug("gb_pname:{},gb_pdesc:{}", (Object)gb_pname, (Object)gb_pdesc);
        String reqUrl = payUrl + "?" + verifystring + "&verifystring=" + signMsg + "&notify_url=" + notifyUrl + "&order_pname=" + gb_pname + "&order_pdesc=" + gb_pdesc + "&user_name=" + "&user_phone=" + "&user_mobile=" + "&user_email=";
        logger.info("pay url:{}", (Object)reqUrl);
        return reqUrl;
    }
}

