/*
 * Decompiled with CFR 0.152.
 */
package com.xunlei.channel.gateway.pay.channels.baiduwallet;

import com.google.common.base.Strings;
import com.xunlei.channel.gateway.common.utils.MD5Utils;
import com.xunlei.channel.gateway.common.utils.SHA1Utils;
import com.xunlei.channel.gateway.pay.channels.baiduwallet.BaiduWalletChannelData;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class BaiduWalletUtils {
    private static final String SDK_MD5 = "1";
    private static final Logger logger = LoggerFactory.getLogger(BaiduWalletUtils.class);

    public static BaiduWalletChannelData parseNotifyData(HttpServletRequest request) {
        BaiduWalletChannelData data = new BaiduWalletChannelData();
        data.setSpNo(request.getParameter("sp_no"));
        data.setOrderNo(request.getParameter("order_no"));
        data.setBfbOrderNo(request.getParameter("bfb_order_no"));
        data.setBfbOrderCreateTime(request.getParameter("bfb_order_create_time"));
        data.setPayTime(request.getParameter("pay_time"));
        data.setPayType(request.getParameter("pay_type"));
        data.setBankNo(request.getParameter("bank_no"));
        data.setUnitAmount(BaiduWalletUtils.getIntParam(request.getParameter("unit_amount")));
        data.setUnitCount(BaiduWalletUtils.getIntParam(request.getParameter("unit_count")));
        data.setTransportAmount(BaiduWalletUtils.getIntParam(request.getParameter("transport_amount")));
        data.setTotalAmount(BaiduWalletUtils.getIntParam(request.getParameter("total_amount")));
        data.setFeeAmount(BaiduWalletUtils.getIntParam(request.getParameter("fee_amount")));
        data.setCurrency(request.getParameter("currency"));
        data.setBuyerSpUsername(BaiduWalletUtils.convertCharset(request, "buyer_sp_username", "utf8", "gbk"));
        data.setPayResult(request.getParameter("pay_result"));
        data.setInputCharset(request.getParameter("input_charset"));
        data.setVersion(request.getParameter("version"));
        data.setSign(request.getParameter("sign"));
        data.setSignMethod(request.getParameter("sign_method"));
        data.setExtra(request.getParameter("extra"));
        return data;
    }

    private static String convertCharset(HttpServletRequest request, String name, String fromCharset, String charset) {
        String param = "";
        try {
            String value = request.getParameter(name);
            if (Strings.isNullOrEmpty((String)value)) {
                return param;
            }
            param = new String(value.getBytes(fromCharset), charset);
            logger.debug("param:{},value:{}", (Object)name, (Object)param);
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
        return param;
    }

    private static Integer getIntParam(String value) {
        if (Strings.isNullOrEmpty((String)value)) {
            return null;
        }
        try {
            return Integer.parseInt(value);
        }
        catch (NumberFormatException e) {
            logger.error("NumberFormatException occurs while parsing {}", (Object)value);
            return null;
        }
    }

    public static String generatedRespSignMsg(BaiduWalletChannelData data) {
        String signMsg;
        StringBuilder sb = new StringBuilder();
        sb.append("bank_no=");
        if (!Strings.isNullOrEmpty((String)data.getBankNo())) {
            sb.append(data.getBankNo());
        }
        sb.append("&bfb_order_create_time=").append(data.getBfbOrderCreateTime());
        sb.append("&bfb_order_no=").append(data.getBfbOrderNo());
        sb.append("&buyer_sp_username=");
        if (!Strings.isNullOrEmpty((String)data.getBuyerSpUsername())) {
            sb.append(data.getBuyerSpUsername());
        }
        sb.append("&currency=").append(data.getCurrency());
        sb.append("&extra=");
        if (!Strings.isNullOrEmpty((String)data.getExtra())) {
            sb.append(data.getExtra());
        }
        sb.append("&fee_amount=").append(data.getFeeAmount());
        sb.append("&input_charset=").append(data.getInputCharset());
        sb.append("&order_no=").append(data.getOrderNo());
        sb.append("&pay_result=").append(data.getPayResult());
        sb.append("&pay_time=").append(data.getPayTime());
        sb.append("&pay_type=").append(data.getPayType());
        sb.append("&sign_method=").append(data.getSignMethod());
        sb.append("&sp_no=").append(data.getSpNo());
        sb.append("&total_amount=").append(data.getTotalAmount());
        sb.append("&transport_amount=");
        if (null != data.getTransportAmount()) {
            sb.append(data.getTransportAmount());
        }
        sb.append("&unit_amount=");
        if (data.getUnitAmount() != null) {
            sb.append(data.getUnitAmount());
        }
        sb.append("&unit_count=");
        if (null != data.getUnitCount()) {
            sb.append(data.getUnitCount());
        }
        sb.append("&version=").append(data.getVersion());
        logger.info("baidu_wallet_notify_response:{}", (Object)sb.toString());
        sb.append("&key=").append(data.getSpKey());
        logger.debug("before sign str:{}", (Object)sb);
        if (SDK_MD5.equals(data.getSignMethod())) {
            signMsg = MD5Utils.getMD5Str((String)sb.toString()).toUpperCase();
        } else if ("2".equals(data.getSignMethod())) {
            logger.debug("SHA-1 method...");
            signMsg = new SHA1Utils().Digest(sb.toString(), "gbk").toUpperCase();
        } else {
            logger.warn("unknow signmethod:{}", (Object)data.getSignMethod());
            signMsg = "-1";
        }
        logger.info("signMsg:{}", (Object)signMsg);
        return signMsg;
    }

    public static String generateReqSignMsg(BaiduWalletChannelData data) {
        StringBuilder sb = new StringBuilder();
        sb.append("buyer_sp_username=");
        if (!Strings.isNullOrEmpty((String)data.getBuyerSpUsername())) {
            sb.append(data.getBuyerSpUsername());
        }
        sb.append("&currency=");
        if (!Strings.isNullOrEmpty((String)data.getCurrency())) {
            sb.append(data.getCurrency());
        } else {
            sb.append(SDK_MD5);
        }
        sb.append("&expire_time=");
        if (!Strings.isNullOrEmpty((String)data.getExpireTime())) {
            sb.append(data.getExpireTime());
        }
        sb.append("&extra=");
        if (!Strings.isNullOrEmpty((String)data.getExtra())) {
            sb.append(data.getExtra());
        }
        sb.append("&goods_desc=").append(data.getGoodsName()).append("&goods_name=").append(data.getGoodsName());
        sb.append("&goods_url=");
        if (!Strings.isNullOrEmpty((String)data.getGoodsUrl())) {
            sb.append(data.getGoodsUrl());
        }
        sb.append("&input_charset=");
        if (!Strings.isNullOrEmpty((String)data.getInputCharset())) {
            sb.append(data.getInputCharset());
        } else {
            sb.append(SDK_MD5);
        }
        sb.append("&order_create_time=").append(data.getOrderCreateTime());
        sb.append("&order_no=").append(data.getOrderNo());
        sb.append("&page_url=");
        if (!Strings.isNullOrEmpty((String)data.getPageUrl())) {
            sb.append(data.getPageUrl());
        }
        sb.append("&pay_type=").append(data.getBaiduPayType()).append("&return_url=").append(data.getReturnUrl());
        sb.append("&service_code=");
        if (!Strings.isNullOrEmpty((String)data.getServiceCode())) {
            sb.append(data.getServiceCode());
        } else {
            sb.append(SDK_MD5);
        }
        sb.append("&sign_method=");
        if (!Strings.isNullOrEmpty((String)data.getSignMethod())) {
            sb.append(data.getSignMethod());
        } else {
            sb.append(SDK_MD5);
        }
        sb.append("&sp_no=").append(data.getSpNo());
        sb.append("&sp_uno=");
        if (!Strings.isNullOrEmpty((String)data.getSpUno())) {
            sb.append(data.getSpUno());
        }
        sb.append("&total_amount=").append(data.getTotalAmount());
        sb.append("&transport_amount=&unit_amount=&unit_count=&version=2");
        sb.append("&key=").append(data.getSpKey());
        String signMsg = MD5Utils.getMD5Str((String)sb.toString()).toUpperCase();
        logger.info("paramters:{}...md5:{}", (Object)sb.toString(), (Object)signMsg);
        return signMsg;
    }

    public static String generateTime(int dayNum) {
        SimpleDateFormat sdf1 = new SimpleDateFormat("yyyyMMddHHmmss");
        Calendar ca = Calendar.getInstance();
        if (dayNum >= 0) {
            ca.add(5, dayNum);
        }
        return sdf1.format(ca.getTime());
    }

    public static String getFormatTime(String payTime) {
        if (null != payTime && payTime.length() == 14) {
            return payTime.substring(0, 4) + "-" + payTime.substring(4, 6) + "-" + payTime.substring(6, 8) + " " + payTime.substring(8, 10) + ":" + payTime.substring(10, 12) + ":" + payTime.substring(12);
        }
        return payTime;
    }

    public static String generateSDKReqSignMsg(BaiduWalletChannelData data) {
        String signMsg;
        StringBuilder sb = new StringBuilder();
        sb.append("currency=").append(data.getCurrency());
        if (!Strings.isNullOrEmpty((String)data.getExtra())) {
            sb.append("&extra=").append(data.getExtra());
        }
        sb.append("&goods_desc=").append(data.getGoodsName()).append("&goods_name=").append(data.getGoodsName());
        sb.append("&input_charset=").append(data.getInputCharset());
        sb.append("&order_create_time=").append(data.getOrderCreateTime());
        sb.append("&order_no=").append(data.getOrderNo());
        sb.append("&pay_type=").append(data.getBaiduPayType());
        sb.append("&return_url=").append(data.getReturnUrl());
        sb.append("&service_code=").append(data.getServiceCode());
        sb.append("&sign_method=").append(data.getSignMethod());
        sb.append("&sp_no=").append(data.getSpNo());
        if (!Strings.isNullOrEmpty((String)data.getSpUno())) {
            sb.append("&sp_uno=").append(data.getSpUno());
        }
        sb.append("&total_amount=").append(data.getTotalAmount());
        sb.append("&version=").append(data.getVersion());
        sb.append("&key=").append(data.getSpKey());
        if (SDK_MD5.equals(data.getSignMethod())) {
            signMsg = MD5Utils.getMD5Str((String)sb.toString()).toUpperCase();
        } else {
            logger.error("unknow baidu_sdk_sign_method:{}", (Object)data.getSignMethod());
            signMsg = "";
        }
        logger.info("paramters:{}...md5:{}", (Object)sb.toString(), (Object)signMsg);
        return signMsg;
    }

    public static String generateSDKParams(BaiduWalletChannelData data) throws UnsupportedEncodingException {
        StringBuilder sb = new StringBuilder();
        StringBuilder response = new StringBuilder();
        sb.append("currency=1");
        response.append("currency=1");
        if (!Strings.isNullOrEmpty((String)data.getExtra())) {
            sb.append("&extra=").append(data.getExtra());
            response.append("&extra=").append(data.getExtra());
        }
        sb.append("&goods_desc=").append(data.getGoodsName());
        response.append("&goods_desc=").append(URLEncoder.encode(data.getGoodsName(), "gbk"));
        sb.append("&goods_name=").append(data.getGoodsName());
        response.append("&goods_name=").append(URLEncoder.encode(data.getGoodsName(), "gbk"));
        sb.append("&input_charset=1");
        response.append("&input_charset=1");
        sb.append("&order_create_time=").append(data.getOrderCreateTime());
        response.append("&order_create_time=").append(data.getOrderCreateTime());
        sb.append("&order_no=").append(data.getOrderNo());
        response.append("&order_no=").append(data.getOrderNo());
        sb.append("&pay_type=2");
        response.append("&pay_type=2");
        sb.append("&return_url=").append(data.getReturnUrl());
        response.append("&return_url=").append(URLEncoder.encode(data.getReturnUrl(), "gbk"));
        sb.append("&service_code=1");
        response.append("&service_code=1");
        sb.append("&sign_method=1");
        response.append("&sign_method=1");
        sb.append("&sp_no=").append(data.getSpNo());
        response.append("&sp_no=").append(data.getSpNo());
        sb.append("&sp_request_type=").append(data.getSpRequestType());
        response.append("&sp_request_type=").append(data.getSpRequestType());
        if (!Strings.isNullOrEmpty((String)data.getSpUno())) {
            sb.append("&sp_uno=").append(data.getSpUno());
            response.append("&sp_uno=").append(data.getSpUno());
        }
        sb.append("&total_amount=").append(data.getTotalAmount());
        response.append("&total_amount=").append(data.getTotalAmount());
        sb.append("&version=2");
        response.append("&version=2");
        sb.append("&key=").append(data.getSpKey());
        String signMsg = MD5Utils.getMD5Str((String)sb.toString()).toUpperCase();
        logger.info("paramters:{}...md5:{}", (Object)sb.toString(), (Object)signMsg);
        response.append("&sign=").append(signMsg);
        return response.toString();
    }
}

