/*
 * Decompiled with CFR 0.152.
 */
package com.xunlei.channel.gateway.pay.channels.baiduwallet;

import com.google.common.base.Strings;
import com.xunlei.channel.gateway.common.utils.StringUtils;
import com.xunlei.channel.gateway.pay.channels.AbstractChannelInfo;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class BaiduWalletChannelInfo
extends AbstractChannelInfo {
    private static final Logger logger = LoggerFactory.getLogger(BaiduWalletChannelInfo.class);
    public static final String CACHE_GROUP_ID = "gateway_baiduwallet";
    public static final String CACHE_SP_NO = "sp_no";
    public static final String CACHE_KEY = "key";
    public static final String CACHE_FEE_RATE = "fee_rate";
    public static final String CACHE_RETURN_URL = "return_url";
    public static final String CACHE_PAGE_URL = "page_url";
    public static final String CACHE_PAY_TYPE_RELATIONSHIP = "pay_type_relationship";
    public static final String CACHE_IFRAME_URL = "iframe_url";
    public static final String CACHE_DESK_URL = "desk_url";
    public static final String CACHE_ACTIVITY_SP_NO = "activity_sp_no";
    public static final String CACHE_ACTIVITY_KEY = "activity_key";
    public static final String CACHE_ACTIVITY_RETURN_URL = "activity_return_url";
    public static final String CACHE_ACTIVITY_PAGE_URL = "activity_page_url";
    public static final String CACHE_ACTIVITY_IFRAME_URL = "activity_iframe_url";
    public static final String CACHE_ACTIVITY_DESK_URL = "activity_desk_url";
    public static final String CACHE_ACTIVITY_ID = "activity_id";
    public static final String CACHE_ACTIVITY_FEE_RATE = "activity_fee_rate";
    public static final String INPUT_CHARSET_GBK = "gbk";
    public static final String BAIDU_NEW_USER_URL = "new_user_url";
    public static final String CACHE_SDK_REQUEST_TYPE = "sp_request_type";
    private Map<String, Map<String, String>> BANK_MAP = new HashMap<String, Map<String, String>>();

    public String getBaiduPayType(String payType) {
        HashMap<String, String> payTypeMap = new HashMap<String, String>();
        String temp = this.getConfigValue(CACHE_PAY_TYPE_RELATIONSHIP);
        if (!Strings.isNullOrEmpty((String)temp)) {
            String[] pairs;
            for (String p : pairs = temp.split("\\|")) {
                String[] keyValue = p.split(":");
                if (keyValue.length != 2) continue;
                payTypeMap.put(keyValue[0], keyValue[1]);
            }
        }
        if (payTypeMap.containsKey(payType)) {
            return (String)payTypeMap.get(payType);
        }
        logger.info("unfound baiduwallet-paytype of our payType:{}", (Object)payType);
        return "1";
    }

    public String getSpNo(boolean isActivity) {
        return isActivity ? this.getConfigValue(CACHE_ACTIVITY_SP_NO) : this.getConfigValue(CACHE_SP_NO);
    }

    public String getSpKey(String spNo) {
        if (spNo == null) {
            return null;
        }
        String paySpNo = this.getConfigValue(CACHE_SP_NO);
        if (spNo.equals(paySpNo)) {
            return this.getConfigValue(CACHE_KEY);
        }
        String activitySpNo = this.getConfigValue(CACHE_ACTIVITY_SP_NO);
        if (spNo.equals(activitySpNo)) {
            return this.getConfigValue(CACHE_ACTIVITY_KEY);
        }
        logger.error("no key found for spNo:{}", (Object)spNo);
        return null;
    }

    public boolean isActivity(String activity) {
        if (null == activity) {
            return false;
        }
        return activity.equals(this.getConfigValue(CACHE_ACTIVITY_ID));
    }

    public String getPageUrl(boolean isActivity) {
        return isActivity ? this.getConfigValue(CACHE_ACTIVITY_PAGE_URL) : this.getConfigValue(CACHE_PAGE_URL);
    }

    public String getReturnUrl(boolean isActivity) {
        return isActivity ? this.getConfigValue(CACHE_ACTIVITY_RETURN_URL) : this.getConfigValue(CACHE_RETURN_URL);
    }

    public String getBaiduDeskUrl(boolean isActivity) {
        return isActivity ? this.getConfigValue(CACHE_ACTIVITY_DESK_URL) : this.getConfigValue(CACHE_DESK_URL);
    }

    public String getBaiduFrameUrl(boolean activity) {
        return activity ? this.getConfigValue(CACHE_ACTIVITY_IFRAME_URL) : this.getConfigValue(CACHE_IFRAME_URL);
    }

    public double getFeeRate(boolean isActivity) {
        return isActivity ? this.getConfigValueDouble(CACHE_ACTIVITY_FEE_RATE) : this.getConfigValueDouble(CACHE_FEE_RATE);
    }

    public String getBaiduWalletBankNo(String bankNo, String cardType) {
        Map<String, String> cardMap;
        if (StringUtils.isAnyNullOrEmpty((String[])new String[]{bankNo, cardType})) {
            return "";
        }
        if (this.BANK_MAP.isEmpty()) {
            this.initBankMap();
        }
        if (null == (cardMap = this.BANK_MAP.get(cardType))) {
            return "";
        }
        String result = cardMap.get(bankNo);
        return result != null ? result : "";
    }

    private void initBankMap() {
        HashMap<String, String> creditMap = new HashMap<String, String>();
        creditMap.put("ICBC", "3001");
        creditMap.put("CCB", "3002");
        creditMap.put("ABC", "3003");
        creditMap.put("BOCB2C", "3004");
        creditMap.put("PSBC", "3005");
        creditMap.put("COMM", "3006");
        creditMap.put("CITIC", "3007");
        creditMap.put("CEBBANK", "3008");
        creditMap.put("HXBANK", "3009");
        creditMap.put("CMBC", "3010");
        creditMap.put("CMB", "3011");
        creditMap.put("SHBANK", "3012");
        creditMap.put("BJBANK", "3013");
        creditMap.put("HKBEA", "3014");
        creditMap.put("CIB", "3015");
        creditMap.put("NBBANK", "3016");
        creditMap.put("SPDB", "3017");
        creditMap.put("GDB", "3018");
        creditMap.put("SPABANK", "3019");
        creditMap.put("BSB", "3020");
        creditMap.put("BOCD", "3022");
        creditMap.put("CDRCB", "3023");
        creditMap.put("CQRCB", "3024");
        creditMap.put("CQBANK", "3025");
        creditMap.put("DLB", "3026");
        creditMap.put("DYCCB", "3027");
        creditMap.put("ORBANK", "3028");
        creditMap.put("FJNX", "3029");
        creditMap.put("GYCB", "3030");
        creditMap.put("GCB", "3031");
        creditMap.put("GRCB", "3032");
        creditMap.put("HRBANK", "3033");
        creditMap.put("HNRCC", "3034");
        creditMap.put("HSBANK", "3035");
        creditMap.put("BHB", "3036");
        creditMap.put("HZCB", "3037");
        creditMap.put("BOJZ", "3038");
        creditMap.put("CSRCB", "3039");
        creditMap.put("JSBANK", "3040");
        creditMap.put("JRCB", "3041");
        creditMap.put("JJBANK", "3042");
        creditMap.put("LZYH", "3043");
        creditMap.put("DAQINGB", "3044");
        creditMap.put("NCB", "3045");
        creditMap.put("NJCB", "3046");
        creditMap.put("BOQH", "3047");
        creditMap.put("QLBANK", "3048");
        creditMap.put("SHRCB", "3049");
        creditMap.put("SRBANK", "3050");
        creditMap.put("SDRCB", "3051");
        creditMap.put("WHCCB", "3053");
        creditMap.put("BANKWF", "3054");
        creditMap.put("WZCB", "3055");
        creditMap.put("URMQCCB", "3056");
        creditMap.put("WRCB", "3057");
        creditMap.put("YCCB", "3058");
        creditMap.put("NBYZ", "3059");
        creditMap.put("WJRCB", "3060");
        creditMap.put("YDRCB", "3061");
        creditMap.put("CZCB", "3063");
        creditMap.put("ZJTLCB", "3064");
        creditMap.put("MTBANK", "3065");
        this.BANK_MAP.put("1", creditMap);
        HashMap<String, String> saveMap = new HashMap<String, String>();
        saveMap.put("ABC", "4001");
        saveMap.put("CCB", "4003");
        saveMap.put("CMB", "4004");
        saveMap.put("CIB", "4007");
        saveMap.put("BOCB2C", "4009");
        this.BANK_MAP.put("2", saveMap);
    }

    @Override
    public String getGroupId() {
        return CACHE_GROUP_ID;
    }

    public String getBaiduNewUserURL() {
        return this.getConfigValue(BAIDU_NEW_USER_URL);
    }

    public String getSpRequestType() {
        return this.getConfigValue(CACHE_SDK_REQUEST_TYPE);
    }
}

