/*
 * Decompiled with CFR 0.152.
 */
package com.xunlei.channel.gateway.pay.channels.audiopay;

import com.google.common.base.Strings;
import com.xunlei.channel.gateway.common.utils.StringUtils;
import com.xunlei.channel.gateway.pay.channels.AbstractChannelInfo;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class AudioPayChannelInfo
extends AbstractChannelInfo {
    private static final Logger logger = LoggerFactory.getLogger(AudioPayChannelInfo.class);
    public static final String CACHE_GROUP_ID = "gateway_audiopay";
    public static final String CACHE_GK_ID = "gk_id";
    public static final String CACHE_MCH_ID = "mch_id";
    public static final String CACHE_IV = "iv";
    public static final String CACHE_EFT_URL_PAGE = "eft_url_page";
    public static final String CACHE_EFT_URL_IFRAME = "eft_url_iframe";
    public static final String CACHE_EK_URL = "ek_url";
    public static final String CACHE_DK_URL = "dk_url";
    public static final String CACHE_WHITE_IP = "white_ip";
    public static final String CACHE_PRODUCT = "product";
    public static final String CACHE_PAY_METHOD = "pay_method";
    public static final String CACHE_PAGE_TYPE = "page_type";
    public static final String CACHE_FEE_RATE = "fee_rate";
    public static final String PRODUCT_CODE = "product_code";
    public static final String PAY_METHOD = "pay_method";
    public static final String PAGE_TYPE = "page_type";
    public static final String PHONE = "phone";
    public static final String PAGE_TYPE_PAGE = "1";
    public static final String PAGE_TYPE_IFRAME = "2";

    public HashMap<String, Integer> getProductCodeAndAmtMap() {
        String products = this.getConfigValue(CACHE_PRODUCT);
        HashMap<String, Integer> productCodeAndAmtMap = new HashMap<String, Integer>();
        if (!Strings.isNullOrEmpty((String)products)) {
            for (String product : products.split(",")) {
                String[] codeAndAmt = product.split(":");
                if (codeAndAmt.length != 2 || StringUtils.isAnyNullOrEmpty((String[])new String[]{codeAndAmt[0], codeAndAmt[1]})) continue;
                try {
                    int amt = Integer.valueOf(codeAndAmt[1]);
                    productCodeAndAmtMap.put(codeAndAmt[0], amt);
                }
                catch (Exception e) {
                    logger.error("", (Throwable)e);
                }
            }
        }
        logger.debug("productCodeAndAmtMap:{}", productCodeAndAmtMap);
        return productCodeAndAmtMap;
    }

    public List<String> getPayMethodList() {
        ArrayList<String> payMethodList = new ArrayList<String>();
        String payMethod = this.getConfigValue("pay_method");
        if (!Strings.isNullOrEmpty((String)payMethod)) {
            for (String method : payMethod.split(",")) {
                payMethodList.add(method);
            }
        }
        logger.debug("payMethodList:{}", (Object)Arrays.toString(payMethodList.toArray()));
        return payMethodList;
    }

    public List<String> getPageTypeList() {
        ArrayList<String> pageTypeList = new ArrayList<String>();
        String pageType = this.getConfigValue("page_type");
        if (!Strings.isNullOrEmpty((String)pageType)) {
            for (String type : pageType.split(",")) {
                pageTypeList.add(type);
            }
        }
        logger.debug("pageTypeList:{}", (Object)Arrays.toString(pageTypeList.toArray()));
        return pageTypeList;
    }

    @Override
    public String getGroupId() {
        return CACHE_GROUP_ID;
    }
}

