/*
 * Decompiled with CFR 0.152.
 */
package com.xunlei.channel.gateway.pay.channels;

import com.xunlei.channel.gateway.pay.annotation.PayType;
import com.xunlei.channel.gateway.pay.channels.ChannelHandler;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.stereotype.Component;
import org.springframework.web.context.support.WebApplicationObjectSupport;

@Component
public class ChannelHandlerMapping
extends WebApplicationObjectSupport
implements InitializingBean {
    private static final Logger logger = LoggerFactory.getLogger(ChannelHandlerMapping.class);
    private static Map<String, ChannelHandler<?>> CHANNEL_HANDLER_MAP;

    public void afterPropertiesSet() throws Exception {
        this.initChannelHandlerMapping();
    }

    private void initChannelHandlerMapping() {
        logger.info("ChannelHandlerMapping::initChannelHandlerMapping...");
        HashMap<String, ChannelHandler> tempMap = new HashMap<String, ChannelHandler>();
        Map map = this.getApplicationContext().getBeansWithAnnotation(PayType.class);
        for (Object obj : map.values()) {
            String payType = obj.getClass().getAnnotation(PayType.class).value();
            logger.info("key:{},value:{}", (Object)payType, obj);
            if (tempMap.containsKey(payType)) {
                logger.error("error,duplicated paytype:{} in Class:{} and {}", new Object[]{payType, obj, tempMap.get(payType)});
                return;
            }
            tempMap.put(payType, (ChannelHandler)obj);
        }
        CHANNEL_HANDLER_MAP = Collections.unmodifiableMap(tempMap);
    }

    public ChannelHandler<?> getChannelHanderByPayType(String payType) {
        if (null != CHANNEL_HANDLER_MAP) {
            return CHANNEL_HANDLER_MAP.get(payType);
        }
        logger.error("Error,Something wrong with ChannelHandlerMapping");
        return null;
    }
}

