/*
 * Decompiled with CFR 0.152.
 */
package com.xunlei.channel.gateway.pay.channels.unicommobilepay;

import com.xunlei.channel.gateway.pay.channels.AbstractChannelInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class UnicomMobilePayChannelInfo
extends AbstractChannelInfo {
    private static final Logger logger = LoggerFactory.getLogger(AbstractChannelInfo.class);
    public static final String CACHE_GROUP_ID = "gateway_unicommobilepay";
    public static final String PAY_FEE = "pay_fee";
    public static final String RATE_OF_CHARGE = "rate_of_charge";
    public static final String PID = "pid";
    public static final String KEY = "key";
    public static final String AUTHORITY_KEY = "authority_key";
    public static final String OK_ORDER_MOBILE_MONTHLY_LIMIT = "ok_order_mobile_monthly_limit";
    public static final String OK_ORDER_AMOUNT_ACCOUNT_MONTHLY_LIMIT_FEN = "ok_order_amount_account_monthly_limit_fen";
    public static final String ORDER_ACCOUNT_DAILY_LIMIT = "order_account_daily_limit";
    public static final String OK_ORDER_ACCOUNT_MONTHLY_LIMIT = "ok_order_account_monthly_limit";
    public static final String UNICOM_MOBILE_NUMBER_SECTIONS = "unicom_mobile_number_sections";
    public static final String MOBILE_BLACK_LIST = "mobile_black_list";
    public static final String IP_BLACK_LIST = "ip_black_list";
    public static final String IP_WHITE_LIST = "ip_white_list";
    public static final String FORBIDDEN_AREA_LIST = "forbidden_area_list";
    public static final String USER_BLACK_LIST = "user_black_list";
    public static final String SVCID = "svcid";
    public static final String URL = "url";
    public static final String QUERY_URL = "query_url";
    public static final String WOW_QUERY_URL = "wow_query_url";
    public static String FEE_URL = "fee_url";
    public static String CALLBACK_URL = "callback_url";
    public static final String BIZNO_REMOTE = "bizno_remote";
    public static final String BIZNO_LOCAL = "bizno_local";

    @Override
    protected String getGroupId() {
        return CACHE_GROUP_ID;
    }

    public Integer getOrderAccountDailyLimit() {
        return this.getIntegerConfigValue(ORDER_ACCOUNT_DAILY_LIMIT);
    }

    public Integer getOkOrderAccountMonthlyLimit() {
        return this.getIntegerConfigValue(OK_ORDER_ACCOUNT_MONTHLY_LIMIT);
    }

    public Integer getOkOrderMobileMonthlyLimit() {
        return this.getIntegerConfigValue(OK_ORDER_MOBILE_MONTHLY_LIMIT);
    }

    public Integer getOkOrderAmountAccountMonthlyLimitFen() {
        return this.getIntegerConfigValue(OK_ORDER_AMOUNT_ACCOUNT_MONTHLY_LIMIT_FEN);
    }

    public Integer getPayFee() {
        return this.getIntegerConfigValue(PAY_FEE);
    }

    private Integer getIntegerConfigValue(String key) {
        String value = this.getConfigValue(key);
        if (value == null) {
            logger.warn("return null when get config from key: {}", (Object)key);
            return null;
        }
        try {
            return Integer.parseInt(value);
        }
        catch (Exception e) {
            logger.error("getIntegerConfigValue catch exception when parse integer, message: " + e.getMessage(), (Throwable)e);
            return null;
        }
    }
}

