/*
 * Decompiled with CFR 0.152.
 */
package com.xunlei.channel.gateway.pay.channels.mycardmemberpay;

import com.xunlei.channel.gateway.pay.channels.mycardmemberpay.MemberServiceAuthRequest;
import com.xunlei.channel.gateway.pay.channels.mycardmemberpay.MemberServiceAuthResponse;
import com.xunlei.xlcommons.util.http.HttpClientUtil;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.dom4j.Document;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MyCardMemberPayUtil {
    private static final Logger logger = LoggerFactory.getLogger(MyCardMemberPayUtil.class);

    public static MemberServiceAuthResponse getMemberServiceAuthResult(String authServiceUrl, MemberServiceAuthRequest auth) throws Exception {
        String authUrl = MyCardMemberPayUtil.getMemberServiceAuthReqUrl(authServiceUrl, auth);
        logger.info("authUrl:{}", (Object)authUrl);
        String resp = HttpClientUtil.doGet((String)authUrl, new HashMap(), null);
        logger.info("auth with resp:{}", (Object)resp);
        Document document = DocumentHelper.parseText((String)resp);
        Element root = document.getRootElement();
        String returnMsgNo = root.elementText("ReturnMsgNo");
        String returnTradeSeq = root.elementText("ReturnTradeSeq");
        String returnAuthCode = root.elementText("ReturnAuthCode");
        MemberServiceAuthResponse result = new MemberServiceAuthResponse();
        result.setReturnAuthCode(returnAuthCode);
        result.setReturnMsgNo(returnMsgNo);
        result.setReturnTradeSeq(returnTradeSeq);
        return result;
    }

    private static String getMemberServiceAuthReqUrl(String authServiceUrl, MemberServiceAuthRequest authRequest) {
        StringBuilder authUrl = new StringBuilder(authServiceUrl);
        authUrl.append("?");
        Map<String, String> authMap = MyCardMemberPayUtil.formatObject2Map(authRequest);
        Iterator<Map.Entry<String, String>> iterator = authMap.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<String, String> entry = iterator.next();
            String key = entry.getKey();
            String val = entry.getValue();
            if (iterator.hasNext()) {
                authUrl.append(key).append("=").append(val).append("&");
                continue;
            }
            authUrl.append(key).append("=").append(val);
        }
        String url = authUrl.toString();
        logger.debug("getMemberServiceAuthReqUrl :{}", (Object)url);
        return url;
    }

    private static Map<String, String> formatObject2Map(Object obj) {
        Method[] methods;
        HashMap<String, String> map = new HashMap<String, String>();
        Class<?> clazz = obj.getClass();
        for (Method one : methods = clazz.getDeclaredMethods()) {
            if (!one.getName().startsWith("get")) continue;
            try {
                map.put(one.getName().substring(3), one.invoke(obj, new Object[0]).toString());
            }
            catch (IllegalArgumentException e) {
                logger.error("", (Throwable)e);
            }
            catch (IllegalAccessException e) {
                logger.error("", (Throwable)e);
            }
            catch (InvocationTargetException e) {
                logger.error("method : {} InvocationTargetException : ", (Object)one.getName(), (Object)e);
            }
        }
        return map;
    }

    public static String getMemberLoginServiceUrl(String memberLoginServiceUrl, String authcode) {
        String url = memberLoginServiceUrl + "?AuthCode=" + authcode;
        return url;
    }

    public static String getMemberCostListRenderUrl(String memberCostListRenderUrl, String authcode, String oneTimePassword) {
        String url = memberCostListRenderUrl + "?AuthCode=" + authcode + "&OneTimePassword=" + oneTimePassword;
        return url;
    }
}

