/*
 * Decompiled with CFR 0.152.
 */
package com.xunlei.channel.gateway.pay.channels.alipay.wapdirect;

import com.xunlei.channel.db.pojo.AbstractOrder;
import com.xunlei.channel.db.pojo.PayOrder;
import com.xunlei.channel.db.pojo.PayOrderOk;
import com.xunlei.channel.gateway.common.pojo.PayResult;
import com.xunlei.channel.gateway.pay.channels.AbstractChannelService;
import com.xunlei.channel.gateway.pay.channels.alipay.AlipaySignUtils;
import com.xunlei.channel.gateway.pay.channels.alipay.wapdirect.AlipayWapChannelData;
import com.xunlei.channel.gateway.pay.channels.alipay.wapdirect.AlipayWapChannelInfo;
import java.util.HashSet;
import java.util.Map;
import java.util.TreeMap;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class AlipayWapService
extends AbstractChannelService {
    private static final String SUCCESS = "SUCCESS";
    private static final String FAILED = "FAILED";
    private static final Logger logger = LoggerFactory.getLogger(AlipayWapService.class);
    @Autowired
    private AlipayWapChannelInfo alipayWapChannelInfo;

    public String returnNotify(HttpServletRequest request) {
        logger.info("returnNofity...params:{}", (Object)this.logRequestParam(request.getParameterMap()));
        String xunleiPayId = request.getParameter("out_trade_no");
        logger.info("receive alipay-wap-notify....xunleiPayId:{}", (Object)xunleiPayId);
        if (!this.checkReturnSign(request.getParameterMap(), this.alipayWapChannelInfo.getPartnerKey(), "utf-8")) {
            logger.warn("signMsg is invalid...xunleiPayId:{}", (Object)xunleiPayId);
            return "invalid sign";
        }
        AlipayWapChannelData alipayWapChannelData = this.parseNotifyData(request);
        if (!alipayWapChannelData.isPaiedSuccess()) {
            logger.info("tradeStatus:{},not success,do nothing and return", (Object)alipayWapChannelData.getTradeStatus());
            return SUCCESS;
        }
        PayOrder payOrder = this.getPayOrderByXunleiPayId(xunleiPayId);
        if (null == payOrder) {
            logger.error("cannot find payOrder with xunleiPayId:{},return success", (Object)xunleiPayId);
            return SUCCESS;
        }
        if (alipayWapChannelData.getTotalFee() != payOrder.getOrderAmt()) {
            logger.error("orderAmt mismatch...payOrder.orderAmt:{},alipaywap.totalFee:{}", (Object)payOrder.getOrderAmt(), (Object)alipayWapChannelData.getTotalFee());
            return FAILED;
        }
        alipayWapChannelData.setFareAmt(this.getOrderFeeAmt(payOrder.getOrderAmt()));
        if ("S".equals(payOrder.getStatus())) {
            logger.info("payOrder:{} status was success,do nothing and return");
            return SUCCESS;
        }
        PayOrderOk payOrderOk = this.processPaySuccess(payOrder, alipayWapChannelData);
        return null != payOrderOk ? SUCCESS : FAILED;
    }

    private int getOrderFeeAmt(int orderAmt) {
        Double rate;
        String feeRate = this.alipayWapChannelInfo.getFeeRate();
        try {
            rate = Double.parseDouble(feeRate);
        }
        catch (NumberFormatException e) {
            logger.error(e.getMessage(), (Throwable)e);
            return 0;
        }
        return (int)Math.round((double)orderAmt * rate);
    }

    public static void main(String[] args) {
    }

    private String logRequestParam(Map<String, String[]> parameterMap) {
        StringBuilder sb = new StringBuilder();
        for (Map.Entry<String, String[]> en : parameterMap.entrySet()) {
            sb.append(en.getKey()).append("=").append(en.getValue()[0]).append("&");
        }
        return sb.toString();
    }

    private boolean checkReturnSign(Map<String, String[]> paramMap, String partnerKey, String charset) {
        if (!paramMap.containsKey("sign")) {
            logger.error("unfound param sign");
            return false;
        }
        if (!paramMap.containsKey("sign_type")) {
            logger.error("unfound param sign_type");
            return false;
        }
        String sign = paramMap.get("sign")[0];
        String signType = paramMap.get("sign_type")[0];
        TreeMap<String, String> treeMap = new TreeMap<String, String>();
        HashSet<String> excludeSet = new HashSet<String>();
        excludeSet.add("sign");
        excludeSet.add("sign_type");
        for (Map.Entry<String, String[]> en : paramMap.entrySet()) {
            if (excludeSet.contains(en.getKey())) continue;
            treeMap.put(en.getKey(), en.getValue()[0]);
        }
        if ("MD5".equals(signType)) {
            return AlipaySignUtils.checkMD5Sign(treeMap, "&", sign, partnerKey, charset);
        }
        logger.error("unknown sign_type:{}", (Object)signType);
        return false;
    }

    private AlipayWapChannelData parseNotifyData(HttpServletRequest request) {
        AlipayWapChannelData data = new AlipayWapChannelData();
        data.setBuyerEmail(request.getParameter("buyer_email"));
        data.setNotifyId(request.getParameter("notify_id"));
        data.setOutTradeNo(request.getParameter("out_trade_no"));
        data.setPaymentType(request.getParameter("payment_type"));
        data.setSign(request.getParameter("sign"));
        data.setSignType(request.getParameter("sign_type"));
        data.setSubject(request.getParameter("subject"));
        String totalFee = request.getParameter("total_fee");
        data.setTotalFee((int)(Double.parseDouble(totalFee) * 100.0));
        data.setTradeNo(request.getParameter("trade_no"));
        data.setTradeStatus(request.getParameter("trade_status"));
        return data;
    }

    public String pageNotify(HttpServletRequest request) {
        String xunleiPayId = request.getParameter("out_trade_no");
        PayOrder payOrder = this.getPayOrderByXunleiPayId(xunleiPayId);
        if (null == payOrder) {
            logger.error("cannot find payOrder with xunleiPayId:{}", (Object)xunleiPayId);
            return "";
        }
        if (!this.checkReturnSign(request.getParameterMap(), this.alipayWapChannelInfo.getPartnerKey(), "utf-8")) {
            logger.error("signMsg is invalid...xunleiPayId:{}", (Object)xunleiPayId);
            return this.generateRedirectUrl((AbstractOrder)payOrder, PayResult.FAILED.getValue(), "99", 0);
        }
        AlipayWapChannelData alipayWapChannelData = this.parseNotifyData(request);
        if (!alipayWapChannelData.isPaiedSuccess()) {
            logger.warn("tradeStatus:{},not success,do nothing and return", (Object)alipayWapChannelData.getTradeStatus());
            return this.generateRedirectUrl((AbstractOrder)payOrder, PayResult.FAILED.getValue(), "99", 0);
        }
        if (alipayWapChannelData.getTotalFee() != payOrder.getOrderAmt()) {
            logger.error("orderAmt mismatch...payOrder.orderAmt:{},alipaywap.totalFee:{}", (Object)payOrder.getOrderAmt(), (Object)alipayWapChannelData.getTotalFee());
            return this.generateRedirectUrl((AbstractOrder)payOrder, PayResult.FAILED.getValue(), "99", 0);
        }
        int feeAmt = this.getOrderFeeAmt(payOrder.getOrderAmt());
        return this.generateRedirectUrl((AbstractOrder)payOrder, PayResult.SUCCESS.getValue(), "", feeAmt);
    }
}

