/*
 * Decompiled with CFR 0.152.
 */
package com.xunlei.channel.gateway.pay.channels.alipay;

import com.xunlei.channel.gateway.common.utils.MD5Utils;
import java.util.Map;
import java.util.TreeMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AlipaySignUtils {
    private static final Logger logger = LoggerFactory.getLogger(AlipaySignUtils.class);

    public static String doMD5Sign(TreeMap<String, String> params, String secretKey, String paramConnector, String inputCharset) {
        if (null == params || paramConnector == null || secretKey == null) {
            logger.error("some of params is null,return null");
            return null;
        }
        String original = AlipaySignUtils.generateOriginalStrs(params, secretKey, paramConnector);
        String sign = MD5Utils.getMD5Str((String)original, (String)inputCharset);
        logger.info("doMD5Sign...original:{},md5:{}", (Object)original, (Object)sign);
        return sign;
    }

    private static String generateOriginalStrs(TreeMap<String, String> params, String secretKey, String paramConnector) {
        StringBuilder sb = new StringBuilder();
        int index = 0;
        for (Map.Entry<String, String> en : params.entrySet()) {
            if (index++ > 0) {
                sb.append(paramConnector);
            }
            sb.append(en.getKey()).append("=").append(en.getValue());
        }
        sb.append(secretKey);
        return sb.toString();
    }

    public static boolean checkMD5Sign(TreeMap<String, String> treeMap, String paramConnector, String sign, String secretKey, String charset) {
        if (null == treeMap || null == paramConnector || null == sign || null == secretKey) {
            logger.warn("some of params is null,return false");
            return false;
        }
        String ourSign = AlipaySignUtils.doMD5Sign(treeMap, secretKey, paramConnector, charset);
        if (!ourSign.equalsIgnoreCase(sign)) {
            logger.warn("MD5 Sign mismatch...out_sign:{},our_sign:{}", (Object)sign, (Object)ourSign);
            return false;
        }
        return true;
    }
}

