/*
 * Decompiled with CFR 0.152.
 */
package com.xunlei.channel.gateway.pay.common;

import com.xunlei.channel.db.dao.ConfigInfoDAO;
import com.xunlei.channel.db.pojo.ConfigInfo;
import com.xunlei.channel.gateway.common.utils.StringUtils;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class ChannelConfigInfoUtils {
    private static final Logger logger = LoggerFactory.getLogger(ChannelConfigInfoUtils.class);
    @Autowired
    ConfigInfoDAO configInfoDAO;

    public String getConfigValue(String groupId, String propertyKey) {
        if (StringUtils.isAnyNullOrEmpty((String[])new String[]{groupId, propertyKey})) {
            logger.info("groupId:{} or propertyKey:{} is null,return null", (Object)groupId, (Object)propertyKey);
            return null;
        }
        String value = this.getConfigInfoFromDB(groupId, propertyKey);
        logger.debug("get groupId:{},propertyKey:{} from db with resp value:{}", new Object[]{groupId, propertyKey, value});
        return value;
    }

    private String getConfigInfoFromDB(String groupId, String propertyKey) {
        ConfigInfo configInfo = new ConfigInfo();
        configInfo.setGroupId(groupId);
        configInfo.setInUse("Y");
        configInfo.setPropertyKey(propertyKey);
        List list = this.configInfoDAO.getConfigInfo(configInfo);
        if (list.size() > 0) {
            return ((ConfigInfo)list.get(0)).getPropertyValue();
        }
        return null;
    }
}

