/*
 * Decompiled with CFR 0.152.
 */
package com.xunlei.channel.gateway.pay.channels.shengpay;

import com.xunlei.channel.gateway.pay.channels.AbstractChannelInfo;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class ShengpayChannelInfo
extends AbstractChannelInfo {
    private static final Logger logger = LoggerFactory.getLogger(ShengpayChannelInfo.class);
    public static final String CACHE_GROUP_ID = "gateway_shengpay";
    private static String CACHE_CHARSET = "charset";
    private static String CACHE_NOTIFY_URL = "notify_url";
    private static String CACHE_PAGE_URL = "page_url";
    private static String CACHE_BIZ_KEY = "biz_key";
    private static String CACHE_PAY_URL = "pay_url";
    private static String CACHE_PAY_VERSION = "pay_version";
    private static String CACHE_PAY_VNAME = "pay_vname";
    private static String CACHE_SENDER_NO = "sender_no";
    private static String CACHE_SIGN_TYPE = "sign_type";
    private static String CACHE_DEFAULT_SFT_PAY_TYPE = "defalut_sft_pay_type";
    private static Map<String, String> PAYTYPE_MAP = new HashMap<String, String>();
    private static Map<String, Double> FARE_MAP = new HashMap<String, Double>();

    @Override
    protected String getGroupId() {
        return CACHE_GROUP_ID;
    }

    public String getTranType(String payType) {
        if (PAYTYPE_MAP.containsKey(payType)) {
            return PAYTYPE_MAP.get(payType);
        }
        logger.info("unknown xunlei paytype:{},return DEFAULT_SFT_PAY_TYPE", (Object)payType);
        return this.getConfigValue(CACHE_DEFAULT_SFT_PAY_TYPE);
    }

    public String getBizKey() {
        return this.getConfigValue(CACHE_BIZ_KEY);
    }

    public String getPayUrl() {
        return this.getConfigValue(CACHE_PAY_URL);
    }

    public String getVname() {
        return this.getConfigValue(CACHE_PAY_VNAME);
    }

    public String getVersion() {
        return this.getConfigValue(CACHE_PAY_VERSION);
    }

    public String getCharset() {
        return this.getConfigValue(CACHE_CHARSET);
    }

    public String getSenderNo() {
        return this.getConfigValue(CACHE_SENDER_NO);
    }

    public String getPageUrl() {
        return this.getConfigValue(CACHE_PAGE_URL);
    }

    public String getNotifyUrl() {
        return this.getConfigValue(CACHE_NOTIFY_URL);
    }

    public String getSignType() {
        return this.getConfigValue(CACHE_SIGN_TYPE);
    }

    public static double gateFare(String shengpayType) {
        if (null == shengpayType) {
            return 0.0;
        }
        if (FARE_MAP.containsKey(shengpayType)) {
            return FARE_MAP.get(shengpayType);
        }
        logger.error("no fare fee found for shengpayType:{}", (Object)shengpayType);
        return 0.0;
    }

    static {
        PAYTYPE_MAP.put("E1", "PT001");
        FARE_MAP.put("PT001", 0.003);
        FARE_MAP.put("PT002", 0.005);
        FARE_MAP.put("PT003", 0.06);
    }
}

