/*
 * Decompiled with CFR 0.152.
 */
package com.xunlei.channel.gateway.pay.channels.qishun;

import com.xunlei.channel.gateway.common.utils.MD5Utils;
import com.xunlei.channel.gateway.pay.channels.qishun.QishunChannelData;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QishunChannelUtils {
    private static final Logger logger = LoggerFactory.getLogger(QishunChannelUtils.class);
    private static final Pattern digit = Pattern.compile("^\\d+$");

    public static boolean isFixLenDigit(String str, int len) {
        if (QishunChannelUtils.isEmpty(str)) {
            return false;
        }
        if (str.length() != len) {
            return false;
        }
        Matcher m = digit.matcher(str);
        return m.find();
    }

    public static boolean isEmpty(String str) {
        return str == null || str.length() == 0;
    }

    public static String formatQishunRmb(int amount) {
        String rmb = "";
        rmb = amount < 10 ? rmb + "0" + amount : rmb + amount;
        return rmb;
    }

    public static String genQishunApplyUrl(QishunChannelData data, String key, String applyurl) {
        StringBuilder url = new StringBuilder(applyurl);
        StringBuilder parameters = new StringBuilder("rmb=").append(data.getRmb()).append("&pro_no=").append(data.getProNo()).append("&user=").append(data.getUser()).append("&area=").append(data.getArea()).append("&tel=").append(data.getTel()).append("&merchant_no=").append(data.getMerchantNo()).append("&orderid=").append(data.getOrderId()).append("&productid=").append(data.getProductId()).append("&confirm=").append(data.getConfirm()).append("&uip=").append(data.getUip());
        String validate = MD5Utils.getMD5Str((String)(parameters.toString() + key));
        url.append("?").append(parameters.toString()).append("&validate=").append(validate).append("&channelid=").append(data.getChannelId());
        if (StringUtils.isNotEmpty((String)data.getKkt())) {
            url.append("&kkt=").append(data.getKkt());
        }
        logger.info("the post url is {}", (Object)url.toString());
        return url.toString();
    }
}

