/*
 * Decompiled with CFR 0.152.
 */
package com.xunlei.channel.gateway.pay.channels.mycardmemberpay;

import com.google.common.base.Strings;
import com.xunlei.channel.db.dao.PayOrderDAO;
import com.xunlei.channel.gateway.common.constants.InterfaceReqResult;
import com.xunlei.channel.gateway.common.result.RedirectGetResult;
import com.xunlei.channel.gateway.common.utils.JsonUtils;
import com.xunlei.channel.gateway.pay.annotation.PayType;
import com.xunlei.channel.gateway.pay.channels.AbstractChannelHandler;
import com.xunlei.channel.gateway.pay.channels.mycardmemberpay.MemberReturnMsgsParser;
import com.xunlei.channel.gateway.pay.channels.mycardmemberpay.MemberServiceAuthRequest;
import com.xunlei.channel.gateway.pay.channels.mycardmemberpay.MemberServiceAuthResponse;
import com.xunlei.channel.gateway.pay.channels.mycardmemberpay.MyCardMemberPayChannelInfo;
import com.xunlei.channel.gateway.pay.channels.mycardmemberpay.MyCardMemberPayUtil;
import com.xunlei.channel.gateway.pay.pojo.UnitedPayRequest;
import com.xunlei.xlcommons.util.Arith.Arith;
import java.util.HashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
@PayType(value="Q2", desc="mycard\u7ebf\u4e0a\u6263\u70b9\u63a5\u53e3|\u53f0\u6e7e\u667a\u51a0")
public class MyCardMemberPayChannelHandler
extends AbstractChannelHandler<RedirectGetResult> {
    private static final Logger logger = LoggerFactory.getLogger(MyCardMemberPayChannelHandler.class);
    @Autowired
    MyCardMemberPayChannelInfo myCardMemberPayChannelInfo;
    @Autowired
    PayOrderDAO payOrderDAO;

    @Override
    public RedirectGetResult generateChannelResult(UnitedPayRequest unitedPayRequest) {
        String orderId = unitedPayRequest.getXunleiPayId();
        int pointPayment = new Double(Arith.div((double)unitedPayRequest.getOrderAmt(), (double)100.0)).intValue();
        MemberServiceAuthRequest authVo = new MemberServiceAuthRequest();
        authVo.setFactorySeq(unitedPayRequest.getXunleiPayId());
        authVo.setPointPayment(pointPayment);
        authVo.setFactoryId(this.myCardMemberPayChannelInfo.getCacheFactoryId());
        authVo.setFactoryServiceId(this.myCardMemberPayChannelInfo.getCacheFactoryServiceId());
        authVo.setBonusPayment(0);
        authVo.setFactoryReturnUrl(this.myCardMemberPayChannelInfo.getCacheLoginNoticeUrl());
        MemberServiceAuthResponse authResult = null;
        try {
            authResult = MyCardMemberPayUtil.getMemberServiceAuthResult(this.myCardMemberPayChannelInfo.getCacheAuthServiceUrl(), authVo);
        }
        catch (Exception e) {
            logger.error("", (Throwable)e);
        }
        if (authResult == null) {
            logger.error("orderId:{} with empty authResult", (Object)orderId);
            return new RedirectGetResult(InterfaceReqResult.FAIL, "99", "\u7cfb\u7edf\u5f02\u5e38\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5\uff01", "pay_fail_page", null);
        }
        logger.info("authResult:{}", (Object)authResult.toString());
        String returnMsgNo = authResult.getReturnMsgNo();
        if (!returnMsgNo.equals("1")) {
            String returnMsg = MemberReturnMsgsParser.getServiceauthMsg(returnMsgNo);
            String errMsg = "\u7cfb\u7edf\u5f02\u5e38\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5\uff01";
            if (!Strings.isNullOrEmpty((String)returnMsg)) {
                errMsg = returnMsg;
            }
            logger.error("invalid returnMsgNo:{} for orderId:{},order failed", (Object)returnMsgNo, (Object)orderId);
            return new RedirectGetResult(InterfaceReqResult.FAIL, "99", errMsg, "pay_fail_page", null);
        }
        String authcode = authResult.getReturnAuthCode();
        HashMap<String, String> extraMap = new HashMap<String, String>();
        extraMap.put("auth_code", authcode);
        String extraJson = JsonUtils.toJson(extraMap);
        try {
            this.payOrderDAO.updatePayOrderExtraJsonAndChannelId(orderId, extraJson, authResult.getReturnTradeSeq());
        }
        catch (Exception e) {
            logger.error("", (Throwable)e);
            return new RedirectGetResult(InterfaceReqResult.FAIL, "99", "\u7cfb\u7edf\u5f02\u5e38\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5\uff01", "pay_fail_page", null);
        }
        String memberLoginUrl = MyCardMemberPayUtil.getMemberLoginServiceUrl(this.myCardMemberPayChannelInfo.getCacheLoginServiceUrl(), authcode);
        logger.info("orderId:{} with pay_url:{},", (Object)orderId, (Object)memberLoginUrl);
        return new RedirectGetResult(InterfaceReqResult.SUCCESS, null, null, null, memberLoginUrl);
    }

    @Override
    public RedirectGetResult validateSpecialParams(UnitedPayRequest unitedPayRequest) {
        int orderAmt = unitedPayRequest.getOrderAmt();
        if (orderAmt / 100 * 100 != orderAmt) {
            logger.error("orderId:{} order with invalid orderAmt:{}", (Object)unitedPayRequest.getXunleiPayId(), (Object)orderAmt);
            return new RedirectGetResult(InterfaceReqResult.FAIL, "13", "\u6682\u4e0d\u652f\u6301\u8be5\u652f\u4ed8\u91d1\u989d\uff01", "pay_fail_page", null);
        }
        return null;
    }
}

