/*
 * Decompiled with CFR 0.152.
 */
package com.xunlei.channel.gateway.pay.schedule;

import com.xunlei.channel.db.dao.CustomOrderDAO;
import com.xunlei.channel.db.dao.PayOrderOkDAO;
import com.xunlei.channel.gateway.common.pay.ChannelData;
import com.xunlei.channel.gateway.common.utils.XunleiPayIdUtils;
import com.xunlei.channel.gateway.notice.service.PayNoticeService;
import com.xunlei.channel.gateway.order.service.OrderService;
import com.xunlei.channel.gateway.pay.channels.RepairChannelService;
import com.xunlei.channel.thirdparty.vo.QueryResponse;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.dao.DataAccessException;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Component;

@Component
public class PayScheduler {
    private static final Logger logger = LoggerFactory.getLogger(PayScheduler.class);
    private boolean onlyProcessOwnOrder = true;
    @Autowired
    private PayNoticeService payNoticeService;
    @Autowired
    private PayOrderOkDAO payOrderOkDAO;
    @Autowired
    private CustomOrderDAO customOrderDAO;
    @Autowired
    private OrderService orderService;
    @Autowired
    private RepairChannelService repairChannelService;

    @Scheduled(fixedDelay=180000L)
    public void reSendPayOrderOkNotice() {
        Calendar ca = Calendar.getInstance();
        ca.add(12, -2);
        Date endTime = ca.getTime();
        ca.add(5, -1);
        Date fromTime = ca.getTime();
        List<String> xunleiPayIdList = this.listUnsuccessNoticeXunleiPayId(fromTime, endTime);
        if (null == xunleiPayIdList) {
            logger.debug("xunleiPayIdList is null,nothing to do");
            return;
        }
        logger.debug("xunleiPayIdList size:{}", (Object)xunleiPayIdList.size());
        for (String xunleiPayId : xunleiPayIdList) {
            if (this.onlyProcessOwnOrder && !XunleiPayIdUtils.isOwnXunleiPayId((String)xunleiPayId)) {
                logger.debug("xunleiPayId:{} is not owns,ignore", (Object)xunleiPayId);
                continue;
            }
            logger.info("reSendPayOrderOkNotice..xunleiPayId:{}", (Object)xunleiPayId);
            this.payNoticeService.sendPayOrderOkNotice(xunleiPayId);
        }
    }

    private List<String> listUnsuccessNoticeXunleiPayId(Date fromTime, Date endTime) {
        try {
            return this.payOrderOkDAO.listUnsuccessNoticeXunleiPayId(fromTime, endTime);
        }
        catch (DataAccessException e) {
            logger.error(e.getMessage(), (Throwable)e);
            return null;
        }
    }

    @Scheduled(fixedDelay=60000L)
    public void repairOrder() {
        List xunleiPayIds = this.customOrderDAO.listWaitedXunleiPayId();
        if (xunleiPayIds.isEmpty()) {
            logger.debug("No xunleiPayId found for repair");
        }
        for (String xunleiPayId : xunleiPayIds) {
            logger.info("repairOrder...xunleiPayId:{}", (Object)xunleiPayId);
            if (this.onlyProcessOwnOrder && !XunleiPayIdUtils.isOwnXunleiPayId((String)xunleiPayId)) {
                logger.debug("xunleiPayId:{} is not owns,ignore", (Object)xunleiPayId);
                continue;
            }
            final QueryResponse queryResponse = this.orderService.doThirdpartyQuery(xunleiPayId);
            if (queryResponse.isPaySuccess()) {
                boolean success = this.repairChannelService.repairOrder(xunleiPayId, new ChannelData(){

                    public String getChannelOrderId() {
                        return queryResponse.getChannelOrderId();
                    }

                    public String generateOkExtJson() {
                        return queryResponse.getExtraJson();
                    }

                    public int getFareAmt() {
                        return queryResponse.getFeeAmt();
                    }

                    public int getFactAmt() {
                        return queryResponse.getOrderAmt() - queryResponse.getFeeAmt();
                    }
                });
                if (success) {
                    this.customOrderDAO.customOrderSuccess(xunleiPayId);
                    continue;
                }
                this.customOrderDAO.customOrderfailed(xunleiPayId, "\u66f4\u65b0\u8ba2\u5355\u8868\u5931\u8d25");
                continue;
            }
            this.customOrderDAO.customOrderfailed(xunleiPayId, "\u8ba2\u5355\u672a\u652f\u4ed8\u6210\u529f\uff0c\u4eba\u5de5\u5b9a\u5236\u5931\u8d25");
        }
    }
}

