/*
 * Decompiled with CFR 0.152.
 */
package com.xunlei.channel.gateway.pay.common;

import com.xunlei.channel.gateway.common.utils.HttpUtils;
import java.io.IOException;
import java.util.Date;
import java.util.ResourceBundle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ChildrenUserUtils {
    private static final Logger logger = LoggerFactory.getLogger(ChildrenUserUtils.class);
    private static final String checkDiamondChildrenAccontUrl = ResourceBundle.getBundle("checkaccount").getString("checkDiamondChildrenAccontUrl");
    private static final String checkCompanyChildrenAccontUrl = ResourceBundle.getBundle("checkaccount").getString("checkCompanyChildrenAccontUrl");

    public static boolean checkIsChildrenAccount(String xunleiId, String userShow) {
        try {
            if (userShow.contains(":") && ChildrenUserUtils.checkDiamondChildrenAccount(xunleiId)) {
                return true;
            }
            return userShow.contains("@") && ChildrenUserUtils.checkCompanyChildrenAccount(xunleiId);
        }
        catch (Exception e) {
            logger.error("", (Throwable)e);
            return false;
        }
    }

    public static boolean checkDiamondChildrenAccount(String xunleiId) throws IOException {
        StringBuilder url = new StringBuilder();
        url.append(checkDiamondChildrenAccontUrl);
        url.append("request=query_parent&");
        url.append("cuid=").append(xunleiId).append("&");
        url.append("rt=").append(new Date().getTime());
        String result = HttpUtils.doGet((String)url.toString());
        logger.debug("result:{}", (Object)result);
        if (null == result || "".equals(result)) {
            return false;
        }
        if (result.contains("parent")) {
            logger.info("userId:{} is a son of diamondAccount", (Object)xunleiId);
            return true;
        }
        logger.debug("userId:{} is not a son of diamondAccount", (Object)xunleiId);
        return false;
    }

    public static boolean checkCompanyChildrenAccount(String xunleiId) throws IOException {
        String url = checkCompanyChildrenAccontUrl + xunleiId;
        String resp = HttpUtils.doGet((String)url);
        logger.debug("checkCompanyChildrenAccount for userId:{} with resp:{}", (Object)xunleiId, (Object)resp);
        if (resp.contains("ret=0")) {
            logger.info("userId:{} is a son of companyAccount", (Object)xunleiId);
            return true;
        }
        logger.debug("userId:{} is not a son of companyAccount", (Object)xunleiId);
        return false;
    }
}

