/*
 * Decompiled with CFR 0.152.
 */
package com.xunlei.channel.gateway.pay.channels.thunderpay;

import com.xunlei.channel.db.pojo.PayOrder;
import com.xunlei.channel.db.pojo.PayOrderOk;
import com.xunlei.channel.gateway.common.constants.InterfaceReqResult;
import com.xunlei.channel.gateway.common.result.DirectReturnResult;
import com.xunlei.channel.gateway.common.result.ReturnResult;
import com.xunlei.channel.gateway.pay.channels.AbstractChannelService;
import com.xunlei.channel.gateway.pay.channels.thunderpay.ThunderpayChannelData;
import com.xunlei.channel.thundercore.client.response.ConsumeResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class ThunderpayService
extends AbstractChannelService {
    private static final Logger logger = LoggerFactory.getLogger(ThunderpayService.class);
    private static final String THUNDER_SUCCESS_CODE = "00";

    public ReturnResult dealResult(ConsumeResponse consumeResponse, ThunderpayChannelData data) {
        if (consumeResponse == null) {
            logger.info("xunleiPayId:{},consumeResponse is null", (Object)data.getXunleiPayId());
        }
        logger.info("xunleiPayId:{},consumeResponse.trnCode:{}", (Object)data.getXunleiPayId(), (Object)consumeResponse.getRtnCode());
        PayOrder payOrder = this.getPayOrderByXunleiPayId(data.getXunleiPayId());
        if (null == payOrder) {
            logger.error("cannot find payOrder with xunleiPayId:{},ignore", (Object)data.getXunleiPayId());
            return new DirectReturnResult(InterfaceReqResult.FAIL, "99", "\u652f\u4ed8\u5931\u8d25\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5:(", "pay_fail_page", null);
        }
        if ("S".equals(payOrder.getStatus())) {
            return new DirectReturnResult(InterfaceReqResult.FAIL, THUNDER_SUCCESS_CODE, "SUCCESS", "pay_fail_page", null);
        }
        if (THUNDER_SUCCESS_CODE.equals(consumeResponse.getRtnCode())) {
            PayOrderOk payOrderOk = this.processPaySuccess(payOrder, data);
            if (null != payOrderOk) {
                logger.info("thundercore pay success...xunleiPayId:{}", (Object)payOrderOk.getXunleiPayId());
            } else {
                logger.error("error,PayOrderOk is null...xunleiPayId:{}", (Object)data.getXunleiPayId());
            }
            return new DirectReturnResult(InterfaceReqResult.FAIL, THUNDER_SUCCESS_CODE, "SUCCESS", "pay_fail_page", null);
        }
        String errorCode = "99";
        String errorMsg = "";
        if ("20".equals(consumeResponse.getRtnCode()) || "23".equals(consumeResponse.getRtnCode())) {
            errorMsg = "\u96f7\u70b9\u51bb\u7ed3";
            errorCode = "95";
        } else if ("21".equals(consumeResponse.getRtnCode())) {
            errorMsg = "\u8d26\u6237\u5173\u95ed";
            errorCode = "96";
        } else if ("22".equals(consumeResponse.getRtnCode())) {
            errorMsg = "\u4f59\u989d\u4e0d\u8db3";
            errorCode = "15";
        } else if ("07".equals(consumeResponse.getRtnCode())) {
            errorMsg = "\u975e\u8fc5\u96f7\u5145\u503c\u7528\u6237";
            errorCode = "92";
        } else {
            logger.error("unknown thundercore rtnCode:{}", (Object)consumeResponse.getRtnCode());
            errorMsg = "\u652f\u4ed8\u5931\u8d25\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5:(";
            errorCode = "99";
        }
        this.processPayFail(payOrder, errorCode, errorMsg, payOrder.getXunleiPayId(), "{}");
        return new DirectReturnResult(InterfaceReqResult.FAIL, errorCode, errorMsg, "pay_fail_page", null);
    }

    public void processFailedOrder(String xunleiPayId, String errorCode, String errorMsg) {
        logger.info("processFailedOrder...xunleiPayId:{}", (Object)xunleiPayId);
        PayOrder payOrder = this.getPayOrderByXunleiPayId(xunleiPayId);
        if (null != payOrder) {
            this.processPayFail(payOrder, errorCode, errorMsg, payOrder.getXunleiPayId(), "{}");
        }
    }
}

