/*
 * Decompiled with CFR 0.152.
 */
package com.xunlei.channel.gateway.pay.channels.thcardpay;

import com.google.common.base.Strings;
import com.xunlei.channel.db.pojo.PayOrder;
import com.xunlei.channel.gateway.common.constants.InterfaceReqResult;
import com.xunlei.channel.gateway.common.pay.ChannelData;
import com.xunlei.channel.gateway.common.result.DirectReturnResult;
import com.xunlei.channel.gateway.common.result.InterfaceProcessResult;
import com.xunlei.channel.gateway.common.utils.HttpUtils;
import com.xunlei.channel.gateway.common.utils.JsonUtils;
import com.xunlei.channel.gateway.pay.annotation.PayType;
import com.xunlei.channel.gateway.pay.channels.AbstractChannelService;
import com.xunlei.channel.gateway.pay.channels.ChannelHandler;
import com.xunlei.channel.gateway.pay.channels.thcardpay.ThCardPayChannelData;
import com.xunlei.channel.gateway.pay.channels.thcardpay.ThCardPayChannelInfo;
import com.xunlei.channel.gateway.pay.channels.thcardpay.ThCardPayResult;
import com.xunlei.channel.gateway.pay.channels.thcardpay.ThCardPayUtils;
import com.xunlei.channel.gateway.pay.pojo.UnitedPayRequest;
import java.io.Serializable;
import java.util.HashMap;
import org.dom4j.Document;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
@PayType(value="T", desc="\u5929\u5b8f\u4e00\u5361\u901a\u652f\u4ed8")
public class ThCardPayChannelHandler
extends AbstractChannelService
implements ChannelHandler<DirectReturnResult> {
    private static final Logger logger = LoggerFactory.getLogger(ThCardPayChannelHandler.class);
    @Autowired
    ThCardPayChannelInfo thCardPayChannelInfo;

    @Override
    public DirectReturnResult generateChannelResult(UnitedPayRequest unitedPayRequest) {
        ThCardPayChannelData thCardPayChannelData = this.generateChannelData(unitedPayRequest);
        try {
            String payUrl = ThCardPayUtils.createPayUrl(thCardPayChannelData, this.thCardPayChannelInfo);
            String resp = HttpUtils.doGet((String)payUrl);
            logger.info("pay resp:{}", (Object)resp);
            Document document = null;
            String xmlResp = new String(this.moveBOM(resp.getBytes("UTF-8")), "UTF-8");
            logger.debug("xmlResp:{}", (Object)xmlResp);
            document = DocumentHelper.parseText((String)xmlResp);
            Element root = document.getRootElement();
            Element state = root.element("state");
            String code = state.element("code").getText();
            final String orderId = thCardPayChannelData.getOrderNum();
            PayOrder payOrder = this.getPayOrderByXunleiPayId(orderId);
            if (null == payOrder) {
                logger.error("cannot find payOrder with xunleiPayId:{},return fail", (Object)orderId);
                return new DirectReturnResult(InterfaceReqResult.SUCCESS, "", "", "", new InterfaceProcessResult("", (Serializable)new ThCardPayResult("F", "18", "\u652f\u4ed8\u8ba2\u5355\u4e0d\u5b58\u5728")));
            }
            if ("S".equals(payOrder.getStatus())) {
                logger.info("payOrder:{} status was success,do nothing and return", (Object)orderId);
                return new DirectReturnResult(InterfaceReqResult.SUCCESS, "", "", "", new InterfaceProcessResult(payOrder.getBizNo(), (Serializable)new ThCardPayResult("S", "", "\u652f\u4ed8\u8ba2\u5355\u6210\u529f")));
            }
            if ("F".equals(payOrder.getStatus())) {
                logger.info("payOrder:{} status was failed,do nothing and return", (Object)orderId);
                return new DirectReturnResult(InterfaceReqResult.SUCCESS, "", "", "", new InterfaceProcessResult(payOrder.getBizNo(), (Serializable)new ThCardPayResult("F", "99", "\u8ba2\u5355\u652f\u4ed8\u5931\u8d25")));
            }
            if ("1".equals(code)) {
                String orderAmtResp = state.element("money").getText();
                final int orderAmt = thCardPayChannelData.getBuyNum();
                if (Integer.parseInt(orderAmtResp) != orderAmt) {
                    logger.error("notify_orderAmt:{} not equals pay_orderAmt:{}", (Object)orderAmtResp, (Object)orderAmt);
                    new DirectReturnResult(InterfaceReqResult.SUCCESS, "", "", "", new InterfaceProcessResult(payOrder.getBizNo(), (Serializable)new ThCardPayResult("U", "", "\u7cfb\u7edf\u5f02\u5e38\uff0c\u8bf7\u8054\u7cfb\u8fc5\u96f7\u5ba2\u670d\u67e5\u770b\u652f\u4ed8\u7ed3\u679c")));
                }
                final double PAY_RATE = this.thCardPayChannelInfo.getConfigValueDouble("fee_rate");
                ChannelData channelData = new ChannelData(){

                    public int getFareAmt() {
                        return (int)((double)orderAmt * PAY_RATE * 100.0);
                    }

                    public int getFactAmt() {
                        return orderAmt * 100 - (int)((double)orderAmt * PAY_RATE * 100.0);
                    }

                    public String getChannelOrderId() {
                        return orderId;
                    }

                    public String generateOkExtJson() {
                        return null;
                    }
                };
                this.processPaySuccess(payOrder, channelData);
                return new DirectReturnResult(InterfaceReqResult.SUCCESS, "", "", "", new InterfaceProcessResult(payOrder.getBizNo(), (Serializable)new ThCardPayResult("S", "", "\u652f\u4ed8\u8ba2\u5355\u6210\u529f")));
            }
            String errorMsg = state.element("msg").getText();
            if (errorMsg.length() > 255) {
                errorMsg = errorMsg.substring(0, 255);
            }
            errorMsg = errorMsg.replace("<", ",").replace(">", ",");
            this.processPayFail(payOrder, code, errorMsg, orderId, "");
            return new DirectReturnResult(InterfaceReqResult.SUCCESS, "", "", "", new InterfaceProcessResult(payOrder.getBizNo(), (Serializable)new ThCardPayResult("F", code, errorMsg)));
        }
        catch (Exception e) {
            logger.error("", (Throwable)e);
            return new DirectReturnResult(InterfaceReqResult.SUCCESS, "", "", "", new InterfaceProcessResult("", (Serializable)new ThCardPayResult("U", "99", "\u7cfb\u7edf\u5f02\u5e38\uff0c\u8bf7\u7a0d\u540e\u786e\u8ba4\u652f\u4ed8\u7ed3\u679c")));
        }
    }

    protected ThCardPayChannelData generateChannelData(UnitedPayRequest unitedPayRequest) {
        String orderId = unitedPayRequest.getXunleiPayId();
        int orderAmt = unitedPayRequest.getOrderAmt() / 100;
        String[] kaHao = unitedPayRequest.getExtraParamsMap().get("ka_hao").split("^");
        String[] miMa = unitedPayRequest.getExtraParamsMap().get("mi_ma").split("^");
        ThCardPayChannelData thCardPayChannelData = new ThCardPayChannelData();
        thCardPayChannelData.setAddition("");
        thCardPayChannelData.setBuyNum(orderAmt);
        thCardPayChannelData.setCkNum(kaHao.length);
        thCardPayChannelData.setKaHao(kaHao);
        thCardPayChannelData.setMiMa(miMa);
        thCardPayChannelData.setOrderNum(orderId);
        return thCardPayChannelData;
    }

    @Override
    public DirectReturnResult validateSpecialParams(UnitedPayRequest unitedPayRequest) {
        String[] miMas;
        int orderAmt = unitedPayRequest.getOrderAmt();
        if (orderAmt / 100 * 100 != orderAmt) {
            logger.error("invalid orderAmt:{}", (Object)orderAmt);
            return new DirectReturnResult(InterfaceReqResult.FAIL, "13", "invalid param order_amt", "pay_fail_page", null);
        }
        String kaHao = unitedPayRequest.getExtraParamsMap().get("ka_hao");
        if (Strings.isNullOrEmpty((String)kaHao)) {
            logger.error("invalid kaHao:{}", (Object)kaHao);
            return new DirectReturnResult(InterfaceReqResult.FAIL, "13", "invalid param ka_hao", "pay_fail_page", null);
        }
        String miMa = unitedPayRequest.getExtraParamsMap().get("mi_ma");
        if (Strings.isNullOrEmpty((String)miMa)) {
            logger.error("invalid miMa:{}", (Object)miMa);
            return new DirectReturnResult(InterfaceReqResult.FAIL, "13", "invalid param mi_ma", "pay_fail_page", null);
        }
        String[] kaHaos = kaHao.split("^");
        if (kaHaos.length != (miMas = miMa.split("^")).length) {
            logger.error("invalid kaHao:{} and miMa:{} (kahao length not equals mima length)", (Object)kaHao, (Object)miMa);
            return new DirectReturnResult(InterfaceReqResult.FAIL, "13", "invalid param ka_hao and mi_ma", "pay_fail_page", null);
        }
        if (kaHaos.length > 5) {
            logger.error("invalid kaHao:{} and miMa:{} (length>5)", (Object)kaHao, (Object)miMa);
            return new DirectReturnResult(InterfaceReqResult.FAIL, "13", "invalid param ka_hao and mi_ma", "pay_fail_page", null);
        }
        return null;
    }

    @Override
    public String analyzeExtParams(UnitedPayRequest unitedPayRequest) {
        String kaHao = unitedPayRequest.getExtraParamsMap().get("ka_hao");
        String miMa = unitedPayRequest.getExtraParamsMap().get("mi_ma");
        HashMap<String, String> extParams = new HashMap<String, String>();
        extParams.put("ka_hao", kaHao);
        extParams.put("mi_ma", miMa);
        return JsonUtils.toJson(extParams);
    }

    @Override
    public String generateRemark(UnitedPayRequest payRequest) {
        return null;
    }

    private byte[] moveBOM(byte[] bytes) {
        if (null != bytes && bytes.length > 3) {
            byte bt1 = bytes[0];
            byte bt2 = bytes[1];
            byte bt3 = bytes[2];
            logger.debug("{} {} {}", new Object[]{bt1, bt2, bt3});
            String hex1 = Integer.toHexString(bt1 & 0xFF).toUpperCase();
            String hex2 = Integer.toHexString(bt2 & 0xFF).toUpperCase();
            String hex3 = Integer.toHexString(bt3 & 0xFF).toUpperCase();
            logger.debug("{} {} {}", new Object[]{hex1, hex2, hex3});
            if ("EF".equals(hex1) && "BB".equals(hex2) && "BF".equals(hex3)) {
                byte[] newByte = new byte[bytes.length - 3];
                for (int index = 3; index < bytes.length; ++index) {
                    newByte[index - 3] = bytes[index];
                }
                return newByte;
            }
        }
        return bytes;
    }
}

