/*
 * Decompiled with CFR 0.152.
 */
package com.xunlei.channel.gateway.pay.channels.ext19pay;

import com.google.common.base.Strings;
import com.xunlei.channel.gateway.pay.channels.AbstractChannelInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class Ext19PayChannelInfo
extends AbstractChannelInfo {
    private static final Logger logger = LoggerFactory.getLogger(Ext19PayChannelInfo.class);
    public static final String CACHE_GROUP_ID = "gateway_ext19pay";
    public static final String CACHE_CHINA_MOBILE_CARD_AMT = "cm_card_amt";
    public static final String CACHE_UNICOM_CARD_AMT = "unicom_card_amt";
    public static final String CACHE_TELECOM_CARD_AMT = "telecom_card_amt";
    public static final String CACHE_CM_PM_ID = "cm_pm_id";
    public static final String CACHE_UNICOM_PM_ID = "unicom_pm_id";
    public static final String CACHE_TELECOM_PM_ID = "telecom_pm_id";
    public static final String CACHE_CM_PC_ID = "cm_pc_id";
    public static final String CACHE_UNICOM_PC_ID = "unicom_pc_id";
    public static final String CACHE_TELECOM_PC_ID = "telecom_pc_id";
    public static final String CACHE_MERCHANT_ID = "merchant_id";
    public static final String CACHE_MERCHANT_KEY = "merchant_key";
    public static final String CACHE_RET_URL = "ret_url";
    public static final String CACHE_NOTIFY_URL = "notify_url";
    public static final String CACHE_PAY_URL = "pay_url";
    public static final String CACHE_FEE_RATE = "fee_rate";
    public static final String VERSION_ID = "1.0";
    public static final String CURRENCY = "RMB";
    public static final String INPUT_CHARSET = "GB2312";
    public static final String CARD_NO = "card_no";
    public static final String CARD_PWD = "card_pwd";
    public static final String PAY_DATE = "pay_date";

    public boolean isAmtAllowed(String cacheType, int orderAmt) {
        String validAmts = this.getConfigValue(cacheType);
        if (Strings.isNullOrEmpty((String)validAmts)) {
            logger.error("cant getValue for cacheType:{},orderAmt is invalid", (Object)cacheType);
            return false;
        }
        String[] amts = validAmts.split("\\,");
        boolean match = false;
        String amt = String.valueOf(orderAmt);
        for (int i = 0; i < amts.length; ++i) {
            if (!amt.equals(amts[i])) continue;
            match = true;
            break;
        }
        return match;
    }

    @Override
    protected String getGroupId() {
        return CACHE_GROUP_ID;
    }
}

