/*
 * Decompiled with CFR 0.152.
 */
package com.xunlei.channel.gateway.order.service.impl;

import com.google.common.base.Strings;
import com.xunlei.channel.db.dao.ConfigInfoDAO;
import com.xunlei.channel.db.dao.PayOrderDAO;
import com.xunlei.channel.db.pojo.ConfigInfo;
import com.xunlei.channel.db.pojo.PayOrder;
import com.xunlei.channel.gateway.common.utils.BizUtil;
import com.xunlei.channel.gateway.common.utils.SignatureUtils;
import com.xunlei.channel.gateway.common.utils.ValidateUtils;
import com.xunlei.channel.gateway.order.service.OrderService;
import com.xunlei.channel.gateway.order.vo.UnitedQueryRequest;
import com.xunlei.channel.gateway.order.vo.UnitedQueryResult;
import com.xunlei.channel.thirdparty.client.ThirdpartyQueryClient;
import com.xunlei.channel.thirdparty.vo.QueryRequest;
import com.xunlei.channel.thirdparty.vo.QueryResponse;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class OrderServiceImpl
implements OrderService {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private PayOrderDAO payOrderDao;
    @Autowired
    private BizUtil bizUtil;
    @Autowired
    private ConfigInfoDAO configInfoDAO;

    private PayOrder processOrderQuery(String bizNo, String bizOrderId) {
        this.logger.debug("processOrderQuery...bizNo:{},bizOrderId:{}", (Object)bizNo, (Object)bizOrderId);
        PayOrder payOrder = this.payOrderDao.getPayOrderByBizNoAndBizOrderId(bizNo, bizOrderId);
        return payOrder;
    }

    @Override
    public UnitedQueryResult processUnitedQuery(UnitedQueryRequest request) {
        try {
            UnitedQueryResult unitedQueryResult = this.validateUnitedRequest(request);
            if (unitedQueryResult == null) {
                this.logger.error("The ValidateQueryResult got from UnitedValidator is null");
            }
            if (!unitedQueryResult.hasErrors()) {
                PayOrder payOrder = this.processOrderQuery(request.getBizNo(), request.getBizOrderId());
                unitedQueryResult.setQueriedOrderInfo(payOrder);
            }
            return unitedQueryResult;
        }
        catch (Exception e) {
            this.logger.error(e.getMessage(), (Throwable)e);
            return UnitedQueryResult.generateUnitedQueryResult("99");
        }
    }

    private UnitedQueryResult validateUnitedRequest(UnitedQueryRequest request) {
        Set validateSet = ValidateUtils.validate((Object)request);
        if (validateSet.size() > 0) {
            return UnitedQueryResult.generateUnitedQueryResult("13");
        }
        String bizKey = this.bizUtil.getBizKey(request.getBizNo());
        if (Strings.isNullOrEmpty((String)bizKey)) {
            return UnitedQueryResult.generateUnitedQueryResult("14");
        }
        this.logger.debug("\u8fdb\u884c\u7b7e\u540d\u5224\u65ad");
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("bizNo", request.getBizNo());
        params.put("orderId", request.getBizOrderId());
        params.put("signMsg", request.getSign());
        if (!SignatureUtils.checkSign(params, (String)bizKey, (String)"signMsg")) {
            return UnitedQueryResult.generateUnitedQueryResult("11");
        }
        return UnitedQueryResult.generateUnitedQueryResult("00");
    }

    @Override
    public QueryResponse doThirdpartyQuery(String xunleiPayId) {
        this.logger.info("queryOrder...xunleiPayId:{}", (Object)xunleiPayId);
        if (null == xunleiPayId) {
            return QueryResponse.generateErrorResponse((String)"", (String)"\u8fc5\u96f7\u652f\u4ed8\u53f7\u65e0\u6548");
        }
        PayOrder payOrder = this.payOrderDao.getPayOrder(xunleiPayId);
        if (null == payOrder) {
            return QueryResponse.generateErrorResponse((String)"", (String)"\u8fc5\u96f7\u652f\u4ed8\u53f7\u65e0\u6548");
        }
        QueryRequest request = new QueryRequest(xunleiPayId, payOrder.getPayType(), payOrder.getOrderAmt(), payOrder.getXunleiId(), payOrder.getUserShow(), payOrder.getPhone(), payOrder.getBizOrderId(), payOrder.getExtraJson(), payOrder.getCreateTime(), payOrder.getOrderGroup(), payOrder.getChannelOrderId());
        String groupId = ThirdpartyQueryClient.getPayTypeGroupId((String)payOrder.getPayType());
        if (null == groupId) {
            return QueryResponse.generateErrorResponse((String)"", (String)"\u65e0\u6548\u7684group_id");
        }
        ConfigInfo query = new ConfigInfo();
        query.setGroupId(groupId);
        List configList = this.configInfoDAO.getConfigInfo(query);
        Map<String, String> configMap = this.generateConfigMap(configList);
        return ThirdpartyQueryClient.query3rdPartyOrder((QueryRequest)request, configMap);
    }

    private Map<String, String> generateConfigMap(List<ConfigInfo> configList) {
        HashMap<String, String> map = new HashMap<String, String>(configList.size());
        for (ConfigInfo info : configList) {
            map.put(info.getPropertyKey(), info.getPropertyValue());
        }
        return map;
    }
}

