/*
 * Decompiled with CFR 0.152.
 */
package com.xunlei.channel.gateway.order.vo;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonRootName;
import com.xunlei.channel.db.pojo.PayOrder;
import com.xunlei.channel.gateway.common.utils.DateUtils;
import java.util.Date;

@JsonRootName(value="query_result")
public class UnitedQueryResult {
    public static final String SUCCESS = "00";
    private String isSuccess;
    private String errorCode;
    private String errorMsg;
    private String bizNo;
    private String bizOrderId;
    private int orderAmt;
    private String xunleiId;
    private String userShow;
    private String orderStatus;
    private String productName;
    private String resultTime;
    private String xunleiPayId;

    @JsonProperty(value="is_success")
    public String getIsSuccess() {
        return this.isSuccess;
    }

    @JsonProperty(value="error_code")
    public String getErrorCode() {
        return this.errorCode;
    }

    public void setErrorCode(String errorCode) {
        this.errorCode = errorCode;
        if (SUCCESS == errorCode) {
            this.setIsSuccess("Y");
        } else {
            this.setIsSuccess("N");
        }
    }

    @JsonProperty(value="error_msg")
    public String getErrorMsg() {
        return this.errorMsg;
    }

    public void setErrorMsg(String errorMsg) {
        this.errorMsg = errorMsg;
    }

    @JsonProperty(value="biz_no")
    public String getBizNo() {
        return this.bizNo;
    }

    public void setBizNo(String bizNo) {
        this.bizNo = bizNo;
    }

    @JsonProperty(value="biz_order_id")
    public String getBizOrderId() {
        return this.bizOrderId;
    }

    public void setBizOrderId(String bizOrderId) {
        this.bizOrderId = bizOrderId;
    }

    @JsonProperty(value="order_amt")
    public int getOrderAmt() {
        return this.orderAmt;
    }

    public void setOrderAmt(int orderAmt) {
        this.orderAmt = orderAmt;
    }

    @JsonProperty(value="xunlei_id")
    public String getXunleiId() {
        return this.xunleiId;
    }

    public void setXunleiId(String xunleiId) {
        this.xunleiId = xunleiId;
    }

    @JsonProperty(value="user_show")
    public String getUserShow() {
        return this.userShow;
    }

    public void setUserShow(String userShow) {
        this.userShow = userShow;
    }

    @JsonProperty(value="order_status")
    public String getOrderStatus() {
        return this.orderStatus;
    }

    public void setOrderStatus(String orderStatus) {
        this.orderStatus = orderStatus;
    }

    @JsonProperty(value="product_name")
    public String getProductName() {
        return this.productName;
    }

    public void setProductName(String productName) {
        this.productName = productName;
    }

    @JsonProperty(value="result_time")
    public String getResultTime() {
        return this.resultTime;
    }

    public void setResultTime(String resultTime) {
        this.resultTime = resultTime;
    }

    @JsonProperty(value="xunlei_pay_id")
    public String getXunleiPayId() {
        return this.xunleiPayId;
    }

    public void setXunleiPayId(String xunleiPayId) {
        this.xunleiPayId = xunleiPayId;
    }

    public void setIsSuccess(String isSuccess) {
        this.isSuccess = isSuccess;
    }

    public boolean hasErrors() {
        return "N".equals(this.isSuccess);
    }

    public void setQueriedOrderInfo(PayOrder payOrder) {
        if (null == payOrder) {
            this.setIsSuccess("N");
            this.setErrorCode("91");
            this.setErrorMsg("Unfound");
        } else {
            this.setOrderAmt(payOrder.getOrderAmt());
            this.setOrderStatus(payOrder.getStatus());
            this.setProductName(payOrder.getProductName());
            this.setResultTime(DateUtils.timeToYyyyMMddhhmmss((Date)payOrder.getUpdateTime()));
            this.setUserShow(payOrder.getUserShow());
            this.setXunleiId(payOrder.getXunleiId());
            this.setXunleiPayId(payOrder.getXunleiPayId());
        }
    }

    public static UnitedQueryResult generateUnitedQueryResult(String errorCode) {
        UnitedQueryResult result = new UnitedQueryResult();
        result.setErrorCode(errorCode);
        return result;
    }
}

