/*
 * Decompiled with CFR 0.152.
 */
package com.xunlei.channel.gateway.notice.service.impl;

import com.xunlei.channel.db.dao.PayOrderOkDAO;
import com.xunlei.channel.db.pojo.PayOrderOk;
import com.xunlei.channel.gateway.common.pojo.PayResult;
import com.xunlei.channel.gateway.notice.message.PayNoticeMessage;
import com.xunlei.channel.gateway.notice.send.PayNoticeSender;
import com.xunlei.channel.gateway.notice.service.PayNoticeService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class PayNoticeServiceImpl
implements PayNoticeService {
    private static final Logger logger = LoggerFactory.getLogger(PayNoticeServiceImpl.class);
    @Autowired
    private PayOrderOkDAO payOrderOkDAO;
    @Autowired
    private PayNoticeSender payNoticeSender;

    @Override
    public boolean sendPayOrderOkNotice(String xunleiPayId) {
        logger.debug("sendBizOrderOkNotice...xunleiPayId:{}", (Object)xunleiPayId);
        if (null == xunleiPayId) {
            return false;
        }
        String sendNoticeStatus = this.payOrderOkDAO.getPayOrderOkSendNoticeStatus(xunleiPayId);
        if (null == sendNoticeStatus) {
            logger.error("No PayOrderOk found with xunleiPayId:{}", (Object)xunleiPayId);
            return false;
        }
        if (PayOrderOk.isNoticeSended((String)sendNoticeStatus)) {
            return true;
        }
        boolean result = this.payNoticeSender.sendPayNoticeMsg(new PayNoticeMessage(xunleiPayId, PayResult.SUCCESS));
        this.payOrderOkDAO.updateSendNoticeStatus(xunleiPayId, result ? "S" : "F");
        return result;
    }
}

