/*
 * Decompiled with CFR 0.152.
 */
package com.xunlei.channel.gateway.notice.schedule;

import com.xunlei.channel.db.dao.PayNoticeDAO;
import com.xunlei.channel.db.pojo.PayNotice;
import com.xunlei.channel.gateway.common.pojo.PayResult;
import com.xunlei.channel.gateway.common.utils.XunleiPayIdUtils;
import com.xunlei.channel.gateway.notice.message.PayNoticeMessage;
import com.xunlei.channel.gateway.notice.send.PayNoticeSender;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.dao.DataAccessException;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Component;

@Component
public class PayNoticeScheduler {
    public static int firstTypeIntervalMins = 1;
    public static int firstTypeIntervalMinFailtimes = 0;
    public static int firstTypeIntervalMaxFailtimes = 9;
    public static int secondTypeIntervalMins = 10;
    public static int secondTypeIntervalMinFailtimes = 10;
    public static int secondTypeIntervalMaxFailtimes = 14;
    public static int thirdTypeIntervalMins = 30;
    public static int thirdTypeIntervalMinFailtimes = 15;
    public static int thirdTypeIntervalMaxFailtimes = 115;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    private boolean onlyProcessOwnOrder = true;
    @Autowired
    private PayNoticeDAO payNoticeFailDAO;
    @Autowired
    private PayNoticeSender payNoticeSender;

    @Scheduled(fixedDelay=60000L)
    public void reSendNoticeFailed() {
        Calendar ca = Calendar.getInstance();
        ca.add(12, -firstTypeIntervalMins);
        this.reSendNoticefailed(ca.getTime(), firstTypeIntervalMinFailtimes, firstTypeIntervalMaxFailtimes);
        ca.add(12, firstTypeIntervalMins - secondTypeIntervalMins);
        this.reSendNoticefailed(ca.getTime(), secondTypeIntervalMinFailtimes, secondTypeIntervalMaxFailtimes);
        ca.add(12, secondTypeIntervalMins - thirdTypeIntervalMins);
        this.reSendNoticefailed(ca.getTime(), thirdTypeIntervalMinFailtimes, thirdTypeIntervalMaxFailtimes);
    }

    private void reSendNoticefailed(Date noticeTime, int minFailTimes, int maxFailTimes) {
        List<PayNotice> failList = this.getPayNoticeFailList(noticeTime, minFailTimes, maxFailTimes);
        if (null == failList) {
            this.logger.debug("reSendNoticefailed...date:{},minFailTimes:{},maxFailTimes:{}...result is null,return now", new Object[]{noticeTime, minFailTimes, maxFailTimes});
            return;
        }
        this.logger.debug("reSendNoticefailed...date:{},minFailTimes:{},maxFailTimes:{}...result size:{}", new Object[]{noticeTime, minFailTimes, maxFailTimes, failList.size()});
        for (PayNotice fail : failList) {
            if (this.onlyProcessOwnOrder && !XunleiPayIdUtils.isOwnXunleiPayId((String)fail.getXunleiPayId())) {
                this.logger.debug("xunleiPayId:{} is not owns,ignore", (Object)fail.getXunleiPayId());
                continue;
            }
            this.logger.info("reSendNoticefailed...xunleiPayId:{}", (Object)fail.getXunleiPayId());
            this.payNoticeSender.sendPayNoticeMsg(new PayNoticeMessage(fail.getXunleiPayId(), PayResult.SUCCESS));
        }
    }

    private List<PayNotice> getPayNoticeFailList(Date noticeTime, int minFailTimes, int maxFailTimes) {
        try {
            List list = this.payNoticeFailDAO.getPayNoticeList("F", noticeTime, minFailTimes, maxFailTimes);
            return list;
        }
        catch (DataAccessException e) {
            this.logger.error(e.getMessage(), (Throwable)e);
            return null;
        }
    }
}

