/*
 * Decompiled with CFR 0.152.
 */
package com.xunlei.channel.gateway.notice.receive;

import com.google.common.base.Strings;
import com.xunlei.channel.db.dao.PayNoticeDAO;
import com.xunlei.channel.db.dao.PayOrderDAO;
import com.xunlei.channel.db.dao.PayOrderOkDAO;
import com.xunlei.channel.db.pojo.PayNotice;
import com.xunlei.channel.db.pojo.PayOrderOk;
import com.xunlei.channel.gateway.common.utils.BizUtil;
import com.xunlei.channel.gateway.common.utils.HttpUtils;
import com.xunlei.channel.gateway.common.utils.NoticeUtils;
import com.xunlei.channel.gateway.notice.message.PayNoticeMessage;
import java.util.Date;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageListener;
import javax.jms.ObjectMessage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class PayNoticeReceiver
implements MessageListener {
    private static final Logger logger = LoggerFactory.getLogger(PayNoticeReceiver.class);
    @Autowired
    private PayOrderDAO payOrderDAO;
    @Autowired
    private PayOrderOkDAO payOrderOkDAO;
    @Autowired
    private PayNoticeDAO payNoticeDAO;
    @Autowired
    private BizUtil bizUtil;

    public void onMessage(Message message) {
        logger.debug("get message:{}", (Object)message);
        if (message instanceof ObjectMessage) {
            ObjectMessage objectMessage = (ObjectMessage)message;
            try {
                PayNoticeMessage payNoticeMsg = (PayNoticeMessage)objectMessage.getObject();
                this.sendNotice(payNoticeMsg);
            }
            catch (JMSException e) {
                logger.error(e.getMessage(), (Throwable)e);
            }
        }
    }

    private void sendNotice(PayNoticeMessage payNoticeMsg) {
        PayOrderOk payOrderOk;
        logger.info("sendNotice...xunleiPayId:{},payResult:{}", (Object)payNoticeMsg.getXunleiPayId(), (Object)payNoticeMsg.getPayResult());
        boolean isNewPayNotice = false;
        PayNotice payNotice = this.payNoticeDAO.getPayNotice(payNoticeMsg.getXunleiPayId());
        if (null != payNotice) {
            if ("S".equals(payNotice.getStatus())) {
                logger.info("pay notice success of xunleiPayId:{},nothing to do now", (Object)payNoticeMsg.getXunleiPayId());
                return;
            }
        } else {
            isNewPayNotice = true;
            payNotice = this.generateNewPayNotice(payNoticeMsg.getXunleiPayId());
        }
        if ((payOrderOk = this.payOrderOkDAO.getPayOrderOk(payNoticeMsg.getXunleiPayId())) == null) {
            logger.error("No PayOrderOk found with xunleiPayId:{},sendNotice cancel", (Object)payNoticeMsg.getXunleiPayId());
            return;
        }
        String url = this.buildNotifyUrl(payOrderOk, payNoticeMsg.getPayResult().getValue(), true);
        String response = null;
        try {
            response = HttpUtils.doGet((String)url);
            logger.info("response:{}", (Object)response);
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            response = e.getLocalizedMessage();
        }
        boolean noticeSuccess = NoticeUtils.isNoticeSuccess((String)response, (String)payOrderOk.getVersion());
        payNotice.setNoticeTime(new Date());
        if (noticeSuccess) {
            payNotice.setStatus("S");
            payNotice.setRemark("success");
        } else {
            payNotice.setStatus("F");
            payNotice.setErrorMsg(response.length() > 255 ? response.substring(0, 255) : response);
            payNotice.setFailTimes(Integer.valueOf(payNotice.getFailTimes() + 1));
            payNotice.setRemark("failed");
        }
        if (isNewPayNotice) {
            this.payNoticeDAO.savePayNotice(payNotice);
        } else {
            this.payNoticeDAO.updatePayNotice(payNotice);
        }
    }

    private PayNotice generateNewPayNotice(String xunleiPayId) {
        PayNotice payNotice = new PayNotice();
        payNotice.setFailTimes(Integer.valueOf(0));
        payNotice.setXunleiPayId(xunleiPayId);
        return payNotice;
    }

    public String buildNotifyUrl(PayOrderOk payOrderOk, String payResult, boolean isNotifyUrl) {
        String bizKey = this.bizUtil.getBizKey(payOrderOk.getBizNo());
        if (Strings.isNullOrEmpty((String)bizKey)) {
            logger.error("invalid bizNo:{}", (Object)payOrderOk.getBizNo());
            return null;
        }
        String urlParams = NoticeUtils.generateUrlParams((PayOrderOk)payOrderOk, (String)payResult, (String)bizKey);
        String url = payOrderOk.getNotifyUrl();
        if (!isNotifyUrl) {
            url = payOrderOk.getPageUrl();
        }
        String urlJoin = "?";
        if (null != url && url.indexOf("?") >= 0) {
            urlJoin = "&";
        }
        return url + urlJoin + urlParams;
    }
}

