/*
 * Decompiled with CFR 0.152.
 */
package com.xunlei.channel.gateway.interf.plugin;

import com.xunlei.channel.gateway.common.annotation.ParamName;
import com.xunlei.channel.gateway.interf.plugin.ParamNameDataBinder;
import java.lang.reflect.Field;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.WebDataBinder;
import org.springframework.web.context.request.NativeWebRequest;
import org.springframework.web.context.request.WebRequest;
import org.springframework.web.servlet.mvc.method.annotation.RequestMappingHandlerAdapter;
import org.springframework.web.servlet.mvc.method.annotation.ServletModelAttributeMethodProcessor;

public class RenamingProcessor
extends ServletModelAttributeMethodProcessor {
    private static final Logger logger = LoggerFactory.getLogger(RenamingProcessor.class);
    @Autowired
    private RequestMappingHandlerAdapter requestMappingHandlerAdapter;
    private final Map<Class<?>, Map<String, String>> replaceMap = new ConcurrentHashMap();

    public RenamingProcessor(boolean annotationNotRequired) {
        super(annotationNotRequired);
    }

    protected void bindRequestParameters(WebDataBinder binder, NativeWebRequest nativeWebRequest) {
        Map<String, String> mapping;
        logger.debug("bindRequestParameters...");
        Object target = binder.getTarget();
        Class<?> targetClass = target.getClass();
        if (!this.replaceMap.containsKey(targetClass)) {
            mapping = RenamingProcessor.analyzeClass(targetClass);
            this.replaceMap.put(targetClass, mapping);
        }
        mapping = this.replaceMap.get(targetClass);
        ParamNameDataBinder paramNameDataBinder = new ParamNameDataBinder(target, binder.getObjectName(), mapping);
        this.requestMappingHandlerAdapter.getWebBindingInitializer().initBinder((WebDataBinder)paramNameDataBinder, (WebRequest)nativeWebRequest);
        super.bindRequestParameters((WebDataBinder)paramNameDataBinder, nativeWebRequest);
    }

    private static Map<String, String> analyzeClass(Class<?> targetClass) {
        logger.debug("analyzeClass...{}", targetClass);
        Field[] fields = targetClass.getDeclaredFields();
        HashMap<String, String> renameMap = new HashMap<String, String>();
        for (Field field : fields) {
            ParamName paramNameAnnotation = field.getAnnotation(ParamName.class);
            if (paramNameAnnotation == null || paramNameAnnotation.value().isEmpty()) continue;
            renameMap.put(paramNameAnnotation.value(), field.getName());
        }
        if (renameMap.isEmpty()) {
            return Collections.emptyMap();
        }
        return renameMap;
    }
}

