/*
 * Decompiled with CFR 0.152.
 */
package com.xunlei.channel.gateway.interf.controller.channels;

import com.fasterxml.jackson.dataformat.xml.XmlMapper;
import com.xunlei.channel.gateway.interf.controller.AbstractController;
import com.xunlei.channel.gateway.pay.channels.unicommobilepay.UnicomMobilePayCallBackResponse;
import com.xunlei.channel.gateway.pay.channels.unicommobilepay.UnicomMobilePayChannelInfo;
import com.xunlei.channel.gateway.pay.channels.unicommobilepay.UnicomMobilePayChannelService;
import com.xunlei.channel.gateway.pay.channels.unicommobilepay.UnicomMobilePayException;
import com.xunlei.channel.gateway.pay.channels.unicommobilepay.UnicomMobilePayUtil;
import com.xunlei.channel.gateway.pay.channels.unicommobilepay.UnicomMobileResponseCode;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
public class UnicomMobilePayController
extends AbstractController {
    private static final Logger logger = LoggerFactory.getLogger(UnicomMobilePayController.class);
    @Autowired
    private UnicomMobilePayChannelService channelService;
    @Autowired
    private UnicomMobilePayChannelInfo channelInfo;
    private final ThreadLocal<XmlMapper> xmlMapper = new ThreadLocal<XmlMapper>(){

        @Override
        protected XmlMapper initialValue() {
            return new XmlMapper();
        }
    };

    @RequestMapping(value={"/unicommobilepay/callback"}, produces={"application/xml"})
    @ResponseBody
    public UnicomMobilePayCallBackResponse callBack(HttpServletRequest request, HttpServletResponse response) {
        try {
            UnicomMobilePayUtil.verifyCallBackRequestParam((HttpServletRequest)request);
            this.channelService.executeCallback(request, this.channelInfo);
            return this.buildResponse(UnicomMobileResponseCode.RTN0000.getCode(), "success");
        }
        catch (UnicomMobilePayException e) {
            logger.info("This request is illegal!ErrorMsg is :{}", (Object)e.getMessage());
            return this.buildResponse(e.getErrCode(), e.getMessage());
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            return this.buildResponse(UnicomMobileResponseCode.RTN99.getCode(), e.getMessage());
        }
    }

    @RequestMapping(value={"/unicommobilepay/removeorder"})
    public void removeOrder(HttpServletRequest request, HttpServletResponse response) {
        try {
            logger.warn("requesting remove order, but it not in use !");
            Map paramsMap = UnicomMobilePayUtil.getRequestParamsMap((HttpServletRequest)request, (UnicomMobilePayChannelInfo)this.channelInfo);
            this.buildResponse(UnicomMobileResponseCode.RTN9.getCode(), "\u6ca1\u6709\u5b9e\u73b0\u8be5\u65b9\u6cd5");
        }
        catch (UnicomMobilePayException unicomMobilePayException) {
            // empty catch block
        }
    }

    private UnicomMobilePayCallBackResponse buildResponse(String result, String message) {
        UnicomMobilePayCallBackResponse unicomMobilePayCallBackResponse = new UnicomMobilePayCallBackResponse();
        if (result != null && UnicomMobileResponseCode.RTN0000.equals((Object)result)) {
            unicomMobilePayCallBackResponse.setPayResult(result);
            unicomMobilePayCallBackResponse.setMsg(message);
        } else {
            unicomMobilePayCallBackResponse.setPayResult(UnicomMobileResponseCode.RTN10.getCode());
            unicomMobilePayCallBackResponse.setErrCode(result);
            unicomMobilePayCallBackResponse.setErrMsg(message);
        }
        logger.debug("buildResponse... result: {}, message: {}, return: {}", new Object[]{result, message, unicomMobilePayCallBackResponse});
        return unicomMobilePayCallBackResponse;
    }
}

