/*
 * Decompiled with CFR 0.152.
 */
package com.xunlei.channel.gateway.interf.controller.channels;

import com.xunlei.channel.gateway.interf.controller.AbstractController;
import com.xunlei.channel.gateway.pay.channels.alipay.wapdirect.AlipayWapService;
import java.io.IOException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.RequestMapping;

@Controller
public class AlipayWapController
extends AbstractController {
    private static final Logger logger = LoggerFactory.getLogger(AlipayWapController.class);
    @Autowired
    private AlipayWapService alipayWapService;

    @RequestMapping(value={"/alipay/wap/return"})
    public String returnNotify(HttpServletRequest request, HttpServletResponse response) {
        String msg = this.alipayWapService.returnNotify(request);
        response.setContentType("text/xml");
        try {
            response.getWriter().write(msg);
            response.flushBuffer();
        }
        catch (IOException e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
        return null;
    }

    @RequestMapping(value={"/alipay/wap/page"})
    public String pageNotify(HttpServletRequest request, Model model) {
        logger.info("pageNotify...queryString:{}", (Object)request.getQueryString());
        String redirectUrl = this.alipayWapService.pageNotify(request);
        logger.info("redirect_url:{}", (Object)redirectUrl);
        return "redirect:" + redirectUrl;
    }
}

