/*
 * Decompiled with CFR 0.152.
 */
package com.xunlei.channel.gateway.interf.controller;

import com.xunlei.channel.gateway.common.constants.InterfaceReturnType;
import com.xunlei.channel.gateway.common.result.ReturnResult;
import com.xunlei.channel.gateway.interf.controller.AbstractController;
import com.xunlei.channel.gateway.interf.controller.response.ResponseGenerator;
import com.xunlei.channel.gateway.pay.pojo.UnitedPayRequest;
import com.xunlei.channel.gateway.pay.service.PayService;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.servlet.ModelAndView;

@Controller
public class UnitedPayController
extends AbstractController {
    private static final Logger logger = LoggerFactory.getLogger(UnitedPayController.class);
    @Autowired
    private PayService payService;

    @RequestMapping(value={"/payHandler"}, produces={"text/html", "application/xhtml+xml"})
    public ModelAndView payRequestByHtml(UnitedPayRequest payRequest, HttpServletRequest httpServletRequest) {
        logger.info("payRequestByHtml...queryString:{}", (Object)httpServletRequest.getQueryString());
        ReturnResult returnResult = this.payService.processPayRequest(payRequest, httpServletRequest);
        logger.info("returnResult:{}", (Object)returnResult);
        return ResponseGenerator.generateResponse(returnResult, InterfaceReturnType.TYPE_HTML);
    }

    @RequestMapping(value={"/payHandler"}, produces={"application/xml"})
    public ModelAndView payRequestByXml(UnitedPayRequest payRequest, HttpServletRequest httpServletRequest) {
        logger.info("payRequestByXml...queryString:{}", (Object)httpServletRequest.getQueryString());
        ReturnResult returnResult = this.payService.processPayRequest(payRequest, httpServletRequest);
        logger.info("returnResult:{}", (Object)returnResult);
        return ResponseGenerator.generateResponse(returnResult, InterfaceReturnType.TYPE_XML);
    }

    @RequestMapping(value={"/payHandler"}, produces={"application/json"})
    public ModelAndView payRequestByJson(UnitedPayRequest payRequest, HttpServletRequest httpServletRequest) {
        logger.info("payRequestByJson...queryString:{}", (Object)httpServletRequest.getQueryString());
        ReturnResult returnResult = this.payService.processPayRequest(payRequest, httpServletRequest);
        logger.info("returnResult:{}", (Object)returnResult);
        return ResponseGenerator.generateResponse(returnResult, InterfaceReturnType.TYPE_JSON);
    }
}

