/*
 * Decompiled with CFR 0.152.
 */
package com.xunlei.channel.gateway.interf.controller.response;

import com.fasterxml.jackson.core.JsonEncoding;
import com.google.common.base.Strings;
import com.xunlei.channel.gateway.common.constants.InterfaceReqResult;
import com.xunlei.channel.gateway.common.constants.InterfaceReturnType;
import com.xunlei.channel.gateway.common.result.DirectPayResult;
import com.xunlei.channel.gateway.common.result.DirectReturnResult;
import com.xunlei.channel.gateway.common.result.RedirectGetResult;
import com.xunlei.channel.gateway.common.result.RedirectPostResult;
import com.xunlei.channel.gateway.common.result.ReturnResult;
import java.util.Map;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.View;
import org.springframework.web.servlet.view.json.MappingJackson2JsonView;
import org.springframework.web.servlet.view.xml.MappingJackson2XmlView;

public class ResponseGenerator {
    public static ModelAndView generateResponse(ReturnResult result, InterfaceReturnType returnType) {
        InterfaceReqResult isSuccess = result.getIsSuccess();
        String jspPath = result.getJspPath();
        if (result instanceof DirectReturnResult) {
            DirectReturnResult directReturnResult = (DirectReturnResult)result;
            if (InterfaceReturnType.TYPE_HTML.equals((Object)returnType)) {
                if (Strings.isNullOrEmpty((String)jspPath)) {
                    ModelAndView modelAndView = new ModelAndView("error_page");
                    return modelAndView;
                }
                if (isSuccess.equals((Object)InterfaceReqResult.FAIL)) {
                    ModelAndView modelAndView = new ModelAndView(jspPath);
                    modelAndView.addObject("result", (Object)directReturnResult);
                    return modelAndView;
                }
                return new ModelAndView(jspPath, "result", (Object)directReturnResult.getResult());
            }
            if (InterfaceReturnType.TYPE_JSON.equals((Object)returnType)) {
                return ResponseGenerator.generateJsonModelAndView(directReturnResult);
            }
            return ResponseGenerator.generateXmlModelAndView(directReturnResult);
        }
        if (result instanceof RedirectGetResult) {
            if (isSuccess.equals((Object)InterfaceReqResult.FAIL)) {
                if (Strings.isNullOrEmpty((String)jspPath)) {
                    ModelAndView modelAndView = new ModelAndView("error_page");
                    return modelAndView;
                }
                ModelAndView modelAndView = new ModelAndView(jspPath);
                modelAndView.addObject("result", (Object)result);
                return modelAndView;
            }
            ModelAndView modelAndView = new ModelAndView();
            modelAndView.setViewName("redirect:" + ((RedirectGetResult)result).getRedirectURL());
            return modelAndView;
        }
        if (result instanceof RedirectPostResult) {
            if (isSuccess.equals((Object)InterfaceReqResult.FAIL)) {
                if (Strings.isNullOrEmpty((String)jspPath)) {
                    ModelAndView modelAndView = new ModelAndView("error_page");
                    return modelAndView;
                }
                ModelAndView modelAndView = new ModelAndView(jspPath);
                modelAndView.addObject("result", (Object)result);
                return modelAndView;
            }
            ModelAndView modelAndView = new ModelAndView();
            modelAndView.setViewName(((RedirectPostResult)result).getJspPath());
            Map paramsMap = ((RedirectPostResult)result).getParamsMap();
            if (null != paramsMap) {
                modelAndView.addAllObjects(paramsMap);
            }
            return modelAndView;
        }
        if (result instanceof DirectPayResult) {
            ModelAndView modelAndView = new ModelAndView(((DirectPayResult)result).getJspPath());
            modelAndView.addAllObjects(((DirectPayResult)result).getAttributeMap());
            return modelAndView;
        }
        if (InterfaceReturnType.TYPE_HTML.equals((Object)returnType)) {
            if (Strings.isNullOrEmpty((String)jspPath)) {
                ModelAndView modelAndView = new ModelAndView("error_page");
                return modelAndView;
            }
            if (isSuccess.equals((Object)InterfaceReqResult.FAIL)) {
                ModelAndView modelAndView = new ModelAndView(jspPath);
                modelAndView.addObject("result", (Object)result);
                return modelAndView;
            }
            return new ModelAndView(jspPath, "result", (Object)result);
        }
        if (InterfaceReturnType.TYPE_JSON.equals((Object)returnType)) {
            return ResponseGenerator.generateJsonModelAndView(result);
        }
        return ResponseGenerator.generateXmlModelAndView(result);
    }

    private static ModelAndView generateJsonModelAndView(Object modelObj) {
        ModelAndView modelAndView = new ModelAndView();
        MappingJackson2JsonView view = new MappingJackson2JsonView();
        view.setExtractValueFromSingleKeyModel(true);
        view.setModelKey("modelObj");
        modelAndView.setView((View)view);
        modelAndView.addObject("modelObj", modelObj);
        return modelAndView;
    }

    private static ModelAndView generateXmlModelAndView(Object modelObj) {
        ModelAndView modelAndView = new ModelAndView();
        MappingJackson2XmlView view = new MappingJackson2XmlView();
        view.setModelKey("modelObj");
        view.setEncoding(JsonEncoding.UTF8);
        modelAndView.setView((View)view);
        modelAndView.addObject("modelObj", modelObj);
        return modelAndView;
    }
}

