/*
 * Decompiled with CFR 0.152.
 */
package com.xunlei.channel.gateway.interf.controller.channels;

import com.xunlei.channel.gateway.interf.controller.AbstractController;
import com.xunlei.channel.gateway.pay.channels.baiduwallet.BaiduNewUserResponse;
import com.xunlei.channel.gateway.pay.channels.baiduwallet.BaiduWalletService;
import com.xunlei.channel.gateway.pay.result.PageResult;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
public class BaiduWalletController
extends AbstractController {
    private static final Logger logger = LoggerFactory.getLogger(BaiduWalletController.class);
    @Autowired
    private BaiduWalletService baiduWalletService;

    @RequestMapping(value={"/baidu/return"})
    public String returnNotify(HttpServletRequest request, Model model) {
        logger.info("returnNotify...queryString:{}", (Object)request.getQueryString());
        String msg = this.baiduWalletService.returnNotify(request);
        model.addAttribute("msg", (Object)msg);
        return "channels/baiduwalletResponse";
    }

    @RequestMapping(value={"/baidu/page"})
    public String pageNotify(HttpServletRequest request, Model model) {
        logger.info("pageNotify...queryString:{}", (Object)request.getQueryString());
        PageResult pageResult = this.baiduWalletService.pageNotify(request);
        return this.generatePageResult(pageResult, model);
    }

    @RequestMapping(value={"/baidu/newUser"}, produces={"application/json"})
    @ResponseBody
    public BaiduNewUserResponse baiduNewUser(String bizNo, String xlpayId, String signMsg) {
        logger.info("baiduNewUser...bizNo:{},orderId:{},signMsg:{}", new Object[]{bizNo, xlpayId, signMsg});
        return this.baiduWalletService.processBaiduNewUser(bizNo, xlpayId, signMsg);
    }
}

