/*
 * Decompiled with CFR 0.152.
 */
package com.xunlei.channel.gateway.pay.pojo;

import com.google.common.base.Strings;
import com.xunlei.channel.gateway.common.annotation.PrimaryValidate;
import com.xunlei.channel.gateway.common.annotation.ValidateBizNo;
import com.xunlei.channel.gateway.common.annotation.ValidateSign;
import java.util.HashMap;
import java.util.Map;
import javax.validation.GroupSequence;
import javax.validation.constraints.Min;
import javax.validation.constraints.Pattern;
import javax.validation.constraints.Size;
import org.hibernate.validator.constraints.Length;
import org.hibernate.validator.constraints.NotEmpty;
import org.hibernate.validator.constraints.Range;
import org.hibernate.validator.constraints.URL;

@ValidateBizNo
@ValidateSign(groups={PrimaryValidate.class})
@GroupSequence(value={PrimaryValidate.class, UnitedPayRequest.class})
public class UnitedPayRequest {
    @Pattern(regexp="2.0.0", message="version should be 2.0.0")
    @NotEmpty(message="invalid version")
    private String version;
    @Length(min=1, max=1, message="invalid input_charset")
    private String inputCharset;
    @NotEmpty(message="invalid notify_url")
    @URL(regexp="(http://|https://){1}[\\w+&@#/%?=~_|!:,.;]+", message="invalid notify_url")
    @Size(max=255, min=1)
    private String notifyUrl;
    @Size(max=255, min=0, message="invalid page_url")
    private String pageUrl;
    @NotEmpty(message="invalid biz_no")
    @Length(max=9, min=9, message="invalid biz_no")
    private String bizNo;
    @NotEmpty(message="invalid biz_order_id")
    @Length(min=1, max=30, message="invalid biz_order_id")
    private String bizOrderId;
    @Range(max=9999999L, min=1L, message="invalid order_amt")
    private int orderAmt;
    @NotEmpty(message="invalid pay_type")
    @Length(min=1, max=2, message="invalid pay_type")
    private String payType;
    @Min(value=0L, message="invalid product_id")
    private long productId;
    @Pattern(regexp="[\u4e00-\u9fa5\\w-\\s]*", message="invalid product_name")
    @NotEmpty(message="invalid product_name")
    @Length(min=1, max=50, message="invalid product_name")
    private String productName;
    @Pattern(regexp="[\u4e00-\u9fa5a-zA-Z\\w-\\s]*", message="invalid product_desc")
    @NotEmpty(message="invalid product_desc")
    @Length(min=1, max=255, message="invalid product_desc")
    private String productDesc;
    @Length(min=1, max=30, message="invalid xunlei_id")
    private String xunleiId;
    @Length(min=1, max=64, message="invalid user_show")
    private String userShow;
    @Length(max=30, message="invalid peer_id")
    private String peerId;
    @NotEmpty(message="invalid sign_type")
    @Length(min=1, max=1, message="invalid sign_type")
    private String signType;
    @NotEmpty(message="invalid sign")
    private String sign;
    @NotEmpty(message="invalid client_ip")
    @Length(min=7, max=15, message="invalid client_ip")
    private String clientIp;
    private String extraCommonParam;
    private String extendParam;
    private String antiPhishingKey;
    private String needPhishingCheck;
    private Map<String, String> extraParamsMap = null;
    private String xunleiPayId;
    private String orderGroup;
    private String orderType;
    private String remark;
    private String realPayType;
    private String account;

    public void setExtendParam(String extendParam) {
        this.extendParam = extendParam;
    }

    public String getExtraParam(String key) {
        if (Strings.isNullOrEmpty((String)key)) {
            return null;
        }
        if (this.extraParamsMap == null) {
            this.extraParamsMap = new HashMap<String, String>();
        }
        return this.extraParamsMap.get(key);
    }

    public String getVersion() {
        return this.version;
    }

    public String getInputCharset() {
        return this.inputCharset;
    }

    public String getNotifyUrl() {
        return this.notifyUrl;
    }

    public String getPageUrl() {
        return this.pageUrl;
    }

    public String getBizNo() {
        return this.bizNo;
    }

    public String getBizOrderId() {
        return this.bizOrderId;
    }

    public int getOrderAmt() {
        return this.orderAmt;
    }

    public String getPayType() {
        return this.payType;
    }

    public long getProductId() {
        return this.productId;
    }

    public String getProductName() {
        return this.productName;
    }

    public String getProductDesc() {
        return this.productDesc;
    }

    public String getXunleiId() {
        return this.xunleiId;
    }

    public String getUserShow() {
        return this.userShow;
    }

    public String getPeerId() {
        return this.peerId;
    }

    public String getSignType() {
        return this.signType;
    }

    public String getSign() {
        return this.sign;
    }

    public String getClientIp() {
        return this.clientIp;
    }

    public String getExtraCommonParam() {
        return this.extraCommonParam;
    }

    public String getExtendParam() {
        return this.extendParam;
    }

    public String getAntiPhishingKey() {
        return this.antiPhishingKey;
    }

    public String getNeedPhishingCheck() {
        return this.needPhishingCheck;
    }

    public Map<String, String> getExtraParamsMap() {
        return this.extraParamsMap;
    }

    public String getXunleiPayId() {
        return this.xunleiPayId;
    }

    public String getOrderGroup() {
        return this.orderGroup;
    }

    public String getOrderType() {
        return this.orderType;
    }

    public String getRemark() {
        return this.remark;
    }

    public String getRealPayType() {
        return this.realPayType;
    }

    public String getAccount() {
        return this.account;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public void setInputCharset(String inputCharset) {
        this.inputCharset = inputCharset;
    }

    public void setNotifyUrl(String notifyUrl) {
        this.notifyUrl = notifyUrl;
    }

    public void setPageUrl(String pageUrl) {
        this.pageUrl = pageUrl;
    }

    public void setBizNo(String bizNo) {
        this.bizNo = bizNo;
    }

    public void setBizOrderId(String bizOrderId) {
        this.bizOrderId = bizOrderId;
    }

    public void setOrderAmt(int orderAmt) {
        this.orderAmt = orderAmt;
    }

    public void setPayType(String payType) {
        this.payType = payType;
    }

    public void setProductId(long productId) {
        this.productId = productId;
    }

    public void setProductName(String productName) {
        this.productName = productName;
    }

    public void setProductDesc(String productDesc) {
        this.productDesc = productDesc;
    }

    public void setXunleiId(String xunleiId) {
        this.xunleiId = xunleiId;
    }

    public void setUserShow(String userShow) {
        this.userShow = userShow;
    }

    public void setPeerId(String peerId) {
        this.peerId = peerId;
    }

    public void setSignType(String signType) {
        this.signType = signType;
    }

    public void setSign(String sign) {
        this.sign = sign;
    }

    public void setClientIp(String clientIp) {
        this.clientIp = clientIp;
    }

    public void setExtraCommonParam(String extraCommonParam) {
        this.extraCommonParam = extraCommonParam;
    }

    public void setAntiPhishingKey(String antiPhishingKey) {
        this.antiPhishingKey = antiPhishingKey;
    }

    public void setNeedPhishingCheck(String needPhishingCheck) {
        this.needPhishingCheck = needPhishingCheck;
    }

    public void setExtraParamsMap(Map<String, String> extraParamsMap) {
        this.extraParamsMap = extraParamsMap;
    }

    public void setXunleiPayId(String xunleiPayId) {
        this.xunleiPayId = xunleiPayId;
    }

    public void setOrderGroup(String orderGroup) {
        this.orderGroup = orderGroup;
    }

    public void setOrderType(String orderType) {
        this.orderType = orderType;
    }

    public void setRemark(String remark) {
        this.remark = remark;
    }

    public void setRealPayType(String realPayType) {
        this.realPayType = realPayType;
    }

    public void setAccount(String account) {
        this.account = account;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof UnitedPayRequest)) {
            return false;
        }
        UnitedPayRequest other = (UnitedPayRequest)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$version = this.getVersion();
        String other$version = other.getVersion();
        if (this$version == null ? other$version != null : !this$version.equals(other$version)) {
            return false;
        }
        String this$inputCharset = this.getInputCharset();
        String other$inputCharset = other.getInputCharset();
        if (this$inputCharset == null ? other$inputCharset != null : !this$inputCharset.equals(other$inputCharset)) {
            return false;
        }
        String this$notifyUrl = this.getNotifyUrl();
        String other$notifyUrl = other.getNotifyUrl();
        if (this$notifyUrl == null ? other$notifyUrl != null : !this$notifyUrl.equals(other$notifyUrl)) {
            return false;
        }
        String this$pageUrl = this.getPageUrl();
        String other$pageUrl = other.getPageUrl();
        if (this$pageUrl == null ? other$pageUrl != null : !this$pageUrl.equals(other$pageUrl)) {
            return false;
        }
        String this$bizNo = this.getBizNo();
        String other$bizNo = other.getBizNo();
        if (this$bizNo == null ? other$bizNo != null : !this$bizNo.equals(other$bizNo)) {
            return false;
        }
        String this$bizOrderId = this.getBizOrderId();
        String other$bizOrderId = other.getBizOrderId();
        if (this$bizOrderId == null ? other$bizOrderId != null : !this$bizOrderId.equals(other$bizOrderId)) {
            return false;
        }
        if (this.getOrderAmt() != other.getOrderAmt()) {
            return false;
        }
        String this$payType = this.getPayType();
        String other$payType = other.getPayType();
        if (this$payType == null ? other$payType != null : !this$payType.equals(other$payType)) {
            return false;
        }
        if (this.getProductId() != other.getProductId()) {
            return false;
        }
        String this$productName = this.getProductName();
        String other$productName = other.getProductName();
        if (this$productName == null ? other$productName != null : !this$productName.equals(other$productName)) {
            return false;
        }
        String this$productDesc = this.getProductDesc();
        String other$productDesc = other.getProductDesc();
        if (this$productDesc == null ? other$productDesc != null : !this$productDesc.equals(other$productDesc)) {
            return false;
        }
        String this$xunleiId = this.getXunleiId();
        String other$xunleiId = other.getXunleiId();
        if (this$xunleiId == null ? other$xunleiId != null : !this$xunleiId.equals(other$xunleiId)) {
            return false;
        }
        String this$userShow = this.getUserShow();
        String other$userShow = other.getUserShow();
        if (this$userShow == null ? other$userShow != null : !this$userShow.equals(other$userShow)) {
            return false;
        }
        String this$peerId = this.getPeerId();
        String other$peerId = other.getPeerId();
        if (this$peerId == null ? other$peerId != null : !this$peerId.equals(other$peerId)) {
            return false;
        }
        String this$signType = this.getSignType();
        String other$signType = other.getSignType();
        if (this$signType == null ? other$signType != null : !this$signType.equals(other$signType)) {
            return false;
        }
        String this$sign = this.getSign();
        String other$sign = other.getSign();
        if (this$sign == null ? other$sign != null : !this$sign.equals(other$sign)) {
            return false;
        }
        String this$clientIp = this.getClientIp();
        String other$clientIp = other.getClientIp();
        if (this$clientIp == null ? other$clientIp != null : !this$clientIp.equals(other$clientIp)) {
            return false;
        }
        String this$extraCommonParam = this.getExtraCommonParam();
        String other$extraCommonParam = other.getExtraCommonParam();
        if (this$extraCommonParam == null ? other$extraCommonParam != null : !this$extraCommonParam.equals(other$extraCommonParam)) {
            return false;
        }
        String this$extendParam = this.getExtendParam();
        String other$extendParam = other.getExtendParam();
        if (this$extendParam == null ? other$extendParam != null : !this$extendParam.equals(other$extendParam)) {
            return false;
        }
        String this$antiPhishingKey = this.getAntiPhishingKey();
        String other$antiPhishingKey = other.getAntiPhishingKey();
        if (this$antiPhishingKey == null ? other$antiPhishingKey != null : !this$antiPhishingKey.equals(other$antiPhishingKey)) {
            return false;
        }
        String this$needPhishingCheck = this.getNeedPhishingCheck();
        String other$needPhishingCheck = other.getNeedPhishingCheck();
        if (this$needPhishingCheck == null ? other$needPhishingCheck != null : !this$needPhishingCheck.equals(other$needPhishingCheck)) {
            return false;
        }
        Map<String, String> this$extraParamsMap = this.getExtraParamsMap();
        Map<String, String> other$extraParamsMap = other.getExtraParamsMap();
        if (this$extraParamsMap == null ? other$extraParamsMap != null : !((Object)this$extraParamsMap).equals(other$extraParamsMap)) {
            return false;
        }
        String this$xunleiPayId = this.getXunleiPayId();
        String other$xunleiPayId = other.getXunleiPayId();
        if (this$xunleiPayId == null ? other$xunleiPayId != null : !this$xunleiPayId.equals(other$xunleiPayId)) {
            return false;
        }
        String this$orderGroup = this.getOrderGroup();
        String other$orderGroup = other.getOrderGroup();
        if (this$orderGroup == null ? other$orderGroup != null : !this$orderGroup.equals(other$orderGroup)) {
            return false;
        }
        String this$orderType = this.getOrderType();
        String other$orderType = other.getOrderType();
        if (this$orderType == null ? other$orderType != null : !this$orderType.equals(other$orderType)) {
            return false;
        }
        String this$remark = this.getRemark();
        String other$remark = other.getRemark();
        if (this$remark == null ? other$remark != null : !this$remark.equals(other$remark)) {
            return false;
        }
        String this$realPayType = this.getRealPayType();
        String other$realPayType = other.getRealPayType();
        if (this$realPayType == null ? other$realPayType != null : !this$realPayType.equals(other$realPayType)) {
            return false;
        }
        String this$account = this.getAccount();
        String other$account = other.getAccount();
        return !(this$account == null ? other$account != null : !this$account.equals(other$account));
    }

    protected boolean canEqual(Object other) {
        return other instanceof UnitedPayRequest;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $version = this.getVersion();
        result = result * 59 + ($version == null ? 43 : $version.hashCode());
        String $inputCharset = this.getInputCharset();
        result = result * 59 + ($inputCharset == null ? 43 : $inputCharset.hashCode());
        String $notifyUrl = this.getNotifyUrl();
        result = result * 59 + ($notifyUrl == null ? 43 : $notifyUrl.hashCode());
        String $pageUrl = this.getPageUrl();
        result = result * 59 + ($pageUrl == null ? 43 : $pageUrl.hashCode());
        String $bizNo = this.getBizNo();
        result = result * 59 + ($bizNo == null ? 43 : $bizNo.hashCode());
        String $bizOrderId = this.getBizOrderId();
        result = result * 59 + ($bizOrderId == null ? 43 : $bizOrderId.hashCode());
        result = result * 59 + this.getOrderAmt();
        String $payType = this.getPayType();
        result = result * 59 + ($payType == null ? 43 : $payType.hashCode());
        long $productId = this.getProductId();
        result = result * 59 + (int)($productId >>> 32 ^ $productId);
        String $productName = this.getProductName();
        result = result * 59 + ($productName == null ? 43 : $productName.hashCode());
        String $productDesc = this.getProductDesc();
        result = result * 59 + ($productDesc == null ? 43 : $productDesc.hashCode());
        String $xunleiId = this.getXunleiId();
        result = result * 59 + ($xunleiId == null ? 43 : $xunleiId.hashCode());
        String $userShow = this.getUserShow();
        result = result * 59 + ($userShow == null ? 43 : $userShow.hashCode());
        String $peerId = this.getPeerId();
        result = result * 59 + ($peerId == null ? 43 : $peerId.hashCode());
        String $signType = this.getSignType();
        result = result * 59 + ($signType == null ? 43 : $signType.hashCode());
        String $sign = this.getSign();
        result = result * 59 + ($sign == null ? 43 : $sign.hashCode());
        String $clientIp = this.getClientIp();
        result = result * 59 + ($clientIp == null ? 43 : $clientIp.hashCode());
        String $extraCommonParam = this.getExtraCommonParam();
        result = result * 59 + ($extraCommonParam == null ? 43 : $extraCommonParam.hashCode());
        String $extendParam = this.getExtendParam();
        result = result * 59 + ($extendParam == null ? 43 : $extendParam.hashCode());
        String $antiPhishingKey = this.getAntiPhishingKey();
        result = result * 59 + ($antiPhishingKey == null ? 43 : $antiPhishingKey.hashCode());
        String $needPhishingCheck = this.getNeedPhishingCheck();
        result = result * 59 + ($needPhishingCheck == null ? 43 : $needPhishingCheck.hashCode());
        Map<String, String> $extraParamsMap = this.getExtraParamsMap();
        result = result * 59 + ($extraParamsMap == null ? 43 : ((Object)$extraParamsMap).hashCode());
        String $xunleiPayId = this.getXunleiPayId();
        result = result * 59 + ($xunleiPayId == null ? 43 : $xunleiPayId.hashCode());
        String $orderGroup = this.getOrderGroup();
        result = result * 59 + ($orderGroup == null ? 43 : $orderGroup.hashCode());
        String $orderType = this.getOrderType();
        result = result * 59 + ($orderType == null ? 43 : $orderType.hashCode());
        String $remark = this.getRemark();
        result = result * 59 + ($remark == null ? 43 : $remark.hashCode());
        String $realPayType = this.getRealPayType();
        result = result * 59 + ($realPayType == null ? 43 : $realPayType.hashCode());
        String $account = this.getAccount();
        result = result * 59 + ($account == null ? 43 : $account.hashCode());
        return result;
    }

    public String toString() {
        return "UnitedPayRequest(version=" + this.getVersion() + ", inputCharset=" + this.getInputCharset() + ", notifyUrl=" + this.getNotifyUrl() + ", pageUrl=" + this.getPageUrl() + ", bizNo=" + this.getBizNo() + ", bizOrderId=" + this.getBizOrderId() + ", orderAmt=" + this.getOrderAmt() + ", payType=" + this.getPayType() + ", productId=" + this.getProductId() + ", productName=" + this.getProductName() + ", productDesc=" + this.getProductDesc() + ", xunleiId=" + this.getXunleiId() + ", userShow=" + this.getUserShow() + ", peerId=" + this.getPeerId() + ", signType=" + this.getSignType() + ", sign=" + this.getSign() + ", clientIp=" + this.getClientIp() + ", extraCommonParam=" + this.getExtraCommonParam() + ", extendParam=" + this.getExtendParam() + ", antiPhishingKey=" + this.getAntiPhishingKey() + ", needPhishingCheck=" + this.getNeedPhishingCheck() + ", extraParamsMap=" + this.getExtraParamsMap() + ", xunleiPayId=" + this.getXunleiPayId() + ", orderGroup=" + this.getOrderGroup() + ", orderType=" + this.getOrderType() + ", remark=" + this.getRemark() + ", realPayType=" + this.getRealPayType() + ", account=" + this.getAccount() + ")";
    }
}

