/*
 * Decompiled with CFR 0.152.
 */
package com.xunlei.channel.gateway.common.utils;

import com.google.common.base.Strings;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Properties;
import java.util.ResourceBundle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class XunleiPayIdUtils {
    private static final Logger logger = LoggerFactory.getLogger(XunleiPayIdUtils.class);
    private static final int XUNLEI_PAY_ID_LENGTH = 20;
    private static String MAC_ID = "01";
    private static int SE = 0;

    private XunleiPayIdUtils() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void init() {
        InputStream is = null;
        File file = null;
        try {
            ResourceBundle resource = ResourceBundle.getBundle("macinfo");
            String fileName = resource.getString("fileName");
            if (null != fileName && !"".equals(fileName)) {
                file = new File(fileName);
                Properties prop = new Properties();
                is = new FileInputStream(file);
                prop.load(is);
                MAC_ID = prop.getProperty("macid");
            }
        }
        catch (Exception ex) {
            logger.error("parse macinfo with exception:" + ex.getMessage(), (Throwable)ex);
        }
        finally {
            if (null != is) {
                try {
                    is.close();
                }
                catch (IOException e) {
                    logger.error(e.getMessage(), (Throwable)e);
                }
                file = null;
            }
        }
    }

    public static synchronized String generateXunleiPayId() {
        String yyyymmdd;
        SimpleDateFormat shortdf = new SimpleDateFormat("yyyyMMdd");
        String nextOrderId = "";
        if (SE > 99) {
            SE = 0;
        }
        if ((nextOrderId = (yyyymmdd = shortdf.format(new Date())).substring(2, 8) + XunleiPayIdUtils.getTradeSn().substring(3, 13) + MAC_ID + XunleiPayIdUtils.createSerial("" + SE, 2)).length() != 20) {
            logger.error("Error,generate xunleiPayId failed:{}", (Object)nextOrderId);
        }
        ++SE;
        return nextOrderId;
    }

    public static String getTradeSn() {
        return "" + new Date().getTime();
    }

    public static String createSerial(String src, int len) {
        String dest = "";
        dest = src.length() >= len ? src.substring(0, len) : XunleiPayIdUtils.createSameChar("0", len - src.length()) + src;
        return dest;
    }

    public static String createSameChar(String src, int len) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < len; ++i) {
            sb.append(src);
        }
        return sb.toString();
    }

    public static boolean isOwnXunleiPayId(String xunleiPayId) {
        if (Strings.isNullOrEmpty((String)xunleiPayId)) {
            return false;
        }
        if (xunleiPayId.length() != 20) {
            return false;
        }
        String theMacId = xunleiPayId.substring(16, 18);
        return MAC_ID.equals(theMacId);
    }

    static {
        XunleiPayIdUtils.init();
    }
}

