/*
 * Decompiled with CFR 0.152.
 */
package com.xunlei.channel.gateway.common.utils;

import java.net.URLEncoder;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UrlUtils {
    private static final Logger logger = LoggerFactory.getLogger(UrlUtils.class);

    private UrlUtils() {
    }

    public static String buildUrlParams(Map<String, String> map, String charset) {
        if (map == null || map.isEmpty()) {
            return "";
        }
        StringBuilder url = new StringBuilder();
        for (String key : map.keySet()) {
            url.append(key).append("=").append(UrlUtils.encodeUrl(map.get(key), charset)).append("&");
        }
        return url.substring(0, url.length() - 1);
    }

    public static String encodeUrl(String content, String charset) {
        try {
            return URLEncoder.encode(content, charset);
        }
        catch (Exception ex) {
            logger.error(ex.getMessage(), (Throwable)ex);
            return null;
        }
    }
}

