/*
 * Decompiled with CFR 0.152.
 */
package com.xunlei.channel.gateway.common.utils;

import com.google.common.base.Strings;
import java.util.HashMap;
import java.util.Map;

public class StringUtils {
    private StringUtils() {
    }

    public static String mergeStrings(String splitStr, String ... strs) {
        if (null == strs || strs.length == 0 || Strings.isNullOrEmpty((String)splitStr)) {
            return "";
        }
        if (strs.length == 1) {
            return strs[0];
        }
        StringBuilder sb = new StringBuilder();
        for (String s : strs) {
            sb.append(s).append(splitStr);
        }
        return sb.substring(0, sb.length() - splitStr.length());
    }

    public static String mapToStr(Map<String, String> map, String splitStr) {
        if (map == null || map.isEmpty()) {
            return "";
        }
        if (Strings.isNullOrEmpty((String)splitStr) || splitStr.contains("=")) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        for (Map.Entry<String, String> entry : map.entrySet()) {
            sb.append(entry.getKey()).append("=").append(entry.getValue()).append(splitStr);
        }
        return sb.substring(0, sb.length() - splitStr.length());
    }

    public static Map<String, String> StringToMap(String str, String splitStrRegex) {
        String[] tempArr;
        HashMap<String, String> map = new HashMap<String, String>();
        if (Strings.isNullOrEmpty((String)str) || Strings.isNullOrEmpty((String)splitStrRegex)) {
            return map;
        }
        for (String temp : tempArr = str.split(splitStrRegex)) {
            int index = temp.indexOf("=");
            if (index <= 0) continue;
            String key = temp.substring(0, index);
            String value = temp.substring(index + 1);
            map.put(key, value);
        }
        return map;
    }

    public static boolean isAnyNullOrEmpty(String ... strs) {
        if (strs == null) {
            return true;
        }
        for (String s : strs) {
            if (!Strings.isNullOrEmpty((String)s)) continue;
            return true;
        }
        return false;
    }
}

