/*
 * Decompiled with CFR 0.152.
 */
package com.xunlei.channel.gateway.common.utils;

import com.google.common.base.Strings;
import com.xunlei.channel.gateway.common.utils.MD5Utils;
import java.util.Map;
import java.util.TreeSet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SignatureUtils {
    private static final Logger logger = LoggerFactory.getLogger(SignatureUtils.class);

    private SignatureUtils() {
    }

    public static boolean checkSign(Map<String, String> paramMap, String privateKey, String signKey) {
        if (Strings.isNullOrEmpty((String)privateKey) || paramMap == null) {
            return false;
        }
        String signMsg = paramMap.get(signKey);
        if (Strings.isNullOrEmpty((String)signMsg)) {
            return false;
        }
        String signed = SignatureUtils.sign(paramMap, privateKey, signKey);
        logger.debug("signMsg = {},signed ={}", (Object)signMsg, (Object)signed);
        boolean result = signMsg.equalsIgnoreCase(signed);
        if (!result) {
            logger.info("sign mismatch,signMsg = {},signed ={}", (Object)signMsg, (Object)signed);
        }
        return result;
    }

    public static String sign(Map<String, String> param, String privateKey, String signKey) {
        String content = SignatureUtils.getSignatureContent(param, signKey);
        logger.info("merged content:{}", (Object)content);
        return SignatureUtils.sign(content, privateKey);
    }

    private static String sign(String content, String privateKey) {
        if (content == null) {
            return null;
        }
        logger.debug("content final:{}", (Object)(content + privateKey));
        return MD5Utils.getMD5Str(content + privateKey);
    }

    private static String getSignatureContent(Map<String, String> paramMap, String signKey) {
        TreeSet<String> keySet = new TreeSet<String>();
        for (String key : paramMap.keySet()) {
            String value;
            if (key.equals(signKey) || Strings.isNullOrEmpty((String)(value = paramMap.get(key)))) continue;
            keySet.add(key);
        }
        StringBuilder sb = new StringBuilder();
        for (String key : keySet) {
            String value = paramMap.get(key);
            sb.append(key).append("=").append(value).append("&");
        }
        return sb.substring(0, sb.length() - 1);
    }
}

