/*
 * Decompiled with CFR 0.152.
 */
package com.xunlei.channel.gateway.common.utils;

import com.google.common.base.Strings;
import com.xunlei.channel.db.pojo.PayOrderOk;
import com.xunlei.channel.gateway.common.utils.SignatureUtils;
import com.xunlei.channel.gateway.common.utils.StringUtils;
import com.xunlei.channel.gateway.common.utils.UrlUtils;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NoticeUtils {
    private static final String VERSION_ONE_RESULT = "<xlresult>\\s*(Y)\\s*</xlresult>";
    private static final Logger logger = LoggerFactory.getLogger(NoticeUtils.class);

    private NoticeUtils() {
    }

    public static boolean isNoticeSuccess(String response, String version) {
        if (Strings.isNullOrEmpty((String)response) || Strings.isNullOrEmpty((String)version)) {
            return false;
        }
        if ("2.0.0".equals(version)) {
            return "Y".equals(response);
        }
        return NoticeUtils.isVersionOneResponseSuccess(response);
    }

    public static boolean isVersionOneResponseSuccess(String response) {
        if (Strings.isNullOrEmpty((String)response)) {
            return false;
        }
        int preIndex = response.indexOf("<xlresult>");
        int endIndex = response.lastIndexOf("</xlresult>");
        if (preIndex < 0 || endIndex < 0 || preIndex > endIndex) {
            return false;
        }
        String resp = response.substring(preIndex, endIndex + 11);
        Pattern xmlPattern = Pattern.compile(VERSION_ONE_RESULT);
        return xmlPattern.matcher(resp).matches();
    }

    public static String generateUrlParams(PayOrderOk payOrderOk, String payResult, String bizKey) {
        if (null == payOrderOk || null == payResult) {
            logger.info("error,payOrderOk or payResult is null,return empty");
            return "";
        }
        if ("2.0.0".equals(payOrderOk.getVersion())) {
            return NoticeUtils.generateVersionTwoUrlParams(payOrderOk, payResult, bizKey);
        }
        if ("v1.0".equals(payOrderOk.getVersion())) {
            return NoticeUtils.generateVersionOneUrlParams(payOrderOk, payResult, bizKey);
        }
        return NoticeUtils.generateVersionOneUrlParams(payOrderOk, payResult, bizKey);
    }

    private static String generateVersionOneUrlParams(PayOrderOk payOrderOk, String payResult, String bizKey) {
        logger.debug("generateVersionOneUrlParams");
        if (null == payOrderOk) {
            return "";
        }
        String charset = "UTF-8";
        if ("B".equals(payOrderOk.getPageCharset())) {
            charset = "GBK";
        }
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("version", payOrderOk.getVersion());
        map.put("orderId", payOrderOk.getBizOrderId());
        map.put("orderAmt", payOrderOk.getOrderAmt() + "");
        map.put("xlpayId", payOrderOk.getXunleiPayId());
        map.put("xlpayTime", NoticeUtils.formatOrderTime(payOrderOk.getCreateTime()));
        Map<String, String> extraMap = StringUtils.StringToMap(payOrderOk.getBizExt(), "\\^");
        map.put("ext1", extraMap.containsKey("ext1") ? extraMap.get("ext1") : "");
        map.put("ext2", extraMap.containsKey("ext2") ? extraMap.get("ext2") : "");
        map.put("orderTime", extraMap.containsKey("orderTime") ? extraMap.get("orderTime") : NoticeUtils.formatOrderTime(payOrderOk.getReqTime()));
        map.put("errCode", "");
        map.put("payResult", payResult);
        return UrlUtils.buildUrlParams(map, charset) + "&fareamt=" + payOrderOk.getFareAmt() + "&signMsg=" + SignatureUtils.sign(map, bizKey, "sign");
    }

    private static String formatOrderTime(Date date) {
        if (null == date) {
            return "";
        }
        SimpleDateFormat format = new SimpleDateFormat("yyyyMMddHHmmss");
        return format.format(date);
    }

    private static String formatOrderTime(String orderTime) {
        if (Strings.isNullOrEmpty((String)orderTime)) {
            return "";
        }
        return orderTime.replace("-", "").replace(":", "").replace(" ", "");
    }

    private static String generateVersionTwoUrlParams(PayOrderOk payOrderOk, String payResult, String bizKey) {
        logger.debug("generateVersionTwoUrlParams");
        return NoticeUtils.generateVersionOneUrlParams(payOrderOk, payResult, bizKey);
    }

    public static String buildVersionOnePageUrl(String pageCharset, String pageUrl, String version, String orderId, int orderAmt, String orderTime, String xunleiPayId, Date payTime, String ext1, String ext2, String payResult, String errCode, String bizKey, int fareAmt) {
        if (Strings.isNullOrEmpty((String)pageUrl)) {
            return "";
        }
        String charset = "UTF-8";
        if ("B".equals(pageCharset)) {
            charset = "GBK";
        }
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("version", version);
        map.put("orderId", orderId);
        map.put("orderAmt", orderAmt + "");
        map.put("orderTime", NoticeUtils.formatOrderTime(orderTime));
        map.put("xlpayId", xunleiPayId);
        map.put("xlpayTime", NoticeUtils.formatOrderTime(payTime));
        map.put("ext1", ext1);
        map.put("ext2", ext2);
        map.put("errCode", errCode);
        map.put("payResult", payResult);
        HashMap<String, String> map2 = new HashMap<String, String>();
        map2.put("version", version);
        map2.put("orderId", orderId);
        map2.put("orderAmt", orderAmt + "");
        map2.put("orderTime", NoticeUtils.formatOrderTime(orderTime));
        map2.put("xlpayId", xunleiPayId);
        map2.put("xlpayTime", NoticeUtils.formatOrderTime(payTime));
        map2.put("ext1", ext1);
        map2.put("ext2", ext2);
        map2.put("errCode", errCode);
        map2.put("payResult", payResult);
        map2.put("fareamt", fareAmt + "");
        String urlJoin = "?";
        if (pageUrl.indexOf("?") >= 0) {
            urlJoin = "&";
        }
        return pageUrl + urlJoin + UrlUtils.buildUrlParams(map2, charset) + "&signMsg=" + SignatureUtils.sign(map, bizKey, "sign");
    }

    public static String buildPageUrlInfo(String pageCharset, String pageUrl, String version, String bizOrderId, int orderAmt, String orderTime, String xunleiPayId, Date payTime, String bizExtra, String payResult, String errorCode, String bizKey, int fareAmt) {
        if ("2.0.0".equals(version)) {
            logger.info("Version2 page url...");
            Map<String, String> extraMap = StringUtils.StringToMap(bizExtra, "\\^");
            String ext1 = null == extraMap.get("ext1") ? "" : extraMap.get("ext1");
            String ext2 = null == extraMap.get("ext2") ? "" : extraMap.get("ext2");
            return NoticeUtils.buildVersionOnePageUrl(pageCharset, pageUrl, version, bizOrderId, orderAmt, orderTime, xunleiPayId, payTime, ext1, ext2, payResult, errorCode, bizKey, fareAmt);
        }
        logger.info("Version1 page url...");
        Map<String, String> extraMap = StringUtils.StringToMap(bizExtra, "\\^");
        String ext1 = null == extraMap.get("ext1") ? "" : extraMap.get("ext1");
        String ext2 = null == extraMap.get("ext2") ? "" : extraMap.get("ext2");
        return NoticeUtils.buildVersionOnePageUrl(pageCharset, pageUrl, version, bizOrderId, orderAmt, orderTime, xunleiPayId, payTime, ext1, ext2, payResult, errorCode, bizKey, fareAmt);
    }
}

