/*
 * Decompiled with CFR 0.152.
 */
package com.xunlei.channel.gateway.common.utils;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Map;
import org.apache.http.HttpEntity;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.fluent.Request;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpUtils {
    private static final String DEFAULT_CHARSET = "utf8";
    private static final int DEFAULT_CONNECT_TIMEOUT = 3000;
    private static final int DEFAULT_SOCKET_TIMEOUT = 3000;
    private static final Logger logger = LoggerFactory.getLogger(HttpUtils.class);

    private HttpUtils() {
    }

    public static String doGet(String url) throws ClientProtocolException, IOException {
        logger.info("doGet...url:{}", (Object)url);
        return HttpUtils.doGet(url, 3000, 3000);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String doGet(String url, int socketTimeout, int connectTimeout) throws ClientProtocolException, IOException {
        CloseableHttpClient httpclient = HttpClients.createDefault();
        try {
            String string;
            HttpGet httpGet = new HttpGet(url);
            RequestConfig defaultRequestConfig = RequestConfig.custom().setConnectTimeout(connectTimeout).setSocketTimeout(socketTimeout).build();
            logger.info("begin to get url:{}", (Object)url);
            httpGet.setConfig(defaultRequestConfig);
            CloseableHttpResponse response = httpclient.execute((HttpUriRequest)httpGet);
            try {
                logger.info("response status:{}", (Object)response.getStatusLine());
                HttpEntity entity = response.getEntity();
                string = EntityUtils.toString((HttpEntity)entity, (String)DEFAULT_CHARSET);
            }
            catch (Throwable throwable) {
                response.close();
                throw throwable;
            }
            response.close();
            return string;
        }
        finally {
            httpclient.close();
        }
    }

    public static String doFluentGet(String url) throws ClientProtocolException, IOException {
        return Request.Get((String)url).connectTimeout(3000).socketTimeout(3000).execute().returnContent().asString();
    }

    public static String doPost(String url, Map<String, String> paramsMap) throws ClientProtocolException, IOException {
        return HttpUtils.doPost(url, paramsMap, 3000, 3000);
    }

    public static String doPost(String url, Map<String, String> paramsMap, int connectTimeout, int socketTimeout) throws ClientProtocolException, IOException {
        return HttpUtils.doPostWithCharsets(url, paramsMap, connectTimeout, socketTimeout, DEFAULT_CHARSET, DEFAULT_CHARSET);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String doPostWithCharsets(String url, Map<String, String> paramsMap, int connectTimeout, int socketTimeout, String requestCharset, String responseCharset) throws ClientProtocolException, IOException {
        logger.info("doPost...url:{},params:{}", (Object)url, paramsMap);
        CloseableHttpClient httpclient = HttpClients.createDefault();
        try {
            String string;
            HttpPost httpPost = new HttpPost(url);
            RequestConfig defaultRequestConfig = RequestConfig.custom().setConnectTimeout(connectTimeout).setSocketTimeout(socketTimeout).build();
            httpPost.setConfig(defaultRequestConfig);
            if (null != paramsMap) {
                ArrayList<BasicNameValuePair> nvps = new ArrayList<BasicNameValuePair>();
                for (Map.Entry<String, String> entry : paramsMap.entrySet()) {
                    nvps.add(new BasicNameValuePair(entry.getKey(), entry.getValue()));
                }
                httpPost.setEntity((HttpEntity)new UrlEncodedFormEntity(nvps, requestCharset));
            }
            CloseableHttpResponse response = httpclient.execute((HttpUriRequest)httpPost);
            try {
                logger.info("response status:{}", (Object)response.getStatusLine());
                HttpEntity entity = response.getEntity();
                string = EntityUtils.toString((HttpEntity)entity, (String)responseCharset);
            }
            catch (Throwable throwable) {
                response.close();
                throw throwable;
            }
            response.close();
            return string;
        }
        finally {
            httpclient.close();
        }
    }
}

