/*
 * Decompiled with CFR 0.152.
 */
package com.xunlei.channel.gateway.common.cbin;

import com.google.common.base.Strings;
import com.xunlei.channel.gateway.common.cbin.DefaultResp;
import com.xunlei.channel.gateway.common.cbin.Req;
import com.xunlei.channel.gateway.common.cbin.Resp;
import com.xunlei.channel.gateway.common.cbin.Row;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.reflect.Field;
import java.net.Socket;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RecordCodec {
    private static final Charset charset = Charset.forName("GBK");
    private static Logger logger = LoggerFactory.getLogger(RecordCodec.class);

    public static Resp decode(DataInputStream in, Resp decodeResult) throws Exception {
        StringBuilder info = new StringBuilder();
        int recordLen = in.readInt();
        info.append(recordLen).append("->");
        int remainRecordLen = recordLen - 4;
        if (remainRecordLen > 0) {
            int fieldLen;
            int rowLen = in.readInt();
            info.append("[").append(rowLen).append(" ");
            remainRecordLen -= 4 + rowLen;
            HashMap<String, String> fieldMap = new HashMap<String, String>();
            for (int remainRowLen = rowLen; remainRowLen > 0; remainRowLen -= 4 + fieldLen) {
                fieldLen = in.readInt();
                int nameLen = in.readInt();
                byte[] name = new byte[nameLen];
                in.readFully(name);
                String fieldName = new String(name);
                int valueLen = in.readInt();
                if (fieldLen != 8 + nameLen + valueLen) {
                    throw new IllegalStateException("fieldLen != 8 + nameLen + valueLen: fieldLen=" + fieldLen + ",nameLen=" + nameLen + ",valueLen" + valueLen);
                }
                byte[] value = new byte[valueLen];
                in.readFully(value);
                String filedValue = new String(value, charset);
                fieldMap.put(fieldName, filedValue);
                info.append(" ").append(fieldLen).append("|").append(nameLen).append("|").append(fieldName).append(":").append(filedValue);
            }
            info.append("]");
            try {
                Resp r = decodeResult;
                Class<?> clazz = r.getClass();
                for (Map.Entry entry : fieldMap.entrySet()) {
                    String fieldName = (String)entry.getKey();
                    String fieldValue = (String)entry.getValue();
                    if (Strings.isNullOrEmpty((String)fieldValue)) continue;
                    try {
                        Field f = clazz.getDeclaredField(fieldName);
                        f.setAccessible(true);
                        if (f.getType() == String.class) {
                            f.set(r, fieldValue);
                            continue;
                        }
                        if (f.getType() == Integer.TYPE) {
                            f.set(r, Integer.valueOf(fieldValue));
                            continue;
                        }
                        if (f.getType() == Long.TYPE) {
                            f.set(r, Long.valueOf(fieldValue));
                            continue;
                        }
                        if (f.getType() == Boolean.TYPE) {
                            if (fieldValue.equalsIgnoreCase("true") || fieldValue.equalsIgnoreCase("y") || fieldValue.equals("1")) {
                                f.set(r, true);
                                continue;
                            }
                            f.set(r, false);
                            continue;
                        }
                        if (f.getType() == Float.TYPE) {
                            f.set(r, Float.valueOf(fieldValue));
                            continue;
                        }
                        if (f.getType() == Double.TYPE) {
                            f.set(r, Double.valueOf(fieldValue));
                            continue;
                        }
                        if (f.getType() == Byte.TYPE) {
                            f.set(r, Byte.valueOf(fieldValue));
                            continue;
                        }
                        if (f.getType() != Short.TYPE) continue;
                        f.set(r, Short.valueOf(fieldValue));
                    }
                    catch (Exception e) {
                        logger.error("clazz:{},field:{},fieldValue:{}", new Object[]{r.getClass().getSimpleName(), fieldName, fieldValue, e});
                    }
                }
            }
            catch (IndexOutOfBoundsException e) {
                logger.error("fieldMap:{}", fieldMap, (Object)e);
            }
            if (remainRecordLen > 0) {
                logger.warn("not fully parse resp,remainRecordLen={}", (Object)remainRecordLen);
            }
        }
        decodeResult.setRespMessage(info.toString());
        return decodeResult;
    }

    public static ByteBuffer encode(Row row) {
        int recordLen = 4;
        ByteBuffer rowBuf = RecordCodec.encodeRow(row);
        ByteBuffer recordBuf = ByteBuffer.allocate(recordLen += rowBuf.capacity());
        recordBuf.putInt(recordLen);
        recordBuf.put(rowBuf.array());
        return recordBuf;
    }

    private static ByteBuffer encodeField(Field f, Object obj) throws IllegalArgumentException, IllegalAccessException {
        f.setAccessible(true);
        if (Map.class.isAssignableFrom(f.getType())) {
            Map map = (Map)f.get(obj);
            Set es = map.entrySet();
            int rowLen = 0;
            ArrayList<ByteBuffer> filedBufs = new ArrayList<ByteBuffer>(map.size());
            for (Map.Entry entry : es) {
                try {
                    String field = entry.getKey().toString();
                    String value = entry.getValue().toString();
                    ByteBuffer fieldBuf = RecordCodec.encodeField1(field.getBytes(), value.getBytes());
                    filedBufs.add(fieldBuf);
                    rowLen += fieldBuf.capacity();
                }
                catch (Exception e) {
                    logger.error("", (Throwable)e);
                }
            }
            ByteBuffer allBuf = ByteBuffer.allocate(rowLen);
            for (ByteBuffer filedBuf : filedBufs) {
                allBuf.put(filedBuf.array());
            }
            return allBuf;
        }
        String fieldName = f.getName();
        byte[] name = fieldName.getBytes();
        Object fieldValueObj = f.get(obj);
        String fieldValue = fieldValueObj != null ? fieldValueObj.toString() : "";
        byte[] value = fieldValue.getBytes();
        return RecordCodec.encodeField1(name, value);
    }

    private static ByteBuffer encodeField1(byte[] name, byte[] value) {
        int nameLen = name.length;
        int valueLen = value.length;
        int fieldLen = 8 + nameLen + valueLen;
        ByteBuffer fieldBuf = ByteBuffer.allocate(4 + fieldLen);
        fieldBuf.putInt(fieldLen);
        fieldBuf.putInt(nameLen);
        fieldBuf.put(name);
        fieldBuf.putInt(valueLen);
        fieldBuf.put(value);
        return fieldBuf;
    }

    private static ByteBuffer encodeRow(Row r) {
        Class<?> clazz = r.getClass();
        Field[] fields = clazz.getDeclaredFields();
        int rowLen = 0;
        ArrayList<ByteBuffer> filedBufs = new ArrayList<ByteBuffer>(fields.length);
        Field[] afield = fields;
        int j = fields.length;
        for (int i = 0; i < j; ++i) {
            Field f = afield[i];
            try {
                ByteBuffer fieldBuf = RecordCodec.encodeField(f, r);
                filedBufs.add(fieldBuf);
                rowLen += fieldBuf.capacity();
                continue;
            }
            catch (Exception e) {
                logger.error("", (Throwable)e);
            }
        }
        ByteBuffer rowBuf = ByteBuffer.allocate(4 + rowLen);
        rowBuf.putInt(rowLen);
        for (ByteBuffer filedBuf : filedBufs) {
            rowBuf.put(filedBuf.array());
        }
        return rowBuf;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void send(String host, int port, int timeout, Req req, DefaultResp resp) {
        Socket client = null;
        FilterInputStream in = null;
        OutputStream out = null;
        boolean resultOk = false;
        try {
            client = new Socket(host, port);
            client.setSoTimeout(timeout);
            out = new DataOutputStream(client.getOutputStream());
            ByteBuffer buffer = RecordCodec.encode(req);
            out.write(buffer.array());
            out.flush();
            in = new DataInputStream(client.getInputStream());
            RecordCodec.decode((DataInputStream)in, resp);
            resultOk = resp.isOk();
            if (resultOk) {
                logger.debug("{}[{}:{}],req:{},result:{}", new Object[]{req.getRequest(), host, port, req, resp.getResult()});
            } else {
                logger.error("{}[{}:{}],req:{},result:{},resp:{}", new Object[]{req.getRequest(), host, port, req, resp.getResult(), resp.getRespMessage()});
            }
        }
        catch (Exception e) {
            logger.error("", (Throwable)e);
        }
        finally {
            try {
                if (null != out) {
                    out.close();
                }
                if (null != in) {
                    in.close();
                }
                if (null != client) {
                    client.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }
}

