package com.xunlei.channel.db.utils;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.beans.PropertyDescriptor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;

/**
 * Created by liyang on 2016/3/14.
 */
public class DateTimeUtils {

    private final static Logger logger = LoggerFactory.getLogger(DateTimeUtils.class);
    private static final String DATEPATTERN = "yyyy-MM-dd";
    private static final String DATEFORMAT = "yyMMdd";

    /**
     * 初始化日期分片字段
     */
    public static String initRuleDate() {
        return (new SimpleDateFormat(DATEPATTERN)).format(new Date());
    }

    /**
     * 传入XunleiPayId，解析出日期
     * @return
     */
    public static String spiltRuleDate(String xunleiPayId) {
        SimpleDateFormat sdf = new SimpleDateFormat(DATEPATTERN);
        SimpleDateFormat sdfFormat = new SimpleDateFormat(DATEFORMAT);
        try {
            if (null == xunleiPayId || xunleiPayId.length() == 0) {
                return null;
            }
            return sdf.format(sdfFormat.parse(xunleiPayId.substring(0, 6)));//截取xunleiPayId的前6位为日期
        } catch (Exception e) {
            logger.error("error;DateTimeUtils.spiltRuleDate method:" + e.toString());
            return null;
        }
    }

    /**
     * 若日期为空则初始化日期,同时判断日期格式是否正确
     * @param date
     * @return
     */
    public static String formatRuleDate(String date) {
        SimpleDateFormat sdf = new SimpleDateFormat(DATEPATTERN);
        try {
            if (null == date || date.length() == 0) {
                return sdf.format(new Date());
            }
            try {
                sdf.parse(date);
            } catch (ParseException e) {
                //日期格式错误重新输出正确日期
                return sdf.format(new Date());
            }
        }catch (Exception e){
            logger.error("error;DateTimeUtils.formatRuleDate method:"+e.toString());
        }
        return date;
    }


    /**
     * 动态根据对象赋值分片日期给分片字段
     * @param obj
     * @param filed
     * @version dev
     */
    public static void initRuleDate(Object obj, String filed) {
        try {
            Class clazz = obj.getClass();
            PropertyDescriptor pd = new PropertyDescriptor(filed, clazz);
            Method method = pd.getReadMethod();//获得get方法
            if (pd != null) {
                Object o = method.invoke(obj);//执行get方法返回一个Object
                String ruleDate = formatRuleDate(o==null?"":o.toString());//获取ruleDate
                Field[] fields = clazz.getDeclaredFields();
                boolean isContain=false;
                for(Field fReult:fields){
                    if(fReult.getName().equals(filed)){
                        isContain=true;
                        break;
                    }
                }
                Field f = null;
                if(isContain){
                    f = obj.getClass().getDeclaredField(filed);
                }
                else{
                    f = obj.getClass().getSuperclass().getDeclaredField(filed);
                }

                f.setAccessible(true);
                //修改属性，传入要设置的对象和值
                f.set(obj, ruleDate);
            }
        } catch (Exception e) {
            e.printStackTrace();
            logger.error("error;DateTimeUtils.initRuleDate method:"+e.toString());
        }
    }
}
